/*
 * Decompiled with CFR 0.152.
 */
package net.wanmine.wab.init.gen.assets;

import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.wanmine.wab.WanAncientBeasts;
import net.wanmine.wab.block.AncientSkull;
import net.wanmine.wab.block.BeastEggBlock;
import net.wanmine.wab.init.world.WabBlocks;

public class WabBlockStateGenerator
extends BlockStateProvider {
    public WabBlockStateGenerator(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "wan_ancient_beasts", exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.beastEgg(WabBlocks.EATER_EGG);
        this.beastEgg(WabBlocks.WALKER_EGG);
        this.beastEgg(WabBlocks.CRUSHER_EGG);
        this.beastEgg(WabBlocks.GLIDER_EGG);
        this.beastEgg(WabBlocks.SOARER_EGG);
        this.beastEgg(WabBlocks.SURFER_EGG);
        this.simpleBlock(WabBlocks.QUICK_SAND, this.resource("quick_sand"));
        this.simpleBlock(WabBlocks.QUICK_RED_SAND, this.resource("quick_red_sand"));
        this.simpleBlock(WabBlocks.FROZEN_STRAW_BLOCK, this.resource("frozen_straw"));
        this.simpleBlock(WabBlocks.STRAW_BLOCK, this.resource("straw"));
        this.stairsBlock((StairBlock)WabBlocks.STRAW_STAIRS.get(), this.resource("straw"));
        this.slabBlock((SlabBlock)WabBlocks.STRAW_SLAB.get(), this.resource("straw_block"), this.resource("straw"));
        this.suspiciousBlock(WabBlocks.SUSPICIOUS_RED_SAND);
        this.suspiciousBlock(WabBlocks.SUSPICIOUS_ICE);
        this.singleModel(WabBlocks.SNIFFER_SKULL);
        this.singleModel(WabBlocks.EATER_SKULL);
        this.singleModel(WabBlocks.WALKER_SKULL);
        this.singleModel(WabBlocks.CRUSHER_SKULL);
        this.singleModel(WabBlocks.GLIDER_SKULL);
        this.singleModel(WabBlocks.SOARER_SKULL);
        this.singleModel(WabBlocks.SURFER_SKULL);
        this.singleModel(WabBlocks.CHARGER_SKULL);
        this.singleModel(WabBlocks.RAIDER_SKULL);
    }

    public void simpleBlock(DeferredBlock<?> block, ResourceLocation texture) {
        this.simpleBlock((Block)block.get(), (ModelFile)this.models().cubeAll(block.getKey().location().getPath(), texture));
    }

    public void singleModel(DeferredBlock<?> block) {
        this.singleModel(block, block.getKey().location());
    }

    public void singleModel(DeferredBlock<?> block, ResourceLocation model) {
        this.simpleBlock((Block)block.get(), (ModelFile)this.models().getExistingFile(model));
    }

    public void beastEgg(DeferredBlock<? extends BeastEggBlock<?>> block, ModelFile hatch0, ModelFile hatch1, ModelFile hatch2) {
        this.getVariantBuilder((Block)block.get()).partialState().with((Property)BeastEggBlock.HATCH, (Comparable)Integer.valueOf(0)).addModels(new ConfiguredModel[]{new ConfiguredModel(hatch0)}).partialState().with((Property)BeastEggBlock.HATCH, (Comparable)Integer.valueOf(1)).addModels(new ConfiguredModel[]{new ConfiguredModel(hatch1)}).partialState().with((Property)BeastEggBlock.HATCH, (Comparable)Integer.valueOf(2)).addModels(new ConfiguredModel[]{new ConfiguredModel(hatch2)});
    }

    public void beastEgg(DeferredBlock<? extends BeastEggBlock<?>> block) {
        String name = block.getKey().location().getPath();
        AABB bound = ((BeastEggBlock)((Object)block.get())).shape.bounds();
        this.beastEgg(block, (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name + "_not_cracked", this.resource("beast_egg"))).texture("north", this.resource(name + "_not_cracked_north"))).texture("east", this.resource(name + "_not_cracked_east"))).texture("west", this.resource(name + "_not_cracked_west"))).texture("south", this.resource(name + "_not_cracked_south"))).texture("up", this.resource(name + "_not_cracked_top"))).texture("down", this.resource(name + "_not_cracked_bottom"))).element().from((float)bound.minX * 16.0f, (float)bound.minY * 16.0f, (float)bound.minZ * 16.0f).to((float)bound.maxX * 16.0f, (float)bound.maxY * 16.0f, (float)bound.maxZ * 16.0f).allFaces((direction, faceBuilder) -> {
            if (direction.getAxis() == Direction.Axis.Y) {
                faceBuilder.uvs(0.0f, 0.0f, (float)bound.getXsize() * 16.0f, (float)bound.getZsize() * 16.0f);
            } else if (direction.getAxis() == Direction.Axis.X) {
                faceBuilder.uvs(0.0f, (float)(16.0 - bound.getYsize() * 16.0), (float)bound.getZsize() * 16.0f, (float)bound.getYsize() * 16.0f);
            } else {
                faceBuilder.uvs(0.0f, (float)(16.0 - bound.getYsize() * 16.0), (float)bound.getXsize() * 16.0f, (float)bound.getYsize() * 16.0f);
            }
            faceBuilder.texture("#" + direction.getName());
        }).end(), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name + "_slightly_cracked", this.resource("beast_egg"))).texture("north", this.resource(name + "_slightly_cracked_north"))).texture("east", this.resource(name + "_slightly_cracked_east"))).texture("west", this.resource(name + "_slightly_cracked_west"))).texture("south", this.resource(name + "_slightly_cracked_south"))).texture("up", this.resource(name + "_slightly_cracked_top"))).texture("down", this.resource(name + "_slightly_cracked_bottom"))).element().from((float)bound.minX * 16.0f, (float)bound.minY * 16.0f, (float)bound.minZ * 16.0f).to((float)bound.maxX * 16.0f, (float)bound.maxY * 16.0f, (float)bound.maxZ * 16.0f).allFaces((direction, faceBuilder) -> {
            if (direction.getAxis() == Direction.Axis.Y) {
                faceBuilder.uvs(0.0f, 0.0f, (float)bound.getXsize() * 16.0f, (float)bound.getZsize() * 16.0f);
            } else if (direction.getAxis() == Direction.Axis.X) {
                faceBuilder.uvs(0.0f, (float)(16.0 - bound.getYsize() * 16.0), (float)bound.getZsize() * 16.0f, (float)bound.getYsize() * 16.0f);
            } else {
                faceBuilder.uvs(0.0f, (float)(16.0 - bound.getYsize() * 16.0), (float)bound.getXsize() * 16.0f, (float)bound.getYsize() * 16.0f);
            }
            faceBuilder.texture("#" + direction.getName());
        }).end(), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name + "_very_cracked", this.resource("beast_egg"))).texture("north", this.resource(name + "_very_cracked_north"))).texture("east", this.resource(name + "_very_cracked_east"))).texture("west", this.resource(name + "_very_cracked_west"))).texture("south", this.resource(name + "_very_cracked_south"))).texture("up", this.resource(name + "_very_cracked_top"))).texture("down", this.resource(name + "_very_cracked_bottom"))).element().from((float)bound.minX * 16.0f, (float)bound.minY * 16.0f, (float)bound.minZ * 16.0f).to((float)bound.maxX * 16.0f, (float)bound.maxY * 16.0f, (float)bound.maxZ * 16.0f).allFaces((direction, faceBuilder) -> {
            if (direction.getAxis() == Direction.Axis.Y) {
                faceBuilder.uvs(0.0f, 0.0f, (float)bound.getXsize() * 16.0f, (float)bound.getZsize() * 16.0f);
            } else if (direction.getAxis() == Direction.Axis.X) {
                faceBuilder.uvs(0.0f, (float)(16.0 - bound.getYsize() * 16.0), (float)bound.getZsize() * 16.0f, (float)bound.getYsize() * 16.0f);
            } else {
                faceBuilder.uvs(0.0f, (float)(16.0 - bound.getYsize() * 16.0), (float)bound.getXsize() * 16.0f, (float)bound.getYsize() * 16.0f);
            }
            faceBuilder.texture("#" + direction.getName());
        }).end());
    }

    public void suspiciousBlock(DeferredBlock<?> block) {
        String name = block.getKey().location().getPath();
        this.suspiciousBlock(block, (ModelFile)this.models().cubeAll(name + "_0", this.resource(name + "_0")), (ModelFile)this.models().cubeAll(name + "_1", this.resource(name + "_1")), (ModelFile)this.models().cubeAll(name + "_2", this.resource(name + "_2")), (ModelFile)this.models().cubeAll(name + "_3", this.resource(name + "_3")));
    }

    public void suspiciousBlock(DeferredBlock<?> block, ModelFile dusted0, ModelFile dusted1, ModelFile dusted2, ModelFile dusted3) {
        this.getVariantBuilder((Block)block.get()).partialState().with((Property)BlockStateProperties.DUSTED, (Comparable)Integer.valueOf(0)).addModels(new ConfiguredModel[]{new ConfiguredModel(dusted0)}).partialState().with((Property)BlockStateProperties.DUSTED, (Comparable)Integer.valueOf(1)).addModels(new ConfiguredModel[]{new ConfiguredModel(dusted1)}).partialState().with((Property)BlockStateProperties.DUSTED, (Comparable)Integer.valueOf(2)).addModels(new ConfiguredModel[]{new ConfiguredModel(dusted2)}).partialState().with((Property)BlockStateProperties.DUSTED, (Comparable)Integer.valueOf(3)).addModels(new ConfiguredModel[]{new ConfiguredModel(dusted3)});
    }

    public void ancientSkull(DeferredBlock<AncientSkull> block) {
        String name = block.getKey().location().getPath();
        this.simpleBlock((Block)block.get(), (ModelFile)((BlockModelBuilder)this.models().withExistingParent(name, this.resource("ancient_skull"))).texture("particle", this.resource(name)));
    }

    private ResourceLocation resource(String name) {
        return WanAncientBeasts.resource("block/" + name);
    }
}

