/*
 * Decompiled with CFR 0.152.
 */
package net.wanmine.wab.init.world;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SolidBucketItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BrushableBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.wanmine.wab.block.AncientSkull;
import net.wanmine.wab.block.BeastEggBlock;
import net.wanmine.wab.block.CrusherSpike;
import net.wanmine.wab.block.Nest;
import net.wanmine.wab.block.QuickSand;
import net.wanmine.wab.block.SuspiciousIce;
import net.wanmine.wab.block.entity.AncientSkullEntity;
import net.wanmine.wab.block.entity.SuspiciousIceEntity;
import net.wanmine.wab.entity.Crusher;
import net.wanmine.wab.entity.Eater;
import net.wanmine.wab.entity.Glider;
import net.wanmine.wab.entity.Soarer;
import net.wanmine.wab.entity.Surfer;
import net.wanmine.wab.entity.Walker;
import net.wanmine.wab.init.world.WabEntities;
import net.wanmine.wab.init.world.WabItems;
import net.wanmine.wab.item.AncientSkullItem;

public class WabBlocks {
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"wan_ancient_beasts");
    public static final DeferredBlock<BeastEggBlock<Eater>> EATER_EGG = WabBlocks.registerBlockItem("eater_egg", () -> new BeastEggBlock(WabEntities.EATER, BeastEggBlock.EATER_EGG_SHAPE, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_RED)));
    public static final DeferredBlock<BeastEggBlock<Walker>> WALKER_EGG = WabBlocks.registerBlockItem("walker_egg", () -> new BeastEggBlock(WabEntities.WALKER, BeastEggBlock.WALKER_EGG_SHAPE, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLUE)));
    public static final DeferredBlock<BeastEggBlock<Crusher>> CRUSHER_EGG = WabBlocks.registerBlockItem("crusher_egg", () -> new BeastEggBlock(WabEntities.CRUSHER, BeastEggBlock.CRUSHER_EGG_SHAPE, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_YELLOW)));
    public static final DeferredBlock<BeastEggBlock<Glider>> GLIDER_EGG = WabBlocks.registerBlockItem("glider_egg", () -> new BeastEggBlock(WabEntities.GLIDER, BeastEggBlock.GLIDER_EGG_SHAPE, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_LIGHT_GREEN)));
    public static final DeferredBlock<BeastEggBlock<Soarer>> SOARER_EGG = WabBlocks.registerBlockItem("soarer_egg", () -> new BeastEggBlock(WabEntities.SOARER, BeastEggBlock.SOARER_EGG_SHAPE, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_RED)));
    public static final DeferredBlock<BeastEggBlock<Surfer>> SURFER_EGG = WabBlocks.registerBlockItem("surfer_egg", () -> new BeastEggBlock(WabEntities.SURFER, BeastEggBlock.SURFER_EGG_SHAPE, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_LIGHT_BLUE)));
    public static final DeferredBlock<CrusherSpike> CRUSHER_SPIKE = WabBlocks.registerBlockItem("crusher_spike", () -> new CrusherSpike(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_YELLOW).forceSolidOn().instrument(NoteBlockInstrument.BASEDRUM).noOcclusion().sound(SoundType.POINTED_DRIPSTONE).strength(1.5f, 3.0f).dynamicShape().pushReaction(PushReaction.DESTROY).isRedstoneConductor(WabBlocks::never)));
    public static final DeferredBlock<Nest> NEST = WabBlocks.registerBlockItem("nest", () -> new Nest(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BROWN).instrument(NoteBlockInstrument.BASS).strength(0.6f).sound(SoundType.MANGROVE_ROOTS).pushReaction(PushReaction.DESTROY)));
    public static final DeferredBlock<BrushableBlock> SUSPICIOUS_RED_SAND = WabBlocks.registerBlockItem("suspicious_red_sand", () -> new BrushableBlock(Blocks.RED_SAND, SoundEvents.BRUSH_SAND, SoundEvents.BRUSH_SAND_COMPLETED, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_ORANGE).instrument(NoteBlockInstrument.SNARE).strength(0.25f).sound(SoundType.SUSPICIOUS_SAND).pushReaction(PushReaction.DESTROY)));
    public static final DeferredBlock<SuspiciousIce> SUSPICIOUS_ICE = WabBlocks.registerBlockItem("suspicious_ice", () -> new SuspiciousIce(BlockBehaviour.Properties.of().mapColor(MapColor.ICE).instrument(NoteBlockInstrument.CHIME).friction(0.98f).strength(0.25f).sound(SoundType.GLASS).pushReaction(PushReaction.DESTROY)));
    public static final DeferredBlock<QuickSand> QUICK_SAND = BLOCKS.register("quick_sand", () -> new QuickSand((Supplier<SolidBucketItem>)WabItems.QUICK_SAND_BUCKET, -522861418, BlockBehaviour.Properties.of().mapColor(MapColor.SAND).strength(0.5f).speedFactor(0.4f).sound(SoundType.SAND).dynamicShape().isRedstoneConductor(WabBlocks::never)));
    public static final DeferredBlock<QuickSand> QUICK_RED_SAND = BLOCKS.register("quick_red_sand", () -> new QuickSand((Supplier<SolidBucketItem>)WabItems.QUICK_RED_SAND_BUCKET, -525180897, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_ORANGE).strength(0.5f).speedFactor(0.4f).sound(SoundType.SAND).dynamicShape().isRedstoneConductor(WabBlocks::never)));
    public static final DeferredBlock<Block> FROZEN_STRAW_BLOCK = WabBlocks.registerBlockItem("frozen_straw_block", () -> new Block(BlockBehaviour.Properties.of().mapColor(MapColor.ICE).instrument(NoteBlockInstrument.SNARE).strength(0.6f).sound(SoundType.GLASS)));
    public static final DeferredBlock<Block> STRAW_BLOCK = WabBlocks.registerBlockItem("straw_block", () -> new Block(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BROWN).instrument(NoteBlockInstrument.BASS).strength(0.6f).sound(SoundType.MANGROVE_ROOTS).ignitedByLava()));
    public static final DeferredBlock<SlabBlock> STRAW_SLAB = WabBlocks.registerBlockItem("straw_slab", () -> new SlabBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BROWN).instrument(NoteBlockInstrument.BASS).strength(0.6f).sound(SoundType.MANGROVE_ROOTS).ignitedByLava()));
    public static final DeferredBlock<StairBlock> STRAW_STAIRS = WabBlocks.registerBlockItem("straw_stairs", () -> new StairBlock(((Block)STRAW_BLOCK.get()).defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)STRAW_BLOCK.get()))));
    public static final DeferredBlock<AncientSkull> SNIFFER_SKULL = WabBlocks.registerSkull("sniffer_skull", AncientSkull.Type.SNIFFER.name, () -> new AncientSkull(AncientSkull.Type.SNIFFER, BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.SKELETON).strength(1.0f).pushReaction(PushReaction.DESTROY).noOcclusion()));
    public static final DeferredBlock<AncientSkull> EATER_SKULL = WabBlocks.registerSkull("eater_skull", AncientSkull.Type.EATER.name, () -> new AncientSkull(AncientSkull.Type.EATER, BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.SKELETON).strength(1.0f).pushReaction(PushReaction.DESTROY).noOcclusion()));
    public static final DeferredBlock<AncientSkull> WALKER_SKULL = WabBlocks.registerSkull("walker_skull", AncientSkull.Type.WALKER.name, () -> new AncientSkull(AncientSkull.Type.WALKER, BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.SKELETON).strength(1.0f).pushReaction(PushReaction.DESTROY).noOcclusion()));
    public static final DeferredBlock<AncientSkull> CRUSHER_SKULL = WabBlocks.registerSkull("crusher_skull", AncientSkull.Type.CRUSHER.name, () -> new AncientSkull(AncientSkull.Type.CRUSHER, BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.SKELETON).strength(1.0f).pushReaction(PushReaction.DESTROY).noOcclusion()));
    public static final DeferredBlock<AncientSkull> GLIDER_SKULL = WabBlocks.registerSkull("glider_skull", AncientSkull.Type.GLIDER.name, () -> new AncientSkull(AncientSkull.Type.GLIDER, BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.SKELETON).strength(1.0f).pushReaction(PushReaction.DESTROY).noOcclusion()));
    public static final DeferredBlock<AncientSkull> SOARER_SKULL = WabBlocks.registerSkull("soarer_skull", AncientSkull.Type.SOARER.name, () -> new AncientSkull(AncientSkull.Type.SOARER, BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.SKELETON).strength(1.0f).pushReaction(PushReaction.DESTROY).noOcclusion()));
    public static final DeferredBlock<AncientSkull> CHARGER_SKULL = WabBlocks.registerSkull("charger_skull", AncientSkull.Type.CHARGER.name, () -> new AncientSkull(AncientSkull.Type.CHARGER, BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.SKELETON).strength(1.0f).pushReaction(PushReaction.DESTROY).noOcclusion()));
    public static final DeferredBlock<AncientSkull> SURFER_SKULL = WabBlocks.registerSkull("surfer_skull", AncientSkull.Type.SURFER.name, () -> new AncientSkull(AncientSkull.Type.SURFER, BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.SKELETON).strength(1.0f).pushReaction(PushReaction.DESTROY).noOcclusion()));
    public static final DeferredBlock<AncientSkull> RAIDER_SKULL = WabBlocks.registerSkull("raider_skull", AncientSkull.Type.RAIDER.name, () -> new AncientSkull(AncientSkull.Type.RAIDER, BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.SKELETON).strength(1.0f).pushReaction(PushReaction.DESTROY).noOcclusion()));

    private static boolean never(BlockState state, BlockGetter getter, BlockPos pos) {
        return false;
    }

    private static boolean always(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos) {
        return true;
    }

    private static <T extends Block> DeferredBlock<T> registerBlockItem(String name, Supplier<T> block) {
        DeferredBlock toReturn = BLOCKS.register(name, block);
        WabBlocks.registerItem(name, toReturn);
        return toReturn;
    }

    private static DeferredBlock<AncientSkull> registerSkull(String name, String skullName, Supplier<AncientSkull> block) {
        DeferredBlock toReturn = BLOCKS.register(name, block);
        WabItems.ITEMS.register(name, () -> new AncientSkullItem((AncientSkull)((Object)((Object)toReturn.get())), skullName, new Item.Properties().stacksTo(1)));
        return toReturn;
    }

    private static <T extends Block> void registerItem(String name, DeferredBlock<T> block) {
        WabItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    public class Entities {
        public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITIES = DeferredRegister.create((ResourceKey)Registries.BLOCK_ENTITY_TYPE, (String)"wan_ancient_beasts");
        public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<SuspiciousIceEntity>> SUSPICIOUS_ICE = BLOCK_ENTITIES.register("suspicious_ice", () -> BlockEntityType.Builder.of(SuspiciousIceEntity::new, (Block[])new Block[]{(Block)SUSPICIOUS_ICE.get()}).build(null));
        public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<AncientSkullEntity>> SNIFFER_SKULL = BLOCK_ENTITIES.register("sniffer_skull", () -> BlockEntityType.Builder.of((pos, state) -> new AncientSkullEntity(AncientSkull.Type.SNIFFER, pos, state), (Block[])new Block[]{(Block)SNIFFER_SKULL.get()}).build(null));
        public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<AncientSkullEntity>> EATER_SKULL = BLOCK_ENTITIES.register("eater_skull", () -> BlockEntityType.Builder.of((pos, state) -> new AncientSkullEntity(AncientSkull.Type.EATER, pos, state), (Block[])new Block[]{(Block)EATER_SKULL.get()}).build(null));
        public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<AncientSkullEntity>> WALKER_SKULL = BLOCK_ENTITIES.register("walker_skull", () -> BlockEntityType.Builder.of((pos, state) -> new AncientSkullEntity(AncientSkull.Type.WALKER, pos, state), (Block[])new Block[]{(Block)WALKER_SKULL.get()}).build(null));
        public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<AncientSkullEntity>> CRUSHER_SKULL = BLOCK_ENTITIES.register("crusher_skull", () -> BlockEntityType.Builder.of((pos, state) -> new AncientSkullEntity(AncientSkull.Type.CRUSHER, pos, state), (Block[])new Block[]{(Block)CRUSHER_SKULL.get()}).build(null));
        public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<AncientSkullEntity>> GLIDER_SKULL = BLOCK_ENTITIES.register("glider_skull", () -> BlockEntityType.Builder.of((pos, state) -> new AncientSkullEntity(AncientSkull.Type.GLIDER, pos, state), (Block[])new Block[]{(Block)GLIDER_SKULL.get()}).build(null));
        public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<AncientSkullEntity>> SOARER_SKULL = BLOCK_ENTITIES.register("soarer_skull", () -> BlockEntityType.Builder.of((pos, state) -> new AncientSkullEntity(AncientSkull.Type.SOARER, pos, state), (Block[])new Block[]{(Block)SOARER_SKULL.get()}).build(null));
        public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<AncientSkullEntity>> CHARGER_SKULL = BLOCK_ENTITIES.register("charger_skull", () -> BlockEntityType.Builder.of((pos, state) -> new AncientSkullEntity(AncientSkull.Type.CHARGER, pos, state), (Block[])new Block[]{(Block)CHARGER_SKULL.get()}).build(null));
        public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<AncientSkullEntity>> SURFER_SKULL = BLOCK_ENTITIES.register("surfer_skull", () -> BlockEntityType.Builder.of((pos, state) -> new AncientSkullEntity(AncientSkull.Type.SURFER, pos, state), (Block[])new Block[]{(Block)SURFER_SKULL.get()}).build(null));
        public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<AncientSkullEntity>> RAIDER_SKULL = BLOCK_ENTITIES.register("raider_skull", () -> BlockEntityType.Builder.of((pos, state) -> new AncientSkullEntity(AncientSkull.Type.RAIDER, pos, state), (Block[])new Block[]{(Block)RAIDER_SKULL.get()}).build(null));

        public Entities(WabBlocks this$0) {
        }
    }
}

