/*
 * Decompiled with CFR 0.152.
 */
package net.wanmine.wab.init.world;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.MobBucketItem;
import net.minecraft.world.item.SmithingTemplateItem;
import net.minecraft.world.item.SolidBucketItem;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.wanmine.wab.WanAncientBeasts;
import net.wanmine.wab.init.data.WabTrims;
import net.wanmine.wab.init.world.WabBlocks;
import net.wanmine.wab.init.world.WabEntities;
import net.wanmine.wab.init.world.WabTiers;
import net.wanmine.wab.item.AncientClub;
import net.wanmine.wab.item.Chisel;
import net.wanmine.wab.item.FrozenAncientMeat;
import net.wanmine.wab.item.HangGlider;
import net.wanmine.wab.item.ReinforcedShield;

public class WabItems {
    public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"wan_ancient_beasts");
    public static final DeferredItem<Chisel> CHISEL = ITEMS.register("chisel", () -> new Chisel(new Item.Properties().durability(64)));
    public static final DeferredItem<Item> EATER_TOOTH = ITEMS.register("eater_tooth", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> GLIDER_FEATHER = ITEMS.register("glider_feather", () -> new Item(new Item.Properties()));
    public static final DeferredItem<HangGlider> HANG_GLIDER = ITEMS.register("hang_glider", () -> new HangGlider(new Item.Properties().durability(100)));
    public static final DeferredItem<AncientClub> ANCIENT_CLUB = ITEMS.register("ancient_club", () -> new AncientClub((Tier)WabTiers.EATER_TOOTH, new Item.Properties().attributes(SwordItem.createAttributes((Tier)WabTiers.EATER_TOOTH, (int)3, (float)-3.0f))));
    public static final DeferredItem<ReinforcedShield> REINFORCED_SHIELD = ITEMS.register("reinforced_shield", () -> new ReinforcedShield(new Item.Properties().durability(400)));
    public static final DeferredItem<ArmorItem> SURFER_ARMOR = ITEMS.register("surfer_armor", () -> new ArmorItem(ArmorMaterials.TURTLE, ArmorItem.Type.BODY, new Item.Properties().stacksTo(1).durability(300)));
    public static final DeferredItem<Item> ANCIENT_UPGRADE_SMITHING_TEMPLATE = ITEMS.register("ancient_upgrade_smithing_template", () -> new SmithingTemplateItem((Component)Component.translatable((String)Util.makeDescriptionId((String)"item", (ResourceLocation)WanAncientBeasts.resource("smithing_template.ancient_upgrade.applies_to"))).withStyle(ChatFormatting.BLUE), (Component)Component.translatable((String)Util.makeDescriptionId((String)"item", (ResourceLocation)WanAncientBeasts.resource("smithing_template.ancient_upgrade.ingredients"))).withStyle(ChatFormatting.BLUE), (Component)Component.translatable((String)Util.makeDescriptionId((String)"upgrade", (ResourceLocation)WanAncientBeasts.resource("ancient_upgrade"))).withStyle(ChatFormatting.GRAY), (Component)Component.translatable((String)Util.makeDescriptionId((String)"item", (ResourceLocation)WanAncientBeasts.resource("smithing_template.ancient_upgrade.base_slot_description"))), (Component)Component.translatable((String)Util.makeDescriptionId((String)"item", (ResourceLocation)WanAncientBeasts.resource("smithing_template.ancient_upgrade.additions_slot_description"))), List.of(ResourceLocation.withDefaultNamespace((String)"item/empty_armor_slot_shield")), List.of(WanAncientBeasts.resource("item/empty_slot_spike")), new FeatureFlag[0]));
    public static final DeferredItem<SolidBucketItem> QUICK_SAND_BUCKET = ITEMS.register("quick_sand_bucket", () -> new SolidBucketItem((Block)WabBlocks.QUICK_SAND.get(), SoundEvents.SAND_PLACE, new Item.Properties().stacksTo(1)));
    public static final DeferredItem<SolidBucketItem> QUICK_RED_SAND_BUCKET = ITEMS.register("quick_red_sand_bucket", () -> new SolidBucketItem((Block)WabBlocks.QUICK_RED_SAND.get(), SoundEvents.SAND_PLACE, new Item.Properties().stacksTo(1)));
    public static final DeferredItem<SmithingTemplateItem> SNIFF_ARMOR_TRIM_SMITHING_TEMPLATE = ITEMS.register("sniff_armor_trim_smithing_template", () -> SmithingTemplateItem.createArmorTrimTemplate(WabTrims.SNIFF, (FeatureFlag[])new FeatureFlag[0]));
    public static final DeferredItem<SmithingTemplateItem> SPIKE_ARMOR_TRIM_SMITHING_TEMPLATE = ITEMS.register("spike_armor_trim_smithing_template", () -> SmithingTemplateItem.createArmorTrimTemplate(WabTrims.SPIKE, (FeatureFlag[])new FeatureFlag[0]));
    public static final DeferredItem<FrozenAncientMeat> FROZEN_ANCIENT_MEAT = ITEMS.register("frozen_ancient_meat", () -> new FrozenAncientMeat(new Item.Properties().food(new FoodProperties.Builder().nutrition(2).saturationModifier(0.1f).build())));
    public static final DeferredItem<Item> RAW_ANCIENT_MEAT = ITEMS.register("raw_ancient_meat", () -> new Item(new Item.Properties().food(new FoodProperties.Builder().nutrition(6).saturationModifier(8.0f).build())));
    public static final DeferredItem<Item> COOKED_ANCIENT_MEAT = ITEMS.register("cooked_ancient_meat", () -> new Item(new Item.Properties().food(new FoodProperties.Builder().nutrition(10).saturationModifier(15.0f).build())));
    public static final DeferredItem<Item> TOXLACANTH_BUCKET = ITEMS.register("toxlacanth_bucket", () -> new MobBucketItem((EntityType)WabEntities.TOXLACANTH.get(), (Fluid)Fluids.WATER, SoundEvents.BUCKET_EMPTY_FISH, new Item.Properties().stacksTo(1)));
    public static final DeferredItem<Item> TOXLACANTH = ITEMS.register("toxlacanth", () -> new Item(new Item.Properties().food(new FoodProperties.Builder().nutrition(1).effect(new MobEffectInstance(MobEffects.WEAKNESS, 1200), 1.0f).effect(new MobEffectInstance(MobEffects.POISON, 600), 1.0f).effect(new MobEffectInstance(MobEffects.CONFUSION, 300), 1.0f).build())));
    public static final DeferredItem<Item> COOKED_TOXLACANTH = ITEMS.register("cooked_toxlacanth", () -> new Item(new Item.Properties().food(new FoodProperties.Builder().nutrition(7).saturationModifier(0.8f).effect(new MobEffectInstance(MobEffects.CONFUSION, 200), 1.0f).build())));
    public static final DeferredItem<Item> JAW_POTTERY_SHERD = ITEMS.register("jaw_pottery_sherd", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> SPIKE_POTTERY_SHERD = ITEMS.register("spike_pottery_sherd", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> STROLL_POTTERY_SHERD = ITEMS.register("stroll_pottery_sherd", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> BEAK_POTTERY_SHERD = ITEMS.register("beak_pottery_sherd", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> FALL_POTTERY_SHERD = ITEMS.register("fall_pottery_sherd", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> FOSSIL_POTTERY_SHERD = ITEMS.register("fossil_pottery_sherd", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> TIDE_POTTERY_SHERD = ITEMS.register("tide_pottery_sherd", () -> new Item(new Item.Properties()));
    public static final DeferredItem<SpawnEggItem> EATER_SPAWN_EGG = ITEMS.register("eater_spawn_egg", () -> new SpawnEggItem((EntityType)WabEntities.EATER.get(), 6111281, 10385713, new Item.Properties()));
    public static final DeferredItem<SpawnEggItem> WALKER_SPAWN_EGG = ITEMS.register("walker_spawn_egg", () -> new SpawnEggItem((EntityType)WabEntities.WALKER.get(), 5742028, 5915545, new Item.Properties()));
    public static final DeferredItem<SpawnEggItem> CRUSHER_SPAWN_EGG = ITEMS.register("crusher_spawn_egg", () -> new SpawnEggItem((EntityType)WabEntities.CRUSHER.get(), 14390591, 7769740, new Item.Properties()));
    public static final DeferredItem<SpawnEggItem> GLIDER_SPAWN_EGG = ITEMS.register("glider_spawn_egg", () -> new SpawnEggItem((EntityType)WabEntities.GLIDER.get(), 4305842, 8764471, new Item.Properties()));
    public static final DeferredItem<SpawnEggItem> SOARER_SPAWN_EGG = ITEMS.register("soarer_spawn_egg", () -> new SpawnEggItem((EntityType)WabEntities.SOARER.get(), 2636883, 0x992929, new Item.Properties()));
    public static final DeferredItem<SpawnEggItem> SURFER_SPAWN_EGG = ITEMS.register("surfer_spawn_egg", () -> new SpawnEggItem((EntityType)WabEntities.SURFER.get(), 7644045, 12824430, new Item.Properties()));
    public static final DeferredItem<SpawnEggItem> PALEONTOLOGIST_SPAWN_EGG = ITEMS.register("paleontologist_spawn_egg", () -> new SpawnEggItem((EntityType)WabEntities.PALEONTOLOGIST.get(), 3942947, 12486764, new Item.Properties()));
    public static final DeferredItem<SpawnEggItem> TOXLACANTH_SPAWN_EGG = ITEMS.register("toxlacanth_spawn_egg", () -> new SpawnEggItem((EntityType)WabEntities.TOXLACANTH.get(), 3971921, 2320444, new Item.Properties()));
    public static final DeferredItem<HangGlider> WHITE_HANG_GLIDER = ITEMS.register("white_hang_glider", () -> new HangGlider(new Item.Properties().durability(100)));
    public static final DeferredItem<HangGlider> LIGHT_GRAY_HANG_GLIDER = ITEMS.register("light_gray_hang_glider", () -> new HangGlider(new Item.Properties().durability(100)));
    public static final DeferredItem<HangGlider> GRAY_HANG_GLIDER = ITEMS.register("gray_hang_glider", () -> new HangGlider(new Item.Properties().durability(100)));
    public static final DeferredItem<HangGlider> BLACK_HANG_GLIDER = ITEMS.register("black_hang_glider", () -> new HangGlider(new Item.Properties().durability(100)));
    public static final DeferredItem<HangGlider> BROWN_HANG_GLIDER = ITEMS.register("brown_hang_glider", () -> new HangGlider(new Item.Properties().durability(100)));
    public static final DeferredItem<HangGlider> RED_HANG_GLIDER = ITEMS.register("red_hang_glider", () -> new HangGlider(new Item.Properties().durability(100)));
    public static final DeferredItem<HangGlider> ORANGE_HANG_GLIDER = ITEMS.register("orange_hang_glider", () -> new HangGlider(new Item.Properties().durability(100)));
    public static final DeferredItem<HangGlider> YELLOW_HANG_GLIDER = ITEMS.register("yellow_hang_glider", () -> new HangGlider(new Item.Properties().durability(100)));
    public static final DeferredItem<HangGlider> LIME_HANG_GLIDER = ITEMS.register("lime_hang_glider", () -> new HangGlider(new Item.Properties().durability(100)));
    public static final DeferredItem<HangGlider> GREEN_HANG_GLIDER = ITEMS.register("green_hang_glider", () -> new HangGlider(new Item.Properties().durability(100)));
    public static final DeferredItem<HangGlider> LIGHT_BLUE_HANG_GLIDER = ITEMS.register("light_blue_hang_glider", () -> new HangGlider(new Item.Properties().durability(100)));
    public static final DeferredItem<HangGlider> CYAN_HANG_GLIDER = ITEMS.register("cyan_hang_glider", () -> new HangGlider(new Item.Properties().durability(100)));
    public static final DeferredItem<HangGlider> BLUE_HANG_GLIDER = ITEMS.register("blue_hang_glider", () -> new HangGlider(new Item.Properties().durability(100)));
    public static final DeferredItem<HangGlider> PURPLE_HANG_GLIDER = ITEMS.register("purple_hang_glider", () -> new HangGlider(new Item.Properties().durability(100)));
    public static final DeferredItem<HangGlider> MAGENTA_HANG_GLIDER = ITEMS.register("magenta_hang_glider", () -> new HangGlider(new Item.Properties().durability(100)));
    public static final DeferredItem<HangGlider> PINK_HANG_GLIDER = ITEMS.register("pink_hang_glider", () -> new HangGlider(new Item.Properties().durability(100)));
}

