/*
 * Decompiled with CFR 0.152.
 */
package net.wanmine.wab.recipe;

import net.minecraft.core.HolderLookup;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.wanmine.wab.init.data.WabRecipes;

public class SherdDuplicationRecipe
extends CustomRecipe {
    public SherdDuplicationRecipe(CraftingBookCategory pCategory) {
        super(pCategory);
    }

    public boolean matches(CraftingInput craftingInput, Level level) {
        boolean sherd = false;
        boolean hasBrick = false;
        for (int i = 0; i < craftingInput.size(); ++i) {
            ItemStack itemstack = craftingInput.getItem(i);
            if (itemstack.is(ItemTags.DECORATED_POT_SHERDS) && !sherd) {
                sherd = true;
                continue;
            }
            if (itemstack.is(Items.BRICK) && !hasBrick) {
                hasBrick = true;
                continue;
            }
            if (itemstack.is(Items.AIR)) continue;
            return false;
        }
        return sherd && hasBrick;
    }

    public ItemStack assemble(CraftingInput craftingInput, HolderLookup.Provider provider) {
        Item sherd = Items.BRICK;
        for (int i = 0; i < craftingInput.size(); ++i) {
            ItemStack itemstack = craftingInput.getItem(i);
            if (!itemstack.is(ItemTags.DECORATED_POT_SHERDS)) continue;
            sherd = itemstack.getItem();
        }
        return new ItemStack((ItemLike)sherd, 2);
    }

    public boolean canCraftInDimensions(int i, int i1) {
        return i * i1 >= 2;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)WabRecipes.SHERD_DUPLICATION.get();
    }
}

