/*
 * Decompiled with CFR 0.152.
 */
package net.wanmine.wab.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.wanmine.wab.init.data.WabDamageType;

public class CrusherSpike
extends DirectionalBlock {
    public static final MapCodec<CrusherSpike> CODEC = CrusherSpike.m_306223_(CrusherSpike::new);
    protected static final VoxelShape[] AABB = new VoxelShape[]{Block.m_49796_((double)5.0, (double)6.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0), Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)10.0, (double)11.0), Block.m_49796_((double)5.0, (double)5.0, (double)6.0, (double)11.0, (double)11.0, (double)16.0), Block.m_49796_((double)5.0, (double)5.0, (double)0.0, (double)11.0, (double)11.0, (double)10.0), Block.m_49796_((double)6.0, (double)5.0, (double)5.0, (double)16.0, (double)11.0, (double)11.0), Block.m_49796_((double)0.0, (double)5.0, (double)5.0, (double)10.0, (double)11.0, (double)11.0)};

    public CrusherSpike(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_52588_, (Comparable)Direction.DOWN));
    }

    protected MapCodec<? extends DirectionalBlock> m_304657_() {
        return CODEC;
    }

    public BlockState m_5573_(BlockPlaceContext placeContext) {
        return (BlockState)this.m_49966_().m_61124_((Property)f_52588_, (Comparable)placeContext.m_43719_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> blockStateBuilder) {
        blockStateBuilder.m_61104_(new Property[]{f_52588_});
    }

    public boolean m_7898_(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        return CrusherSpike.isValidPlaceableBlock(pLevel, pPos, (Direction)pState.m_61143_((Property)f_52588_));
    }

    public BlockState m_7417_(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pNeighborPos) {
        if (this.m_7898_(pState, (LevelReader)pLevel, pCurrentPos)) {
            return pState;
        }
        pLevel.m_46961_(pCurrentPos, true);
        return Blocks.f_50016_.m_49966_();
    }

    public void m_142072_(Level pLevel, BlockState pState, BlockPos pPos, Entity pEntity, float pFallDistance) {
        if (pState.m_61143_((Property)f_52588_) == Direction.UP) {
            pEntity.m_142535_(pFallDistance + 2.0f, 2.0f, WabDamageType.damageSource((LevelReader)pLevel, WabDamageType.CRUSHER_SPIKE));
        } else {
            super.m_142072_(pLevel, pState, pPos, pEntity, pFallDistance);
        }
    }

    public void m_7892_(BlockState blockState, Level level, BlockPos pos, Entity entity) {
        super.m_7892_(blockState, level, pos, entity);
        VoxelShape shape = blockState.m_60808_((BlockGetter)level, pos);
        AABB box = entity.m_20191_().m_82400_(0.001);
        if (shape.m_83299_().stream().map(aabb -> aabb.m_82386_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_())).anyMatch(arg_0 -> ((AABB)box).m_82381_(arg_0))) {
            entity.m_6469_(WabDamageType.damageSource((LevelReader)level, WabDamageType.CRUSHER_SPIKE), 3.0f);
        }
    }

    public static boolean isValidPlaceableBlock(LevelReader pLevel, BlockPos pPos, Direction pDir) {
        BlockPos blockpos = pPos.m_121945_(pDir.m_122424_());
        return pLevel.m_8055_(blockpos).m_60783_((BlockGetter)pLevel, blockpos, pDir);
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return AABB[((Direction)pState.m_61143_((Property)f_52588_)).m_122411_()];
    }

    public VoxelShape m_7952_(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return Shapes.m_83040_();
    }

    public boolean m_180643_(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return false;
    }

    public boolean m_7357_(BlockState state, BlockGetter getter, BlockPos pos, PathComputationType pathComputationType) {
        return false;
    }
}

