/*
 * Decompiled with CFR 0.152.
 */
package net.wanmine.wab.entity;

import java.util.Random;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsTargetGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.entity.PartEntity;
import net.wanmine.wab.block.BeastEggBlock;
import net.wanmine.wab.config.WabWorldConfig;
import net.wanmine.wab.entity.goals.eater.EaterAttackPlayerGoal;
import net.wanmine.wab.entity.goals.eater.EaterBreedGoal;
import net.wanmine.wab.entity.goals.eater.EaterMeleeAttackGoal;
import net.wanmine.wab.entity.goals.eater.EaterSleepingGoal;
import net.wanmine.wab.entity.goals.eater.RoarFirstGoal;
import net.wanmine.wab.entity.goals.eater.SleepingCheckGoal;
import net.wanmine.wab.entity.part.WabEntityPart;
import net.wanmine.wab.entity.part.WabEntityPartHead;
import net.wanmine.wab.init.data.WabTags;
import net.wanmine.wab.init.world.WabBlocks;
import net.wanmine.wab.init.world.WabEffects;
import net.wanmine.wab.init.world.WabEntities;
import net.wanmine.wab.init.world.WabItems;
import net.wanmine.wab.init.world.WabSounds;
import net.wanmine.wab.item.ReinforcedShield;
import net.wanmine.wab.network.PacketHandler;
import net.wanmine.wab.network.client.EaterAlphaPacket;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.constant.DefaultAnimations;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Eater
extends Animal
implements GeoEntity,
NeutralMob {
    public static final EntityDataAccessor<Integer> STATE = SynchedEntityData.m_135353_(Eater.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final RawAnimation BITE = RawAnimation.begin().thenPlay("attack.bite");
    private static final RawAnimation RUN = RawAnimation.begin().thenLoop("move.run");
    private static final RawAnimation SLEEP = RawAnimation.begin().thenLoop("misc.sleep");
    private static final RawAnimation START_SLEEP = RawAnimation.begin().thenPlay("misc.start_sleep");
    private static final RawAnimation WAKE_UP = RawAnimation.begin().thenPlay("misc.wake_up");
    private static final RawAnimation ROAR = RawAnimation.begin().thenPlay("attack.roar");
    private static final RawAnimation BABY = RawAnimation.begin().thenPlay("misc.baby");
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public static final EntityDataAccessor<Boolean> ROARED = SynchedEntityData.m_135353_(Eater.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> RUNNING = SynchedEntityData.m_135353_(Eater.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Integer> NOM_COUNT = SynchedEntityData.m_135353_(Eater.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> SLEEPING_TIME = SynchedEntityData.m_135353_(Eater.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> FUTURE_TARGET = SynchedEntityData.m_135353_(Eater.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Boolean> ALPHA = SynchedEntityData.m_135353_(Eater.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final WabEntityPart<Eater>[] subEntities;
    private final WabEntityPartHead<Eater> head = new WabEntityPartHead<Eater>(this, 1.3f, 1.4f, 2.0f, 1.5f);
    private final WabEntityPart<Eater> tail1 = new WabEntityPart<Eater>(this, 1.0f, 1.0f, 1.8f, 1.6f, 180.0f);
    private final WabEntityPart<Eater> tail2 = new WabEntityPart<Eater>(this, 1.0f, 1.0f, 2.8f, 1.4f, 180.0f);
    private final int NOM_COUNTER = 5;
    public int attackTick = -10;
    boolean isMoving = false;

    public Eater(EntityType<? extends Animal> animal, Level level) {
        super(animal, level);
        this.subEntities = new WabEntityPart[]{this.head, this.tail1, this.tail2};
        this.m_20234_(f_19843_.getAndAdd(this.subEntities.length + 1) + 1);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData groupData, @Nullable CompoundTag tag) {
        this.m_21051_(Attributes.f_22276_).m_22100_(((Double)WabWorldConfig.EATER_HEALTH.get()).doubleValue());
        this.m_21051_(Attributes.f_22281_).m_22100_(((Double)WabWorldConfig.EATER_DAMAGE.get()).doubleValue());
        this.m_21051_(Attributes.f_22284_).m_22100_(((Double)WabWorldConfig.EATER_ARMOR.get()).doubleValue());
        this.m_21051_(Attributes.f_22285_).m_22100_(((Double)WabWorldConfig.EATER_ARMOR_TOUGHNESS.get()).doubleValue());
        this.m_21153_(((Double)WabWorldConfig.EATER_HEALTH.get()).floatValue());
        return super.m_6518_(level, difficulty, spawnType, groupData, tag);
    }

    public static AttributeSupplier.Builder getDefaultAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, Attributes.f_22279_.m_22082_()).m_22268_(Attributes.f_22276_, 100.0).m_22268_(Attributes.f_22278_, 0.5).m_22268_(Attributes.f_22285_, 2.0).m_22268_(Attributes.f_22284_, 6.0).m_22268_(Attributes.f_22281_, 30.0).m_22268_(Attributes.f_22282_, 0.5).m_22268_(Attributes.f_22279_, 0.4).m_22268_(Attributes.f_22277_, 35.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ROARED, (Object)false);
        this.f_19804_.m_135372_(RUNNING, (Object)false);
        this.f_19804_.m_135372_(STATE, (Object)0);
        this.f_19804_.m_135372_(NOM_COUNT, (Object)0);
        this.f_19804_.m_135372_(SLEEPING_TIME, (Object)-1);
        this.f_19804_.m_135372_(FUTURE_TARGET, (Object)Integer.MIN_VALUE);
        this.f_19804_.m_135372_(ALPHA, (Object)false);
    }

    public void m_6457_(ServerPlayer player) {
        PacketHandler.sendToPlayer(new EaterAlphaPacket(this.m_19879_(), this.m_21023_((MobEffect)WabEffects.ALPHA.get())), player);
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_204117_(WabTags.Items.EATER_FOOD);
    }

    protected void m_8099_() {
        super.m_8099_();
        if (this.getNomCount() < 10) {
            this.f_21345_.m_25352_(0, (Goal)new SleepingCheckGoal(this, (Goal)new FloatGoal((Mob)this)));
            this.f_21345_.m_25352_(4, (Goal)new SleepingCheckGoal(this, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.4)));
            this.f_21345_.m_25352_(6, (Goal)new SleepingCheckGoal(this, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f)));
            this.f_21345_.m_25352_(7, (Goal)new SleepingCheckGoal(this, (Goal)new RandomLookAroundGoal((Mob)this)));
            this.f_21345_.m_25352_(2, (Goal)new SleepingCheckGoal(this, new EaterBreedGoal(this, 0.5)));
            this.f_21345_.m_25352_(3, (Goal)new SleepingCheckGoal(this, (Goal)new TemptGoal((PathfinderMob)this, 0.5, Ingredient.m_204132_(WabTags.Items.EATER_FOOD), false)));
            this.f_21345_.m_25352_(5, (Goal)new SleepingCheckGoal(this, (Goal)new RoarFirstGoal(this, Player.class, true)));
            this.f_21345_.m_25352_(2, (Goal)new SleepingCheckGoal(this, (Goal)new EaterAttackPlayerGoal(this, Player.class, true)));
            this.f_21345_.m_25352_(4, (Goal)new SleepingCheckGoal(this, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, true, entity -> !entity.m_6162_())));
            this.f_21345_.m_25352_(2, (Goal)new SleepingCheckGoal(this, (Goal)new NearestAttackableTargetGoal((Mob)this, Raider.class, false, false)));
            this.f_21345_.m_25352_(4, (Goal)new SleepingCheckGoal(this, (Goal)new NearestAttackableTargetGoal((Mob)this, Animal.class, true, entity -> !entity.m_6095_().m_204039_(WabTags.Entities.EATER_IGNORE))));
            this.f_21345_.m_25352_(2, (Goal)new SleepingCheckGoal(this, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0])));
            this.f_21345_.m_25352_(2, (Goal)new SleepingCheckGoal(this, (Goal)new MoveTowardsTargetGoal((PathfinderMob)this, (double)0.1f, 32.0f)));
            this.f_21345_.m_25352_(1, (Goal)new SleepingCheckGoal(this, (Goal)new EaterMeleeAttackGoal(this, 1.0, false)));
            this.f_21345_.m_25352_(5, (Goal)new SleepingCheckGoal(this, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, false)));
            this.f_21345_.m_25352_(5, (Goal)new EaterSleepingGoal(this));
        }
    }

    @Nullable
    public AgeableMob m_142606_(@NotNull ServerLevel level, @NotNull AgeableMob ageableMob) {
        return (AgeableMob)((EntityType)WabEntities.EATER.get()).m_20615_((Level)level);
    }

    public InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        if (itemstack.m_41720_() == WabItems.RAW_ANCIENT_MEAT.get()) {
            if (this.m_9236_().f_46443_) {
                return InteractionResult.CONSUME;
            }
            this.m_142075_(pPlayer, pHand, itemstack);
            this.m_7292_(new MobEffectInstance((MobEffect)WabEffects.ALPHA.get(), 3600));
            Random random = new Random();
            if (random.nextInt(16) == 0) {
                pPlayer.m_7292_(new MobEffectInstance((MobEffect)WabEffects.ALPHA.get(), 3600));
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(pPlayer, pHand);
    }

    public void m_27563_(@NotNull ServerLevel level, @NotNull Animal mate) {
        ItemStack itemstack = new ItemStack((ItemLike)((BeastEggBlock)((Object)WabBlocks.EATER_EGG.get())).m_5456_());
        ItemEntity itementity = new ItemEntity((Level)level, this.m_20182_().m_7096_(), this.m_20182_().m_7098_(), this.m_20182_().m_7094_(), itemstack);
        itementity.m_32060_();
        this.m_277117_(level, mate, null);
        this.m_5496_(SoundEvents.f_279531_, 1.2f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 0.5f);
        level.m_7967_((Entity)itementity);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            this.m_21666_((ServerLevel)this.m_9236_(), true);
            this.attackTick = Math.max(this.attackTick - 1, -10);
            if (this.attackTick > 0 && this.m_6084_()) {
                LivingEntity target = this.m_5448_();
                if (this.attackTick == 33 || this.attackTick == 13) {
                    this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)WabSounds.EATER_BITE.get(), SoundSource.NEUTRAL, this.m_6121_(), this.m_6100_());
                }
                if (target != null && target.m_6084_() && (this.attackTick == 28 || this.attackTick == 8) && this.m_217066_(target)) {
                    this.m_6674_(InteractionHand.MAIN_HAND);
                    this.m_7327_((Entity)target);
                    if (target instanceof Player) {
                        Player player = (Player)target;
                        for (int k = 0; k < player.m_150109_().f_35976_.size(); ++k) {
                            if (((ItemStack)player.m_150109_().f_35976_.get(k)).m_41619_() || !(((ItemStack)player.m_150109_().f_35976_.get(k)).m_41720_() instanceof ShieldItem) || ((ItemStack)player.m_150109_().f_35976_.get(k)).m_41720_() instanceof ReinforcedShield) continue;
                            ((ItemStack)player.m_150109_().f_35976_.get(k)).m_41774_(1);
                            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12018_, SoundSource.MASTER, this.m_6121_(), this.m_6100_());
                        }
                        if (player.m_21120_(InteractionHand.MAIN_HAND).m_41720_() instanceof ShieldItem && !(player.m_21120_(InteractionHand.MAIN_HAND).m_41720_() instanceof ReinforcedShield)) {
                            player.m_21120_(InteractionHand.MAIN_HAND).m_41774_(1);
                            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12018_, SoundSource.MASTER, this.m_6121_(), this.m_6100_());
                        }
                    }
                }
            } else if (this.attackTick == 0) {
                this.setState(State.IDLE);
            }
        } else if (this.isMoving && this.m_9236_().m_46467_() % 18L == 0L && !this.m_20072_()) {
            this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)WabSounds.EATER_STEP.get(), SoundSource.NEUTRAL, 1.0f, 1.0f, false);
        } else if (this.getRunning() && this.m_9236_().m_46467_() % 12L == 0L && !this.m_20072_()) {
            this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)WabSounds.EATER_STEP.get(), SoundSource.NEUTRAL, 1.0f, 1.0f, false);
        }
    }

    public void m_8107_() {
        super.m_8107_();
        for (WabEntityPart<Eater> part : this.subEntities) {
            part.update();
        }
    }

    public boolean m_217066_(LivingEntity entity) {
        return this.head.m_20191_().m_82377_(0.5, 1.0, 0.5).m_82381_(entity.m_20191_());
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)WabSounds.EATER_DEATH.get();
    }

    @Nullable
    protected SoundEvent m_7975_(@NotNull DamageSource pDamageSource) {
        return (SoundEvent)WabSounds.EATER_HIT.get();
    }

    @Nullable
    protected SoundEvent m_7515_() {
        if (this.m_5803_()) {
            return (SoundEvent)WabSounds.EATER_SLEEP.get();
        }
        if (this.getState() != State.ROAR || this.getState() != State.BITE) {
            return (SoundEvent)WabSounds.EATER_IDLE.get();
        }
        return null;
    }

    public State getState() {
        State[] states = State.values();
        return states[Mth.m_14045_((int)((Integer)this.f_19804_.m_135370_(STATE)), (int)0, (int)(states.length - 1))];
    }

    public void setState(State state) {
        this.f_19804_.m_135381_(STATE, (Object)state.ordinal());
    }

    public boolean getRoared() {
        return (Boolean)this.f_19804_.m_135370_(ROARED);
    }

    public void setRoared(boolean roared) {
        this.f_19804_.m_135381_(ROARED, (Object)roared);
    }

    public boolean getRunning() {
        return (Boolean)this.f_19804_.m_135370_(RUNNING);
    }

    public void setRunning(boolean running) {
        this.f_19804_.m_135381_(RUNNING, (Object)running);
    }

    public void increaseNomCount() {
        this.setNomCount(this.getNomCount() + 1);
    }

    public void setNomCount(int nomCount) {
        this.f_19804_.m_135381_(NOM_COUNT, (Object)nomCount);
    }

    public int getNomCount() {
        return (Integer)this.f_19804_.m_135370_(NOM_COUNT);
    }

    public void setSleepingTime(int sleepingTime) {
        this.f_19804_.m_135381_(SLEEPING_TIME, (Object)sleepingTime);
    }

    public int getSleepingTime() {
        return (Integer)this.f_19804_.m_135370_(SLEEPING_TIME);
    }

    public void setAlpha(boolean alpha) {
        this.f_19804_.m_135381_(ALPHA, (Object)alpha);
    }

    public boolean isAlpha() {
        return (Boolean)this.f_19804_.m_135370_(ALPHA);
    }

    public void m_6710_(@javax.annotation.Nullable LivingEntity target) {
        if (target != null && !this.m_6162_()) {
            if (target instanceof Player || target.m_6336_() == MobType.f_21643_) {
                this.f_19804_.m_135381_(FUTURE_TARGET, (Object)target.m_19879_());
            } else {
                super.m_6710_(target);
            }
        } else {
            super.m_6710_(target);
        }
    }

    public void applyFutureTarget() {
        if ((Integer)this.f_19804_.m_135370_(FUTURE_TARGET) != Integer.MIN_VALUE) {
            super.m_6710_((LivingEntity)this.m_9236_().m_6815_(((Integer)this.f_19804_.m_135370_(FUTURE_TARGET)).intValue()));
            this.f_19804_.m_135381_(FUTURE_TARGET, (Object)Integer.MIN_VALUE);
        }
    }

    public boolean shouldRoar() {
        return (Integer)this.f_19804_.m_135370_(FUTURE_TARGET) != Integer.MIN_VALUE && this.getState() != State.WAKE_UP;
    }

    public boolean shouldBeSleeping() {
        return this.getNomCount() > 5;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controller) {
        controller.add(new AnimationController[]{Eater.baby(this)});
        controller.add(new AnimationController[]{DefaultAnimations.genericWalkIdleController((GeoAnimatable)this)});
        controller.add(new AnimationController[]{Eater.eaterRunAnimation(this, RUN)});
        controller.add(new AnimationController[]{this.addAnimation(BITE, State.BITE), this.addAnimation(ROAR, State.ROAR), this.addAnimation(SLEEP, State.SLEEP), this.addAnimation(START_SLEEP, State.START_SLEEP), this.addAnimation(WAKE_UP, State.WAKE_UP)});
    }

    private static <T extends LivingEntity> AnimationController<T> baby(T entity) {
        return new AnimationController(entity, "baby", 1, state -> {
            if (entity.m_6162_()) {
                return state.setAndContinue(BABY);
            }
            state.getController().forceAnimationReset();
            return PlayState.STOP;
        });
    }

    public static <T extends LivingEntity> AnimationController<T> eaterRunAnimation(T entity, RawAnimation runAnimation) {
        return new AnimationController(entity, "run", 1, state -> {
            if (entity instanceof Eater) {
                Eater eater = (Eater)entity;
                eater.isMoving = state.isMoving();
                if (eater.getRunning() && state.isMoving()) {
                    return state.setAndContinue(runAnimation);
                }
            }
            state.getController().forceAnimationReset();
            return PlayState.STOP;
        });
    }

    private <T extends LivingEntity> AnimationController<?> addAnimation(RawAnimation animation, State animationState) {
        return new AnimationController((GeoAnimatable)this, animation.toString(), 0, state -> {
            if (this.getState() == animationState) {
                return state.setAndContinue(animation);
            }
            state.getController().forceAnimationReset();
            return PlayState.STOP;
        });
    }

    public void m_6123_(Player player) {
        if (this.shouldBeSleeping()) {
            this.setState(State.WAKE_UP);
            this.m_6710_((LivingEntity)player);
        }
    }

    public boolean isMultipartEntity() {
        return true;
    }

    @Nullable
    public PartEntity<?>[] getParts() {
        return this.subEntities;
    }

    public void m_20234_(int id) {
        super.m_20234_(id);
        for (int i = 0; i < this.subEntities.length; ++i) {
            this.subEntities[i].m_20234_(id + i + 1);
        }
    }

    public boolean m_5829_() {
        return !this.m_6162_();
    }

    public MobType m_6336_() {
        return WabEntities.ANCIENT_MOB;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public int m_6784_() {
        return 0;
    }

    public void m_7870_(int p_21673_) {
    }

    @Nullable
    public UUID m_6120_() {
        return null;
    }

    public void m_6925_(@Nullable UUID p_21672_) {
    }

    public void m_6825_() {
    }

    public static enum State {
        IDLE,
        WALK,
        ROAR,
        BITE,
        START_SLEEP,
        SLEEP,
        WAKE_UP;

    }
}

