/*
 * Decompiled with CFR 0.152.
 */
package net.wanmine.wab.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.PlayerRideableJumping;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.RiderShieldingMount;
import net.minecraft.world.entity.Saddleable;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.AbstractChestedHorse;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.wanmine.wab.block.BeastEggBlock;
import net.wanmine.wab.config.WabWorldConfig;
import net.wanmine.wab.entity.goals.walker.WalkerBreedGoal;
import net.wanmine.wab.entity.goals.walker.WalkerPanicGoal;
import net.wanmine.wab.entity.inventory.WalkerInventoryMenu;
import net.wanmine.wab.entity.part.WabEntityPart;
import net.wanmine.wab.init.data.WabTriggers;
import net.wanmine.wab.init.world.WabBlocks;
import net.wanmine.wab.init.world.WabEntities;
import net.wanmine.wab.init.world.WabSounds;
import net.wanmine.wab.network.PacketHandler;
import net.wanmine.wab.network.client.WalkerScreenOpenPacket;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Walker
extends AbstractChestedHorse
implements PlayerRideableJumping,
RiderShieldingMount,
Saddleable,
GeoEntity {
    public static final String ID = "walker";
    public static final String SPAWN_EGG_ID = "walker_spawn_egg";
    public static final EntityDataAccessor<Integer> STATE = SynchedEntityData.m_135353_(Walker.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final RawAnimation BABY = RawAnimation.begin().thenPlay("misc.baby");
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final WabEntityPart<Walker>[] subEntities;
    private final WabEntityPart<Walker> neck = new WabEntityPart<Walker>(this, 1.0f, 5.8f, 2.4f, 3.0f);
    private int tickLeft = 0;

    public Walker(EntityType<? extends AbstractChestedHorse> animal, Level level) {
        super(animal, level);
        this.subEntities = new WabEntityPart[]{this.neck};
        this.m_20234_(f_19843_.getAndAdd(this.subEntities.length + 1) + 1);
        this.m_274367_(1.5f);
        GroundPathNavigation groundpathnavigation = (GroundPathNavigation)this.m_21573_();
        groundpathnavigation.m_255224_(true);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData groupData, @Nullable CompoundTag tag) {
        this.m_21051_(Attributes.f_22276_).m_22100_(((Double)WabWorldConfig.WALKER_HEALTH.get()).doubleValue());
        this.m_21051_(Attributes.f_22284_).m_22100_(((Double)WabWorldConfig.WALKER_ARMOR.get()).doubleValue());
        this.m_21051_(Attributes.f_22285_).m_22100_(((Double)WabWorldConfig.WALKER_ARMOR_TOUGHNESS.get()).doubleValue());
        this.m_21153_(((Double)WabWorldConfig.WALKER_HEALTH.get()).floatValue());
        return super.m_6518_(level, difficulty, spawnType, groupData, tag);
    }

    protected void m_214179_(RandomSource source) {
    }

    public static AttributeSupplier.Builder getDefaultAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 200.0).m_22268_(Attributes.f_22278_, 2.147483647E9).m_22268_(Attributes.f_22285_, 4.0).m_22268_(Attributes.f_22284_, 10.0).m_22268_(Attributes.f_22288_, 0.1).m_22268_(Attributes.f_22279_, 0.12);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(STATE, (Object)0);
    }

    public static boolean canSpawn(EntityType<? extends Walker> entity, LevelAccessor level, MobSpawnType reason, BlockPos pos, RandomSource random) {
        return Walker.m_186209_((BlockAndTintGetter)level, (BlockPos)pos);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new WalkerPanicGoal((PathfinderMob)this, 1.25));
        this.f_21345_.m_25352_(3, (Goal)new WalkerBreedGoal((Animal)this));
        this.f_21345_.m_25352_(4, (Goal)new TemptGoal((PathfinderMob)this, 1.0, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_151014_, Items.f_151009_, Items.f_186362_}), false));
        this.f_21345_.m_25352_(5, (Goal)new FollowParentGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 0.6f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel level, AgeableMob pOtherParent) {
        return (AgeableMob)((EntityType)WabEntities.WALKER.get()).m_20615_((Level)level);
    }

    public void m_27563_(@NotNull ServerLevel level, @NotNull Animal mate) {
        ItemStack itemstack = new ItemStack((ItemLike)((BeastEggBlock)((Object)WabBlocks.WALKER_EGG.get())).m_5456_());
        ItemEntity itementity = new ItemEntity((Level)level, this.m_20182_().m_7096_(), this.m_20182_().m_7098_(), this.m_20182_().m_7094_(), itemstack);
        itementity.m_32060_();
        this.m_277117_(level, mate, null);
        this.m_5496_(SoundEvents.f_279531_, 1.2f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 0.5f);
        level.m_7967_((Entity)itementity);
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_41720_() == Items.f_151009_ || stack.m_41720_() == Items.f_186362_ || stack.m_41720_() == Items.f_151014_;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controller) {
        controller.add(new AnimationController[]{Walker.walk(this)});
        controller.add(new AnimationController[]{Walker.baby(this)});
    }

    private static <T extends LivingEntity> AnimationController<T> baby(T entity) {
        return new AnimationController(entity, "baby", 1, state -> {
            if (entity.m_6162_()) {
                return state.setAndContinue(BABY);
            }
            state.getController().forceAnimationReset();
            return PlayState.STOP;
        });
    }

    private static AnimationController<Walker> walk(Walker walker) {
        return new AnimationController((GeoAnimatable)walker, "walk", 1, state -> {
            if (walker.tickLeft <= 0) {
                if (walker.isMoving()) {
                    if (walker.m_20142_()) {
                        walker.setState(State.RUN);
                    } else {
                        walker.setState(State.WALK);
                    }
                } else {
                    walker.setState(State.IDLE);
                }
            }
            return state.setAndContinue(walker.getState().getAnimation());
        });
    }

    public void m_8119_() {
        block4: {
            block3: {
                block5: {
                    super.m_8119_();
                    if (!this.m_9236_().f_46443_) break block3;
                    if (this.tickLeft > 0) {
                        --this.tickLeft;
                    }
                    if (this.getState() == State.IDLE || this.m_20072_()) break block4;
                    if (!this.m_20142_() || this.m_9236_().m_46467_() % 12L != 0L) break block5;
                    this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)WabSounds.WALKER_STEP.get(), SoundSource.NEUTRAL, 1.0f, 1.0f, false);
                    break block4;
                }
                if (this.m_9236_().m_46467_() % 15L != 0L) break block4;
                this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)WabSounds.WALKER_STEP.get(), SoundSource.NEUTRAL, 1.0f, 1.0f, false);
                break block4;
            }
            if (this.m_20142_() && this.m_9236_().m_46468_() % 10L == 0L) {
                for (LivingEntity target : this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82377_(3.7, 1.0, 3.7))) {
                    if (target instanceof Walker) continue;
                    target.m_6469_(new DamageSource((Holder)this.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(DamageTypes.f_268566_)), 2.0f);
                }
            }
        }
    }

    public void m_8107_() {
        super.m_8107_();
        for (WabEntityPart<Walker> part : this.subEntities) {
            part.update();
        }
    }

    public State getState() {
        State[] states = State.values();
        return states[Mth.m_14045_((int)((Integer)this.f_19804_.m_135370_(STATE)), (int)0, (int)(states.length - 1))];
    }

    public void setState(State state) {
        if ((state == State.WALK || state == State.RUN) && this.getState() == State.IDLE) {
            state = State.START_WALK;
        } else if (state == State.IDLE && (this.getState() == State.WALK || this.getState() == State.RUN)) {
            state = State.STOP_WALK;
        }
        this.tickLeft = state.getDuration();
        this.f_19804_.m_135381_(STATE, (Object)state.ordinal());
    }

    @NotNull
    public InteractionResult m_6071_(Player pPlayer, @NotNull InteractionHand pHand) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        if (itemstack.m_41720_() == Items.f_151014_) {
            if (this.m_6162_() && !this.m_30614_()) {
                this.m_142075_(pPlayer, pHand, itemstack);
                if (this.f_19796_.m_188503_(3) == 0) {
                    this.m_30637_(pPlayer);
                } else {
                    this.m_30669_(false);
                }
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            if (!this.m_6162_() && !this.m_27593_()) {
                this.m_142075_(pPlayer, pHand, itemstack);
                this.m_27595_(pPlayer);
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
        } else if (itemstack.m_41720_() == Items.f_151009_ || itemstack.m_41720_() == Items.f_186362_) {
            if (this.m_6162_()) {
                this.m_142075_(pPlayer, pHand, itemstack);
                this.m_146740_(Walker.m_216967_((int)(-this.m_146764_())), true);
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            if (this.m_21223_() < this.m_21233_()) {
                this.m_142075_(pPlayer, pHand, itemstack);
                this.m_5634_(3.0f);
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
        } else if (this.m_30614_() && !this.m_6162_()) {
            if (pPlayer.m_36341_()) {
                this.m_213583_(pPlayer);
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            if (!this.m_30502_() && itemstack.m_150930_(Items.f_42009_)) {
                this.m_246066_(pPlayer, itemstack);
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            if (this.m_20197_().size() < 4) {
                this.m_6835_(pPlayer);
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
        }
        return InteractionResult.PASS;
    }

    private void m_246066_(Player player, ItemStack item) {
        this.m_30504_(true);
        this.m_7609_();
        if (!player.m_150110_().f_35937_) {
            item.m_41774_(1);
        }
        this.m_30625_();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            WabTriggers.EQUIP_WALKER_CHEST.m_222618_(serverPlayer);
        }
    }

    protected boolean m_7310_(Entity pPassenger) {
        return this.m_20197_().size() <= 4 && this.m_30614_();
    }

    protected void m_19956_(Entity entity, Entity.MoveFunction moveFunction) {
        int i = this.m_20197_().indexOf(entity);
        if (i >= 0) {
            boolean flag = i == 0;
            double x = -0.75;
            double y = 3.85;
            double z = 0.5;
            if (!flag) {
                if (i == 1) {
                    x = 0.75;
                } else if (i == 2) {
                    y = 3.25;
                    z = -1.3;
                } else if (i == 3) {
                    x = 0.75;
                    y = 3.25;
                    z = -1.3;
                }
            }
            Vec3 vec3 = new Vec3(x, y, z).m_82524_(-this.f_20883_ * ((float)Math.PI / 180));
            moveFunction.m_20372_(entity, this.m_20185_() + vec3.f_82479_, this.m_20186_() + vec3.f_82480_, this.m_20189_() + vec3.f_82481_);
            this.clampRotation(entity);
        }
    }

    public double m_6048_() {
        return (double)this.m_6972_((Pose)Pose.STANDING).f_20378_ - 0.6;
    }

    public void m_7340_(Entity pEntityToUpdate) {
        if (this.m_6688_() != pEntityToUpdate) {
            this.clampRotation(pEntityToUpdate);
        }
    }

    private void clampRotation(Entity pEntity) {
        pEntity.m_5618_(this.m_146908_());
        float f = pEntity.m_146908_();
        float f1 = Mth.m_14177_((float)(f - this.m_146908_()));
        float f2 = Mth.m_14036_((float)f1, (float)-160.0f, (float)160.0f);
        pEntity.f_19859_ += f2 - f1;
        float f3 = f + f2 - f1;
        pEntity.m_146922_(f3);
        pEntity.m_5616_(f3);
    }

    public LivingEntity m_6688_() {
        Entity entity;
        if (!this.m_20197_().isEmpty() && this.m_6254_() && (entity = (Entity)this.m_20197_().get(0)) instanceof LivingEntity) {
            return (LivingEntity)entity;
        }
        return null;
    }

    public double m_262813_() {
        return 3.7;
    }

    protected float m_245547_(Player player) {
        float f = player.m_20142_() ? 0.0f : -0.03f;
        return (float)this.m_21133_(Attributes.f_22279_) + f;
    }

    public boolean m_264410_() {
        return true;
    }

    protected boolean m_245259_() {
        return false;
    }

    public boolean m_7848_(Animal pOtherAnimal) {
        if (pOtherAnimal != this && pOtherAnimal instanceof Walker) {
            Walker walker = (Walker)pOtherAnimal;
            return this.m_30628_() && walker.m_30628_();
        }
        return false;
    }

    protected boolean m_30628_() {
        return !this.m_20160_() && !this.m_20159_() && !this.m_6162_() && this.m_27593_();
    }

    protected int m_7506_() {
        return this.m_30502_() ? 49 : super.m_7506_();
    }

    public int m_7488_() {
        return 7;
    }

    public void m_213583_(Player player) {
        if (!this.m_9236_().f_46443_ && (!this.m_20160_() || this.m_20363_((Entity)player)) && this.m_30614_() && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (serverPlayer.f_36096_ != serverPlayer.f_36095_) {
                serverPlayer.m_6915_();
            }
            serverPlayer.m_9217_();
            PacketHandler.sendToPlayer(new WalkerScreenOpenPacket(serverPlayer.f_8940_, serverPlayer.m_150109_().m_6643_() + this.m_7506_(), this.m_19879_()), serverPlayer);
            serverPlayer.f_36096_ = new WalkerInventoryMenu(serverPlayer.f_8940_, serverPlayer.m_150109_(), (Container)this.f_30520_, this);
            serverPlayer.m_143399_(serverPlayer.f_36096_);
            MinecraftForge.EVENT_BUS.post((Event)new PlayerContainerEvent.Open((Player)serverPlayer, serverPlayer.f_36096_));
        }
    }

    public boolean isMultipartEntity() {
        return true;
    }

    @Nullable
    public PartEntity<?>[] getParts() {
        return this.subEntities;
    }

    public void m_20234_(int id) {
        super.m_20234_(id);
        for (int i = 0; i < this.subEntities.length; ++i) {
            this.subEntities[i].m_20234_(id + i + 1);
        }
    }

    public boolean m_5829_() {
        return !this.m_6162_();
    }

    public boolean isMoving() {
        return this.m_20184_().f_82479_ != 0.0 || this.m_20184_().f_82481_ != 0.0;
    }

    public MobType m_6336_() {
        return WabEntities.ANCIENT_MOB;
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)WabSounds.WALKER_DEATH.get();
    }

    @Nullable
    protected SoundEvent m_7975_(@NotNull DamageSource pDamageSource) {
        return (SoundEvent)WabSounds.WALKER_HIT.get();
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)WabSounds.WALKER_IDLE.get();
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public static enum State {
        IDLE(RawAnimation.begin().thenPlay("misc.idle")),
        START_WALK(RawAnimation.begin().thenPlay("move.start_walk"), 18),
        WALK(RawAnimation.begin().thenPlay("move.walk")),
        RUN(RawAnimation.begin().thenPlay("move.run")),
        STOP_WALK(RawAnimation.begin().thenPlay("move.stop_walk"), 12);

        private final RawAnimation animation;
        private final int duration;

        private State(RawAnimation animation) {
            this.animation = animation;
            this.duration = 0;
        }

        private State(RawAnimation animation, int duration) {
            this.animation = animation;
            this.duration = duration;
        }

        public RawAnimation getAnimation() {
            return this.animation;
        }

        public int getDuration() {
            return this.duration;
        }
    }
}

