/*
 * Decompiled with CFR 0.152.
 */
package net.wanmine.wab.network;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import net.wanmine.wab.network.client.ClientGliderPartyingPacket;
import net.wanmine.wab.network.client.EaterAlphaPacket;
import net.wanmine.wab.network.client.InitSoarerPacket;
import net.wanmine.wab.network.client.InitSurferPacket;
import net.wanmine.wab.network.client.SoarerScreenOpenPacket;
import net.wanmine.wab.network.client.WalkerScreenOpenPacket;
import net.wanmine.wab.network.server.ServerGliderPartyingPacket;
import net.wanmine.wab.network.server.SoarerJumpPacket;
import net.wanmine.wab.network.server.SurferAbilityPacket;
import net.wanmine.wab.network.server.SurferJumpPacket;

public class PacketHandler {
    private static final SimpleChannel INSTANCE = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("wan_ancient_beasts", "main")).serverAcceptedVersions(version -> true).clientAcceptedVersions(version -> true).networkProtocolVersion(() -> "1.0").simpleChannel();

    public static void register() {
        INSTANCE.messageBuilder(WalkerScreenOpenPacket.class, 0, NetworkDirection.PLAY_TO_CLIENT).encoder(WalkerScreenOpenPacket::encode).decoder(WalkerScreenOpenPacket::new).consumerMainThread(WalkerScreenOpenPacket::handle).add();
        INSTANCE.messageBuilder(EaterAlphaPacket.class, 1, NetworkDirection.PLAY_TO_CLIENT).encoder(EaterAlphaPacket::encode).decoder(EaterAlphaPacket::new).consumerMainThread(EaterAlphaPacket::handle).add();
        INSTANCE.messageBuilder(ClientGliderPartyingPacket.class, 2, NetworkDirection.PLAY_TO_CLIENT).encoder(ClientGliderPartyingPacket::encode).decoder(ClientGliderPartyingPacket::new).consumerMainThread(ClientGliderPartyingPacket::handle).add();
        INSTANCE.messageBuilder(InitSoarerPacket.class, 3, NetworkDirection.PLAY_TO_CLIENT).encoder(InitSoarerPacket::encode).decoder(InitSoarerPacket::new).consumerMainThread(InitSoarerPacket::handle).add();
        INSTANCE.messageBuilder(SoarerScreenOpenPacket.class, 4, NetworkDirection.PLAY_TO_CLIENT).encoder(SoarerScreenOpenPacket::encode).decoder(SoarerScreenOpenPacket::new).consumerMainThread(SoarerScreenOpenPacket::handle).add();
        INSTANCE.messageBuilder(InitSurferPacket.class, 5, NetworkDirection.PLAY_TO_CLIENT).encoder(InitSurferPacket::encode).decoder(InitSurferPacket::new).consumerMainThread(InitSurferPacket::handle).add();
        INSTANCE.messageBuilder(ServerGliderPartyingPacket.class, 100, NetworkDirection.PLAY_TO_SERVER).encoder(ServerGliderPartyingPacket::encode).decoder(ServerGliderPartyingPacket::new).consumerMainThread(ServerGliderPartyingPacket::handle).add();
        INSTANCE.messageBuilder(SoarerJumpPacket.class, 101, NetworkDirection.PLAY_TO_SERVER).encoder(SoarerJumpPacket::encode).decoder(SoarerJumpPacket::new).consumerMainThread(SoarerJumpPacket::handle).add();
        INSTANCE.messageBuilder(SurferAbilityPacket.class, 102, NetworkDirection.PLAY_TO_SERVER).encoder(SurferAbilityPacket::encode).decoder(SurferAbilityPacket::new).consumerMainThread(SurferAbilityPacket::handle).add();
        INSTANCE.messageBuilder(SurferJumpPacket.class, 103, NetworkDirection.PLAY_TO_SERVER).encoder(SurferJumpPacket::encode).decoder(SurferJumpPacket::new).consumerMainThread(SurferJumpPacket::handle).add();
    }

    public static void registerDedicatedServer() {
        INSTANCE.messageBuilder(WalkerScreenOpenPacket.class, 0, NetworkDirection.PLAY_TO_CLIENT).encoder(WalkerScreenOpenPacket::encode).add();
        INSTANCE.messageBuilder(EaterAlphaPacket.class, 1, NetworkDirection.PLAY_TO_CLIENT).encoder(EaterAlphaPacket::encode).add();
        INSTANCE.messageBuilder(ClientGliderPartyingPacket.class, 2, NetworkDirection.PLAY_TO_CLIENT).encoder(ClientGliderPartyingPacket::encode).add();
        INSTANCE.messageBuilder(InitSoarerPacket.class, 3, NetworkDirection.PLAY_TO_CLIENT).encoder(InitSoarerPacket::encode).add();
        INSTANCE.messageBuilder(SoarerScreenOpenPacket.class, 4, NetworkDirection.PLAY_TO_CLIENT).encoder(SoarerScreenOpenPacket::encode).add();
        INSTANCE.messageBuilder(InitSurferPacket.class, 5, NetworkDirection.PLAY_TO_CLIENT).encoder(InitSurferPacket::encode).add();
        INSTANCE.messageBuilder(ServerGliderPartyingPacket.class, 100, NetworkDirection.PLAY_TO_SERVER).decoder(ServerGliderPartyingPacket::new).consumerMainThread(ServerGliderPartyingPacket::handle).add();
        INSTANCE.messageBuilder(SoarerJumpPacket.class, 101, NetworkDirection.PLAY_TO_SERVER).decoder(SoarerJumpPacket::new).consumerMainThread(SoarerJumpPacket::handle).add();
        INSTANCE.messageBuilder(SurferAbilityPacket.class, 102, NetworkDirection.PLAY_TO_SERVER).decoder(SurferAbilityPacket::new).consumerMainThread(SurferAbilityPacket::handle).add();
        INSTANCE.messageBuilder(SurferJumpPacket.class, 103, NetworkDirection.PLAY_TO_SERVER).decoder(SurferJumpPacket::new).consumerMainThread(SurferJumpPacket::handle).add();
    }

    public static <MSG> void sendToServer(MSG message) {
        INSTANCE.sendToServer(message);
    }

    public static <MSG> void sendToPlayer(MSG message, ServerPlayer player) {
        INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), message);
    }

    public static <MSG> void sendToAllPlayer(MSG message, ServerLevel level) {
        for (ServerPlayer player : level.m_6907_()) {
            INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), message);
        }
    }
}

