/*
 * Decompiled with CFR 0.152.
 */
package com.manchick.selectorwheel.widget.action;

import com.google.common.collect.Sets;
import com.manchick.selectorwheel.widget.action.Action;
import com.mojang.logging.LogUtils;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;
import java.util.Set;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import org.slf4j.Logger;

public class URLAction
extends Action {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Set<String> ALLOWED_PROTOCOLS = Sets.newHashSet((Object[])new String[]{"http", "https"});
    private final String url;

    public URLAction(String url) {
        this.url = url;
    }

    @Override
    public void run(class_310 client) {
        if (client.field_1724 == null) {
            return;
        }
        try {
            URI uRI = new URI(this.url);
            String string = uRI.getScheme();
            if (string == null) {
                client.field_1724.method_43496((class_2561)class_2561.method_43471((String)"exception.selectorwheel.missing_scheme").method_27692(class_124.field_1080));
                return;
            }
            if (!ALLOWED_PROTOCOLS.contains(string.toLowerCase(Locale.ROOT))) {
                client.field_1724.method_43496((class_2561)class_2561.method_43471((String)"exception.selectorwheel.unsupported_scheme").method_27692(class_124.field_1080));
                return;
            }
            class_156.method_668().method_673(uRI);
        }
        catch (URISyntaxException uRISyntaxException) {
            LOGGER.error("Can't open url for {}", (Object)this.url, (Object)uRISyntaxException);
        }
    }
}

