/*
 * Decompiled with CFR 0.152.
 */
package com.manchick.selectorwheel.widget;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.manchick.selectorwheel.util.Out;
import com.manchick.selectorwheel.widget.WidgetCategory;
import com.manchick.selectorwheel.widget.action.Action;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2522;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3518;
import net.minecraft.class_5250;
import org.slf4j.Logger;

public class Widget {
    public final class_2561 title;
    public final class_1799 preview;
    public final List<Action> actions;
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final Widget EMPTY = new Widget((class_2561)class_2561.method_43471((String)"util.selectorwheel.null_widget"), null, new ArrayList<Action>());

    public Widget(class_2561 title, class_1799 preview, List<Action> actions) {
        this.title = title;
        this.preview = preview;
        this.actions = actions;
    }

    public void run(class_310 client) {
        if (this.actions.isEmpty()) {
            return;
        }
        this.actions.forEach(action -> action.run(client));
    }

    public static WidgetInfo deserialize(String fileName, JsonObject object) {
        WidgetCategory category = WidgetCategory.deserialize(object);
        String serverAddress = class_3518.method_15253((JsonObject)object, (String)"server", (String)"");
        JsonArray array = class_3518.method_15292((JsonObject)object, (String)"actions", (JsonArray)new JsonArray());
        Out<class_1799, Boolean> stack = Widget.deserializeStack(fileName, object);
        class_5250 title = class_2561.class_2562.method_10872((JsonElement)object.get("title"));
        if (title == null) {
            title = class_2561.method_43471((String)"util.selectorwheel.empty");
        }
        ArrayList<Action> actions = new ArrayList<Action>();
        if (!array.isEmpty()) {
            array.forEach(element -> {
                Action action;
                JsonObject actionObject = element.getAsJsonObject();
                if (actionObject != null && (action = Action.deserialize(fileName, actionObject)) != null) {
                    actions.add(action);
                }
            });
        }
        return new WidgetInfo(new Widget((class_2561)title, stack.getOutedValue() != false ? stack.getReturnedValue() : null, actions), category, serverAddress);
    }

    private static Out<class_1799, Boolean> deserializeStack(String fileName, JsonObject object) {
        if (!object.has("preview")) {
            return new Out<class_1799, Boolean>(class_1799.field_8037, false);
        }
        JsonElement element = object.get("preview");
        if (element.isJsonObject()) {
            JsonObject stackObject = element.getAsJsonObject();
            class_1792 item = Widget.getItem(stackObject, "item");
            class_2487 compound = new class_2487();
            if (stackObject.has("nbt")) {
                String nbt = class_3518.method_15265((JsonObject)stackObject, (String)"nbt");
                try {
                    compound = new class_2522(new StringReader(nbt)).method_10727();
                }
                catch (CommandSyntaxException e) {
                    LOGGER.error("Error occurred while trying to parse the nbt compound within the {} widget", (Object)fileName);
                }
            }
            class_1799 stack = new class_1799((class_1935)item);
            if (!compound.method_33133()) {
                stack.method_7948().method_10543(compound);
            }
            return new Out<class_1799, Boolean>(stack, item != class_1802.field_8162);
        }
        class_1792 item = Widget.getItem(object, "preview");
        return new Out<class_1799, Boolean>(new class_1799((class_1935)item), item != class_1802.field_8162);
    }

    private static class_1792 getItem(JsonObject object, String key) {
        try {
            return class_3518.method_15288((JsonObject)object, (String)key).method_8389();
        }
        catch (JsonSyntaxException e) {
            LOGGER.error("Item {} has an invalid identifier. Couldn't deserialize it properly.", (Object)class_3518.method_15265((JsonObject)object, (String)key));
            return class_1802.field_8162;
        }
    }

    public record WidgetInfo(Widget widget, WidgetCategory category, String serverAddress) {
    }
}

