/*
 * Decompiled with CFR 0.152.
 */
package com.manchick.selectorwheel.widget;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.manchick.selectorwheel.widget.Widget;
import com.mojang.logging.LogUtils;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_310;
import net.minecraft.class_642;
import org.slf4j.Logger;

public class WidgetManager {
    public static final Logger LOGGER = LogUtils.getLogger();
    private static final List<Widget> loadedWidgets = new ArrayList<Widget>();
    private static final HashMap<Widget, String> assignedWidgets = new HashMap();

    public static List<Widget> listWidgets(class_310 client) {
        String currentAddress;
        class_642 info;
        if (!client.method_1542() && (info = client.method_1558()) != null && assignedWidgets.containsValue(currentAddress = info.field_3761)) {
            return assignedWidgets.entrySet().stream().filter(entry -> ((String)entry.getValue()).equals(currentAddress)).map(Map.Entry::getKey).toList();
        }
        return loadedWidgets;
    }

    public static void reload() {
        loadedWidgets.clear();
        assignedWidgets.clear();
        WidgetManager.load();
    }

    public static void load() {
        File[] widgets;
        File runDirectory = class_310.method_1551().field_1697;
        File widgetDirectory = new File(runDirectory, "widgets");
        if (!widgetDirectory.exists()) {
            LOGGER.warn("Widgets folder wasn't found. Creating one automatically...");
            widgetDirectory.mkdir();
        }
        if ((widgets = widgetDirectory.listFiles()) == null || widgets.length < 1) {
            return;
        }
        for (File widget : widgets) {
            if (widget.isDirectory()) continue;
            try {
                JsonObject jsonObject;
                FileReader reader;
                block14: {
                    reader = new FileReader(widget, StandardCharsets.UTF_8);
                    jsonObject = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                    if (jsonObject != null) break block14;
                    reader.close();
                    continue;
                }
                try {
                    try {
                        Widget.WidgetInfo info = Widget.deserialize(widget.getName(), jsonObject);
                        if (info.serverAddress().isEmpty()) {
                            loadedWidgets.add(info.widget());
                            continue;
                        }
                        assignedWidgets.put(info.widget(), info.serverAddress());
                    }
                    catch (JsonSyntaxException e) {
                        LOGGER.error("Found a malformed widget file {}, skipping...", (Object)widget.getName(), (Object)e);
                    }
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    reader.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

