/*
 * Decompiled with CFR 0.152.
 */
package me.khajiitos.chestedcompanions.common.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import me.khajiitos.chestedcompanions.common.config.CCConfig;
import me.khajiitos.chestedcompanions.common.util.IChestEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.wolf.Wolf;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;

public class ChestIconRenderer {
    private static final ResourceLocation CHEST_ICON_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"chestedcompanions", (String)"textures/chest_icon.png");
    private static final float SCALE = 0.015625f;

    public static <T extends LivingEntity> boolean shouldRender(T entity) {
        IChestEntity chestEntity;
        if (entity != Minecraft.getInstance().getEntityRenderDispatcher().crosshairPickEntity) {
            return false;
        }
        if (!(entity instanceof IChestEntity) || !(chestEntity = (IChestEntity)entity).chestedCompanions$hasChest()) {
            return false;
        }
        if (!Minecraft.renderNames()) {
            return false;
        }
        if (entity instanceof Cat) {
            return (Boolean)CCConfig.showChestIconOnCats.get();
        }
        if (entity instanceof Wolf) {
            return (Boolean)CCConfig.showChestIconOnWolves.get();
        }
        return false;
    }

    public static void render(@NotNull PoseStack poseStack, @NotNull MultiBufferSource multiBufferSource, int pPackedLight, @NotNull LivingEntityRenderState entityRenderState, double yOffset) {
        VertexConsumer vertexConsumer = multiBufferSource.getBuffer(RenderType.entityCutout((ResourceLocation)CHEST_ICON_LOCATION));
        int overlayCoords = LivingEntityRenderer.getOverlayCoords((LivingEntityRenderState)entityRenderState, (float)0.0f);
        poseStack.pushPose();
        poseStack.translate(0.0, yOffset, 0.0);
        poseStack.mulPose((Quaternionfc)Minecraft.getInstance().getEntityRenderDispatcher().cameraOrientation());
        poseStack.scale(-0.015625f, -0.015625f, 0.015625f);
        Matrix4f matrix4f = poseStack.last().pose();
        vertexConsumer.addVertex(matrix4f, 0.0f, 0.0f, 0.0f).setColor(255, 255, 255, 255).setUv(0.0f, 0.0f).setOverlay(overlayCoords).setLight(pPackedLight).setNormal(1.0f, 1.0f, 1.0f);
        vertexConsumer.addVertex(matrix4f, 0.0f, 16.0f, 0.0f).setColor(255, 255, 255, 255).setUv(0.0f, 1.0f).setOverlay(overlayCoords).setLight(pPackedLight).setNormal(1.0f, 1.0f, 1.0f);
        vertexConsumer.addVertex(matrix4f, 16.0f, 16.0f, 0.0f).setColor(255, 255, 255, 255).setUv(1.0f, 1.0f).setOverlay(overlayCoords).setLight(pPackedLight).setNormal(1.0f, 1.0f, 1.0f);
        vertexConsumer.addVertex(matrix4f, 16.0f, 0.0f, 0.0f).setColor(255, 255, 255, 255).setUv(1.0f, 0.0f).setOverlay(overlayCoords).setLight(pPackedLight).setNormal(1.0f, 1.0f, 1.0f);
        poseStack.popPose();
    }
}

