/*
 * Decompiled with CFR 0.152.
 */
package me.khajiitos.chestedcompanions.common.util;

import java.util.Optional;
import me.khajiitos.chestedcompanions.common.config.CCConfig;
import me.khajiitos.chestedcompanions.common.util.IChestEntity;
import me.khajiitos.chestedcompanions.common.util.InventoryCapacity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemStackWithSlot;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.UniquelyIdentifyable;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

public class ChestEntityCommon {
    public static <T extends TamableAnimal> void mobInteract(T chestEntity, Player player, InteractionHand interactionHand, CallbackInfoReturnable<InteractionResult> cir) {
        if (!(chestEntity.level().isClientSide || player.isCrouching() != ((Boolean)CCConfig.invertShiftToOpen.get()).booleanValue() || (chestEntity.getOwnerReference() == null || !chestEntity.getOwnerReference().matches((UniquelyIdentifyable)player)) && !((Boolean)CCConfig.publicChest.get()).booleanValue() || ((Boolean)CCConfig.feedingOverridesOpeningChest.get()).booleanValue() && chestEntity.isFood(player.getItemInHand(interactionHand)) && chestEntity.getHealth() < chestEntity.getMaxHealth())) {
            ItemStack inHand;
            if (((IChestEntity)chestEntity).chestedCompanions$hasChest()) {
                ItemStack inHand2 = player.getItemInHand(interactionHand);
                if (inHand2.is(Items.SHEARS)) {
                    inHand2.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)interactionHand));
                    ((IChestEntity)chestEntity).chestedCompanions$removeChestContent(!player.getAbilities().instabuild);
                    chestEntity.playSound(SoundEvents.DONKEY_CHEST, 1.0f, 1.5f);
                } else {
                    ((HasCustomInventoryScreen)chestEntity).openCustomInventoryScreen(player);
                }
                cir.setReturnValue((Object)InteractionResult.SUCCESS_SERVER);
            } else if (((IChestEntity)chestEntity).chestedCompanions$allowChest() && (!chestEntity.isBaby() || ((IChestEntity)chestEntity).chestedCompanions$allowChestOnBaby()) && ((IChestEntity)chestEntity).chestedCompanions$isValidChestItem(inHand = player.getItemInHand(interactionHand))) {
                ((IChestEntity)chestEntity).chestedCompanions$setChestItemStack(inHand.copyWithCount(1));
                if (!player.getAbilities().instabuild) {
                    inHand.shrink(1);
                }
                chestEntity.playSound(SoundEvents.DONKEY_CHEST, 1.0f, (chestEntity.getRandom().nextFloat() - chestEntity.getRandom().nextFloat()) * 0.2f + 1.0f);
                ((IChestEntity)chestEntity).chestedCompanions$createInventory();
                cir.setReturnValue((Object)InteractionResult.SUCCESS_SERVER);
            }
        }
    }

    public static <T extends TamableAnimal> void addAdditionalSaveData(T chestEntity, ValueOutput valueOutput) {
        if (((IChestEntity)chestEntity).chestedCompanions$hasChest()) {
            ItemStack chestItemStack = ((IChestEntity)chestEntity).chestedCompanions$getChestItemStack();
            valueOutput.store("ChestItem", ItemStack.CODEC, (Object)chestItemStack);
        }
        if (((IChestEntity)chestEntity).chestedCompanions$getInventory() != null) {
            ValueOutput.TypedOutputList itemsList = valueOutput.list("CCItems", ItemStackWithSlot.CODEC);
            ((IChestEntity)chestEntity).chestedCompanions$getInventory().storeAsItemListWithSlot((ValueOutput.TypedOutputList<ItemStackWithSlot>)itemsList);
        }
    }

    public static <T extends TamableAnimal> void readAdditionalSaveData(T chestEntity, ValueInput valueInput) {
        ItemStack chestItemStack;
        Optional itemTag = valueInput.read("ChestItem", ItemStack.CODEC);
        if (itemTag.isPresent()) {
            chestItemStack = (ItemStack)itemTag.get();
        } else if (valueInput.getBooleanOr("HasChest", false)) {
            chestItemStack = new ItemStack((ItemLike)Items.CHEST);
        } else {
            return;
        }
        if (!chestItemStack.isEmpty()) {
            ((IChestEntity)chestEntity).chestedCompanions$setChestItemStack(chestItemStack);
            ((IChestEntity)chestEntity).chestedCompanions$createInventory();
            valueInput.list("CCItems", ItemStackWithSlot.CODEC).ifPresent(list -> ((IChestEntity)chestEntity).chestedCompanions$getInventory().loadFromItemListWithSlot((ValueInput.TypedInputList<ItemStackWithSlot>)list));
        }
    }

    public static <T extends TamableAnimal> void removeChestContent(T chestEntity, boolean dropChest) {
        IChestEntity.PetChestContainer<?> inventory = ((IChestEntity)chestEntity).chestedCompanions$getInventory();
        if (inventory != null) {
            Level level;
            ItemStack chestItemStack;
            for (int i = 0; i < inventory.getContainerSize(); ++i) {
                Level level2;
                ItemStack itemStack = inventory.getItem(i);
                if (itemStack.isEmpty() || !((level2 = chestEntity.level()) instanceof ServerLevel)) continue;
                ServerLevel serverLevel = (ServerLevel)level2;
                chestEntity.spawnAtLocation(serverLevel, itemStack, 0.25f);
            }
            if (dropChest && !(chestItemStack = ((IChestEntity)chestEntity).chestedCompanions$getChestItemStack()).isEmpty() && (level = chestEntity.level()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                chestEntity.spawnAtLocation(serverLevel, chestItemStack, 0.25f);
            }
            ((IChestEntity)chestEntity).chestedCompanions$setChestItemStack(ItemStack.EMPTY);
            ((IChestEntity)chestEntity).chestedCompanions$removeInventory();
        }
    }

    public static <T extends TamableAnimal> AbstractContainerMenu createMenu(T chestEntity, int i, @NotNull Inventory inventory, @NotNull Player player) {
        InventoryCapacity inventoryCapacity = ((IChestEntity)chestEntity).chestedCompanions$getInventoryCapacity();
        if (((IChestEntity)chestEntity).chestedCompanions$getInventory() != null && ((IChestEntity)chestEntity).chestedCompanions$getInventory().getContainerSize() != inventoryCapacity.containerRows * 9) {
            ((IChestEntity)chestEntity).chestedCompanions$createInventory();
        }
        return new ChestMenu(inventoryCapacity.menuType, i, inventory, ((IChestEntity)chestEntity).chestedCompanions$getInventory(), inventoryCapacity.containerRows);
    }
}

