/*
 * Decompiled with CFR 0.152.
 */
package me.khajiitos.chestedcompanions.neoforged.client;

import me.khajiitos.chestedcompanions.common.client.config.cloth.ClothConfigCheck;
import me.khajiitos.chestedcompanions.common.client.config.cloth.ClothConfigScreenMaker;
import me.khajiitos.chestedcompanions.common.client.renderer.layer.CatChestLayer;
import me.khajiitos.chestedcompanions.common.client.renderer.layer.WolfChestLayer;
import net.minecraft.client.model.CatModel;
import net.minecraft.client.model.WolfModel;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.CatRenderState;
import net.minecraft.client.renderer.entity.state.WolfRenderState;
import net.minecraft.world.entity.EntityType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;

public class ChestedCompanionsNeoForgeClient {
    public static void init(ModContainer modContainer) {
        IEventBus eventBus = modContainer.getEventBus();
        if (eventBus != null) {
            eventBus.addListener(ChestedCompanionsNeoForgeClient::addLayers);
        }
        if (ClothConfigCheck.isInstalled()) {
            modContainer.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)(modContainer1, screen) -> ClothConfigScreenMaker.create(screen)));
        }
    }

    private static void addLayers(EntityRenderersEvent.AddLayers e) {
        LivingEntityRenderer wolfRenderer;
        LivingEntityRenderer catRenderer = (LivingEntityRenderer)e.getRenderer(EntityType.CAT);
        if (catRenderer != null) {
            catRenderer.addLayer((RenderLayer)new CatChestLayer((RenderLayerParent<CatRenderState, CatModel>)catRenderer));
        }
        if ((wolfRenderer = (LivingEntityRenderer)e.getRenderer(EntityType.WOLF)) != null) {
            wolfRenderer.addLayer((RenderLayer)new WolfChestLayer((RenderLayerParent<WolfRenderState, WolfModel>)wolfRenderer));
        }
    }
}

