/*
 * Decompiled with CFR 0.152.
 */
package com.bigdious.risus.blocks;

import com.bigdious.risus.blocks.interfaces.SimpleMultiloggedBlock;
import com.bigdious.risus.init.RisusBlocks;
import java.util.Locale;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class AshenSpireBlock
extends Block
implements SimpleMultiloggedBlock {
    protected static final VoxelShape SHAPE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.DOUBLE_BLOCK_HALF;
    public static final EnumProperty<LanternEnum> LANTERN = LanternEnum.LANTERN;
    public static final EnumProperty<SimpleMultiloggedBlock.MultiloggingEnum> FLUIDLOGGED = SimpleMultiloggedBlock.MultiloggingEnum.FLUIDLOGGED;
    public static final BooleanProperty FLIPPED = BooleanProperty.create((String)"flipped");

    public AshenSpireBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue(HALF, (Comparable)DoubleBlockHalf.LOWER)).setValue((Property)FLIPPED, (Comparable)Boolean.valueOf(false))).setValue(FLUIDLOGGED, (Comparable)((Object)SimpleMultiloggedBlock.MultiloggingEnum.EMPTY))).setValue(LANTERN, (Comparable)((Object)LanternEnum.EMPTY)));
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        if (stack.is(ItemTags.HOES)) {
            level.setBlock(pos, (BlockState)state.cycle((Property)FLIPPED), 3);
            if (state.getValue(HALF) == DoubleBlockHalf.UPPER) {
                level.setBlock(pos.below(), (BlockState)level.getBlockState(pos.below()).cycle((Property)FLIPPED), 3);
            } else {
                level.setBlock(pos.above(), (BlockState)level.getBlockState(pos.above()).cycle((Property)FLIPPED), 3);
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        if (state.getValue(HALF) == DoubleBlockHalf.UPPER && state.getValue(LanternEnum.LANTERN) == LanternEnum.EMPTY) {
            if (stack.is(RisusBlocks.JOYFLAME_LANTERN.asItem())) {
                level.setBlock(pos, (BlockState)state.setValue(LanternEnum.LANTERN, (Comparable)((Object)LanternEnum.CINDERGLEE)), 3);
                stack.shrink(1);
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
            }
            if (stack.is(Blocks.LANTERN.asItem())) {
                level.setBlock(pos, (BlockState)state.setValue(LanternEnum.LANTERN, (Comparable)((Object)LanternEnum.FIRE)), 3);
                stack.shrink(1);
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
            }
            if (stack.is(Blocks.SOUL_LANTERN.asItem())) {
                level.setBlock(pos, (BlockState)state.setValue(LanternEnum.LANTERN, (Comparable)((Object)LanternEnum.SOUL)), 3);
                stack.shrink(1);
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
            }
        }
        if (state.getValue(HALF) == DoubleBlockHalf.UPPER && state.getValue(LanternEnum.LANTERN) != LanternEnum.EMPTY && stack.isEmpty()) {
            level.setBlock(pos, (BlockState)state.setValue(LanternEnum.LANTERN, (Comparable)((Object)LanternEnum.EMPTY)), 3);
            AshenSpireBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)(state.getValue(LanternEnum.LANTERN) == LanternEnum.FIRE ? Blocks.LANTERN.asItem() : (state.getValue(LanternEnum.LANTERN) == LanternEnum.SOUL ? Blocks.SOUL_LANTERN.asItem() : RisusBlocks.JOYFLAME_LANTERN.asItem()))));
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        return super.useItemOn(stack, state, level, pos, player, hand, result);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{HALF, FLIPPED, FLUIDLOGGED, LANTERN});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState fluidstate = context.getLevel().getFluidState(context.getClickedPos());
        return (BlockState)this.defaultBlockState().setValue(FLUIDLOGGED, (Comparable)((Object)SimpleMultiloggedBlock.MultiloggingEnum.getFromFluid(fluidstate.getType())));
    }

    public FluidState getFluidState(BlockState state) {
        return ((SimpleMultiloggedBlock.MultiloggingEnum)((Object)state.getValue(FLUIDLOGGED))).getFluid().defaultFluidState();
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor accessor, BlockPos pos, BlockPos neighborPos) {
        DoubleBlockHalf half = (DoubleBlockHalf)state.getValue(HALF);
        if (state.getValue(FLUIDLOGGED) != SimpleMultiloggedBlock.MultiloggingEnum.EMPTY) {
            accessor.scheduleTick(pos, ((SimpleMultiloggedBlock.MultiloggingEnum)((Object)state.getValue(FLUIDLOGGED))).getFluid(), ((SimpleMultiloggedBlock.MultiloggingEnum)((Object)state.getValue(FLUIDLOGGED))).getFluid().getTickDelay((LevelReader)accessor));
        }
        if (direction.getAxis() != Direction.Axis.Y || half == DoubleBlockHalf.LOWER != (direction == Direction.UP) || neighborState.is((Block)this) && neighborState.getValue(HALF) != half) {
            return half == DoubleBlockHalf.LOWER && direction == Direction.DOWN && !state.canSurvive((LevelReader)accessor, pos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, direction, neighborState, accessor, pos, neighborPos);
        }
        return Blocks.AIR.defaultBlockState();
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos blockpos = pos.below();
        return AshenSpireBlock.canSupportRigidBlock((BlockGetter)level, (BlockPos)blockpos) || AshenSpireBlock.canSupportCenter((LevelReader)level, (BlockPos)blockpos, (Direction)Direction.UP);
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, LivingEntity entity, ItemStack stack) {
        boolean top = state.getValue(HALF) == DoubleBlockHalf.UPPER;
        BlockPos blockpos = top ? pos.below() : pos.above();
        level.setBlock(blockpos, AshenSpireBlock.copyFluidLoggingFrom((LevelReader)level, blockpos, (BlockState)this.defaultBlockState().setValue(HALF, (Comparable)(top ? DoubleBlockHalf.LOWER : DoubleBlockHalf.UPPER))), 3);
    }

    public static BlockState copyFluidLoggingFrom(LevelReader reader, BlockPos pos, BlockState state) {
        return state.hasProperty(FLUIDLOGGED) ? (BlockState)state.setValue(FLUIDLOGGED, (Comparable)((Object)SimpleMultiloggedBlock.MultiloggingEnum.getFromFluid(reader.getFluidState(pos).getType()))) : state;
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        if (!level.isClientSide()) {
            if (player.isCreative()) {
                AshenSpireBlock.preventCreativeDropFromBottomPart(level, pos, state, player);
            } else {
                AshenSpireBlock.dropResources((BlockState)state, (Level)level, (BlockPos)pos, null, (Entity)player, (ItemStack)player.getMainHandItem());
            }
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    public void playerDestroy(Level level, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity blockEntity, ItemStack stack) {
        super.playerDestroy(level, player, pos, Blocks.AIR.defaultBlockState(), blockEntity, stack);
    }

    protected static void preventCreativeDropFromBottomPart(Level level, BlockPos pos, BlockState state, Player player) {
        BlockPos blockpos;
        BlockState blockstate;
        DoubleBlockHalf doubleblockhalf = (DoubleBlockHalf)state.getValue(HALF);
        if (doubleblockhalf == DoubleBlockHalf.UPPER && (blockstate = level.getBlockState(blockpos = pos.below())).is(state.getBlock()) && blockstate.getValue(HALF) == DoubleBlockHalf.LOWER) {
            BlockState blockstate1 = blockstate.hasProperty((Property)BlockStateProperties.WATERLOGGED) && (Boolean)blockstate.getValue((Property)BlockStateProperties.WATERLOGGED) != false ? Blocks.WATER.defaultBlockState() : Blocks.AIR.defaultBlockState();
            level.setBlock(blockpos, blockstate1, 35);
            level.levelEvent(player, 2001, blockpos, Block.getId((BlockState)blockstate));
        }
    }

    public long getSeed(BlockState state, BlockPos pos) {
        return Mth.getSeed((int)pos.getX(), (int)pos.below(state.getValue(HALF) == DoubleBlockHalf.LOWER ? 0 : 1).getY(), (int)pos.getZ());
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter getter, BlockPos pos) {
        return true;
    }

    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean moving) {
        if (state.getValue(LanternEnum.LANTERN) != LanternEnum.EMPTY && newState.getBlock() != state.getBlock()) {
            AshenSpireBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)(state.getValue(LanternEnum.LANTERN) == LanternEnum.FIRE ? Blocks.LANTERN.asItem() : (state.getValue(LanternEnum.LANTERN) == LanternEnum.SOUL ? Blocks.SOUL_LANTERN.asItem() : RisusBlocks.JOYFLAME_LANTERN.asItem()))));
        }
        super.onRemove(state, level, pos, newState, moving);
    }

    public static enum LanternEnum implements StringRepresentable
    {
        EMPTY,
        FIRE,
        SOUL,
        CINDERGLEE;

        public static final EnumProperty<LanternEnum> LANTERN;

        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            LANTERN = EnumProperty.create((String)"lantern", LanternEnum.class);
        }
    }
}

