/*
 * Decompiled with CFR 0.152.
 */
package com.bigdious.risus.blocks;

import com.bigdious.risus.blocks.interfaces.SimpleMultiloggedBlock;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.serialization.MapCodec;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BabyRibcageBlock
extends HorizontalDirectionalBlock
implements SimpleMultiloggedBlock {
    public static final MapCodec<BabyRibcageBlock> CODEC = BabyRibcageBlock.simpleCodec(BabyRibcageBlock::new);
    public static final EnumProperty<SimpleMultiloggedBlock.MultiloggingEnum> FLUIDLOGGED = SimpleMultiloggedBlock.MultiloggingEnum.FLUIDLOGGED;
    private static final Map<Direction, VoxelShape> AABBS = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Block.box((double)3.5, (double)1.0, (double)3.5, (double)12.5, (double)16.0, (double)11.0), (Object)Direction.SOUTH, (Object)Block.box((double)3.5, (double)1.0, (double)5.0, (double)12.5, (double)16.0, (double)12.5), (Object)Direction.WEST, (Object)Block.box((double)3.5, (double)1.0, (double)3.5, (double)11.0, (double)16.0, (double)12.5), (Object)Direction.EAST, (Object)Block.box((double)5.0, (double)1.0, (double)3.5, (double)12.5, (double)16.0, (double)12.5)));

    public BabyRibcageBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue(FLUIDLOGGED, (Comparable)((Object)SimpleMultiloggedBlock.MultiloggingEnum.EMPTY)));
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING, FLUIDLOGGED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState fluidstate = context.getLevel().getFluidState(context.getClickedPos());
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue(FLUIDLOGGED, (Comparable)((Object)SimpleMultiloggedBlock.MultiloggingEnum.getFromFluid(fluidstate.getType())));
    }

    public FluidState getFluidState(BlockState state) {
        return ((SimpleMultiloggedBlock.MultiloggingEnum)((Object)state.getValue(FLUIDLOGGED))).getFluid().defaultFluidState();
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor accessor, BlockPos pos, BlockPos neighborPos) {
        if (state.getValue(FLUIDLOGGED) != SimpleMultiloggedBlock.MultiloggingEnum.EMPTY) {
            accessor.scheduleTick(pos, ((SimpleMultiloggedBlock.MultiloggingEnum)((Object)state.getValue(FLUIDLOGGED))).getFluid(), ((SimpleMultiloggedBlock.MultiloggingEnum)((Object)state.getValue(FLUIDLOGGED))).getFluid().getTickDelay((LevelReader)accessor));
        }
        return super.updateShape(state, direction, neighborState, accessor, pos, neighborPos);
    }

    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return AABBS.get(state.getValue((Property)FACING));
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public float getShadeBrightness(BlockState state, BlockGetter getter, BlockPos pos) {
        return 1.0f;
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter getter, BlockPos pos) {
        return true;
    }
}

