/*
 * Decompiled with CFR 0.152.
 */
package com.bigdious.risus.blocks;

import com.bigdious.risus.init.RisusCauldronInteractions;
import com.bigdious.risus.init.RisusMobEffects;
import com.bigdious.risus.init.RisusTags;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;

public class BloodCauldronBlock
extends AbstractCauldronBlock {
    public static final MapCodec<BloodCauldronBlock> CODEC = BloodCauldronBlock.simpleCodec(BloodCauldronBlock::new);

    public BloodCauldronBlock(BlockBehaviour.Properties properties) {
        super(properties, RisusCauldronInteractions.BLOOD);
    }

    protected MapCodec<? extends AbstractCauldronBlock> codec() {
        return CODEC;
    }

    public boolean isFull(BlockState state) {
        return true;
    }

    protected double getContentHeight(BlockState state) {
        return 0.9375;
    }

    public int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        return 3;
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        LivingEntity livingEntity;
        if (entity.isAlive() && entity instanceof LivingEntity && !(livingEntity = (LivingEntity)entity).getType().is(RisusTags.Entities.OFFSPRING) && livingEntity.getAttribute(Attributes.MAX_HEALTH) != null && livingEntity.getAttribute(Attributes.MAX_HEALTH).getValue() > (double)livingEntity.getHealth()) {
            livingEntity.addEffect(new MobEffectInstance(RisusMobEffects.BLOODCLOGGED, 40, (int)livingEntity.getMaxHealth() - (int)livingEntity.getHealth() - 1, false, false, true));
        }
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        return new ItemStack((ItemLike)Items.CAULDRON);
    }
}

