/*
 * Decompiled with CFR 0.152.
 */
package com.bigdious.risus.blocks;

import com.bigdious.risus.blocks.entity.DepthVaseBlockEntity;
import com.bigdious.risus.blocks.interfaces.SimpleMultiloggedBlock;
import com.bigdious.risus.init.RisusItems;
import com.bigdious.risus.init.RisusParticles;
import com.bigdious.risus.init.RisusSoundEvents;
import com.bigdious.risus.init.RisusTags;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class DepthVaseBlock
extends BaseEntityBlock
implements SimpleMultiloggedBlock {
    public static final MapCodec<DepthVaseBlock> CODEC = DepthVaseBlock.simpleCodec(DepthVaseBlock::new);
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final EnumProperty<SimpleMultiloggedBlock.MultiloggingEnum> FLUIDLOGGED = SimpleMultiloggedBlock.MultiloggingEnum.FLUIDLOGGED;
    protected static final VoxelShape BOUNDING_BOX = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0);

    public DepthVaseBlock(BlockBehaviour.Properties props) {
        super(props);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(FLUIDLOGGED, (Comparable)((Object)SimpleMultiloggedBlock.MultiloggingEnum.EMPTY)));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING, FLUIDLOGGED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState fluidstate = context.getLevel().getFluidState(context.getClickedPos());
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection())).setValue(FLUIDLOGGED, (Comparable)((Object)SimpleMultiloggedBlock.MultiloggingEnum.getFromFluid(fluidstate.getType())));
    }

    public FluidState getFluidState(BlockState state) {
        return ((SimpleMultiloggedBlock.MultiloggingEnum)((Object)state.getValue(FLUIDLOGGED))).getFluid().defaultFluidState();
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor accessor, BlockPos pos, BlockPos neighborPos) {
        if (state.getValue(FLUIDLOGGED) != SimpleMultiloggedBlock.MultiloggingEnum.EMPTY) {
            accessor.scheduleTick(pos, ((SimpleMultiloggedBlock.MultiloggingEnum)((Object)state.getValue(FLUIDLOGGED))).getFluid(), ((SimpleMultiloggedBlock.MultiloggingEnum)((Object)state.getValue(FLUIDLOGGED))).getFluid().getTickDelay((LevelReader)accessor));
        }
        return super.updateShape(state, direction, neighborState, accessor, pos, neighborPos);
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return BOUNDING_BOX;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof DepthVaseBlockEntity) {
            DepthVaseBlockEntity vase = (DepthVaseBlockEntity)blockEntity;
            if (stack.is(RisusItems.RESEARCHERS_NOTES)) {
                if (level.isClientSide()) {
                    player.displayClientMessage((Component)Component.literal((String)(vase.depthToSlotRatio + " Slots")), true);
                }
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
            }
            if (!player.isCrouching() && !stack.isEmpty()) {
                for (int i = 0; i < vase.depthToSlotRatio; ++i) {
                    ItemStack currentItem = vase.getItem(i);
                    if (!currentItem.isEmpty() && (!ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)currentItem) || currentItem.getCount() >= currentItem.getMaxStackSize())) continue;
                    int toInsert = Math.min(stack.getCount() + currentItem.getCount(), stack.getMaxStackSize()) - currentItem.getCount();
                    ItemStack inputItem = stack.split(toInsert);
                    if (currentItem.isEmpty()) {
                        vase.setItem(i, inputItem);
                    } else {
                        currentItem.grow(inputItem.getCount());
                    }
                    player.awardStat(Stats.ITEM_USED.get((Object)stack.getItem()));
                    this.playWobbleEffects(vase, level, pos, (ParticleOptions)ParticleTypes.SMOKE);
                    return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
                }
            }
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        return ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof DepthVaseBlockEntity) {
            DepthVaseBlockEntity vase = (DepthVaseBlockEntity)blockEntity;
            if (!player.isCrouching() && !vase.isEmpty()) {
                for (int i = vase.depthToSlotRatio - 1; i >= 0; --i) {
                    if (vase.getItem(i).isEmpty()) continue;
                    ItemEntity item = new ItemEntity(level, player.getX(), player.getY(), player.getZ(), vase.getItem(i));
                    level.addFreshEntity((Entity)item);
                    vase.setItem(i, ItemStack.EMPTY);
                    this.playWobbleEffects(vase, level, pos, (ParticleOptions)RisusParticles.RISUS_SOUL_PARTICLE.get());
                    return InteractionResult.SUCCESS;
                }
            }
            level.playSound(null, pos, (SoundEvent)RisusSoundEvents.DEPTH_VASE_INSERT_FAIL.get(), SoundSource.BLOCKS);
            vase.wobble(DepthVaseBlockEntity.DepthWobbleStyle.NEGATIVE);
            level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, pos);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private void playWobbleEffects(DepthVaseBlockEntity entity, Level level, BlockPos pos, ParticleOptions particle) {
        entity.wobble(DepthVaseBlockEntity.DepthWobbleStyle.POSITIVE);
        level.playSound(null, pos, (SoundEvent)RisusSoundEvents.DEPTH_VASE_INSERT.get(), SoundSource.BLOCKS, 1.0f, 0.7f);
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            serverlevel.sendParticles(particle, (double)pos.getX() + 0.5, (double)pos.getY() + 1.0, (double)pos.getZ() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public void onProjectileHit(Level level, BlockState state, BlockHitResult result, Projectile projectile) {
        BlockPos blockpos = result.getBlockPos();
        if (!level.isClientSide() && projectile.mayInteract(level, blockpos) && projectile.getType().is(RisusTags.Entities.BREAKS_DEPTH_VASES)) {
            level.destroyBlock(blockpos, true, (Entity)projectile);
        }
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean moving) {
        Containers.dropContentsOnDestroy((BlockState)state, (BlockState)newState, (Level)level, (BlockPos)pos);
        super.onRemove(state, level, pos, newState, moving);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new DepthVaseBlockEntity(pos, state);
    }
}

