/*
 * Decompiled with CFR 0.152.
 */
package com.bigdious.risus.blocks;

import com.bigdious.risus.blocks.entity.DisplayNotchBlockEntity;
import com.bigdious.risus.blocks.interfaces.SimpleMultiloggedBlock;
import com.bigdious.risus.init.RisusBlocks;
import com.google.common.collect.Maps;
import com.mojang.serialization.MapCodec;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.registries.DeferredBlock;
import org.jetbrains.annotations.Nullable;

public class DisplayNotchBlock
extends BaseEntityBlock
implements SimpleMultiloggedBlock {
    public static final MapCodec<DisplayNotchBlock> CODEC = DisplayNotchBlock.simpleCodec(DisplayNotchBlock::new);
    private static final VoxelShape SHAPE1 = Block.box((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)1.0, (double)9.0);
    private static final VoxelShape SHAPE2 = Block.box((double)7.0, (double)15.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0);
    private static final VoxelShape SHAPE3 = Block.box((double)7.0, (double)7.0, (double)15.0, (double)9.0, (double)9.0, (double)16.0);
    private static final VoxelShape SHAPE4 = Block.box((double)7.0, (double)7.0, (double)0.0, (double)9.0, (double)9.0, (double)1.0);
    private static final VoxelShape SHAPE5 = Block.box((double)15.0, (double)7.0, (double)7.0, (double)16.0, (double)9.0, (double)9.0);
    private static final VoxelShape SHAPE6 = Block.box((double)0.0, (double)7.0, (double)7.0, (double)1.0, (double)9.0, (double)9.0);
    public static final EnumProperty<SimpleMultiloggedBlock.MultiloggingEnum> FLUIDLOGGED = SimpleMultiloggedBlock.MultiloggingEnum.FLUIDLOGGED;
    public static final DirectionProperty FACING = BlockStateProperties.FACING;
    public static final BooleanProperty ELEVATE = BooleanProperty.create((String)"elevate");
    public static final BooleanProperty GLOWING = BooleanProperty.create((String)"glowing");
    public static final BooleanProperty PHANTOM = BooleanProperty.create((String)"phantom");
    public static final BooleanProperty LOCKED = BooleanProperty.create((String)"locked");
    public static final IntegerProperty ROTATION = BlockStateProperties.ROTATION_16;
    public static final Map<DyeColor, DeferredBlock<Block>> NOTCH_BY_DYE = (Map)Util.make((Object)Maps.newEnumMap(DyeColor.class), map -> {
        map.put(DyeColor.WHITE, RisusBlocks.WHITE_DISPLAY_NOTCH);
        map.put(DyeColor.ORANGE, RisusBlocks.ORANGE_DISPLAY_NOTCH);
        map.put(DyeColor.MAGENTA, RisusBlocks.MAGENTA_DISPLAY_NOTCH);
        map.put(DyeColor.LIGHT_BLUE, RisusBlocks.LIGHT_BLUE_DISPLAY_NOTCH);
        map.put(DyeColor.YELLOW, RisusBlocks.YELLOW_DISPLAY_NOTCH);
        map.put(DyeColor.LIME, RisusBlocks.LIME_DISPLAY_NOTCH);
        map.put(DyeColor.PINK, RisusBlocks.PINK_DISPLAY_NOTCH);
        map.put(DyeColor.GRAY, RisusBlocks.GRAY_DISPLAY_NOTCH);
        map.put(DyeColor.LIGHT_GRAY, RisusBlocks.LIGHT_GRAY_DISPLAY_NOTCH);
        map.put(DyeColor.CYAN, RisusBlocks.CYAN_DISPLAY_NOTCH);
        map.put(DyeColor.PURPLE, RisusBlocks.PURPLE_DISPLAY_NOTCH);
        map.put(DyeColor.BLUE, RisusBlocks.BLUE_DISPLAY_NOTCH);
        map.put(DyeColor.BROWN, RisusBlocks.BROWN_DISPLAY_NOTCH);
        map.put(DyeColor.GREEN, RisusBlocks.GREEN_DISPLAY_NOTCH);
        map.put(DyeColor.RED, RisusBlocks.RED_DISPLAY_NOTCH);
        map.put(DyeColor.BLACK, RisusBlocks.DISPLAY_NOTCH);
    });

    public DisplayNotchBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue(FLUIDLOGGED, (Comparable)((Object)SimpleMultiloggedBlock.MultiloggingEnum.EMPTY))).setValue((Property)FACING, (Comparable)Direction.UP)).setValue((Property)GLOWING, (Comparable)Boolean.valueOf(false))).setValue((Property)PHANTOM, (Comparable)Boolean.valueOf(false))).setValue((Property)ROTATION, (Comparable)Integer.valueOf(0))).setValue((Property)ELEVATE, (Comparable)Boolean.valueOf(false))).setValue((Property)LOCKED, (Comparable)Boolean.valueOf(false)));
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof DisplayNotchBlockEntity)) {
            return ItemInteractionResult.FAIL;
        }
        DisplayNotchBlockEntity notch = (DisplayNotchBlockEntity)blockEntity;
        if (((Boolean)state.getValue((Property)LOCKED)).booleanValue() && !stack.is(Items.TRIPWIRE_HOOK)) {
            return ItemInteractionResult.FAIL;
        }
        if (!notch.getTheItem().isEmpty() && stack.is(Items.TRIPWIRE_HOOK)) {
            level.setBlock(pos, (BlockState)state.cycle((Property)LOCKED), 3);
            level.sendBlockUpdated(pos, state, state, 2);
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        if (!notch.getTheItem().isEmpty() && stack.is(ItemTags.SHOVELS)) {
            level.setBlock(pos, (BlockState)state.cycle((Property)ELEVATE), 3);
            level.sendBlockUpdated(pos, state, state, 2);
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        if (!notch.getTheItem().isEmpty() && stack.is(Items.GLOW_INK_SAC)) {
            level.setBlock(pos, (BlockState)state.cycle((Property)GLOWING), 3);
            level.sendBlockUpdated(pos, state, state, 2);
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        if (!notch.getTheItem().isEmpty() && stack.is(ItemTags.PICKAXES)) {
            level.setBlock(pos, (BlockState)state.cycle((Property)ROTATION), 3);
            level.sendBlockUpdated(pos, state, state, 2);
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        if (!notch.getTheItem().isEmpty() && stack.is(Items.PHANTOM_MEMBRANE)) {
            level.setBlock(pos, (BlockState)state.cycle((Property)PHANTOM), 3);
            level.sendBlockUpdated(pos, state, state, 2);
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        if (!notch.getTheItem().isEmpty() && notch.handleBEInteractions(stack, level, pos, state)) {
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        if (!level.isClientSide()) {
            if (notch.getTheItem().isEmpty()) {
                if (player.isCreative()) {
                    notch.setTheItem(player.getItemInHand(hand));
                } else {
                    notch.setTheItem(player.getInventory().removeItem(player.getInventory().selected, 1));
                }
            } else {
                if (!player.isCreative()) {
                    ItemEntity item = new ItemEntity(level, player.getX(), player.getY(), player.getZ(), notch.getTheItem());
                    level.addFreshEntity((Entity)item);
                }
                notch.setTheItem(ItemStack.EMPTY);
            }
            notch.setChanged();
            level.sendBlockUpdated(pos, state, state, 2);
        }
        return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState fluidstate = context.getLevel().getFluidState(context.getClickedPos());
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getClickedFace())).setValue(FLUIDLOGGED, (Comparable)((Object)SimpleMultiloggedBlock.MultiloggingEnum.getFromFluid(fluidstate.getType())));
    }

    public BlockState rotate(BlockState blockState, Rotation rotation) {
        return (BlockState)blockState.setValue((Property)FACING, (Comparable)rotation.rotation().rotate((Direction)blockState.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState blockState, Mirror mirror) {
        return (BlockState)blockState.setValue((Property)FACING, (Comparable)mirror.rotation().rotate((Direction)blockState.getValue((Property)FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, FLUIDLOGGED, ELEVATE, LOCKED, ROTATION, GLOWING, PHANTOM});
    }

    public FluidState getFluidState(BlockState state) {
        return ((SimpleMultiloggedBlock.MultiloggingEnum)((Object)state.getValue(FLUIDLOGGED))).getFluid().defaultFluidState();
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor accessor, BlockPos pos, BlockPos neighborPos) {
        if (state.getValue(FLUIDLOGGED) != SimpleMultiloggedBlock.MultiloggingEnum.EMPTY) {
            accessor.scheduleTick(pos, ((SimpleMultiloggedBlock.MultiloggingEnum)((Object)state.getValue(FLUIDLOGGED))).getFluid(), ((SimpleMultiloggedBlock.MultiloggingEnum)((Object)state.getValue(FLUIDLOGGED))).getFluid().getTickDelay((LevelReader)accessor));
        }
        return super.updateShape(state, direction, neighborState, accessor, pos, neighborPos);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.DOWN -> SHAPE2;
            case Direction.NORTH -> SHAPE3;
            case Direction.SOUTH -> SHAPE4;
            case Direction.WEST -> SHAPE5;
            case Direction.EAST -> SHAPE6;
            default -> SHAPE1;
        };
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new DisplayNotchBlockEntity(pos, state);
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean moving) {
        if (!(newState.getBlock() instanceof DisplayNotchBlock)) {
            BlockEntity blockentity = level.getBlockEntity(pos);
            if (blockentity instanceof Container) {
                Container container = (Container)blockentity;
                Containers.dropContents((Level)level, (BlockPos)pos, (Container)container);
                level.updateNeighbourForOutputSignal(pos, (Block)this);
            }
            super.onRemove(state, level, pos, newState, moving);
        }
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        return new ItemStack(RisusBlocks.DISPLAY_NOTCH);
    }

    protected int getAnalogOutputSignal(BlockState blockState, Level level, BlockPos pos) {
        return DisplayNotchBlock.getOutputSignal((Integer)blockState.getValue((Property)ROTATION));
    }

    public static int getOutputSignal(int rotation) {
        return rotation;
    }

    protected boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext collision) {
        if (((Boolean)state.getValue((Property)PHANTOM)).booleanValue()) {
            return Shapes.empty();
        }
        return super.getCollisionShape(state, getter, pos, collision);
    }
}

