/*
 * Decompiled with CFR 0.152.
 */
package com.bigdious.risus.blocks;

import com.bigdious.risus.blocks.interfaces.SimpleMultiloggedBlock;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WallSide;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class RisusWallBlock
extends Block
implements SimpleMultiloggedBlock {
    public static final EnumProperty<SimpleMultiloggedBlock.MultiloggingEnum> FLUIDLOGGED = SimpleMultiloggedBlock.MultiloggingEnum.FLUIDLOGGED;
    public static final BooleanProperty UP = BlockStateProperties.UP;
    public static final EnumProperty<WallSide> EAST_WALL = BlockStateProperties.EAST_WALL;
    public static final EnumProperty<WallSide> NORTH_WALL = BlockStateProperties.NORTH_WALL;
    public static final EnumProperty<WallSide> SOUTH_WALL = BlockStateProperties.SOUTH_WALL;
    public static final EnumProperty<WallSide> WEST_WALL = BlockStateProperties.WEST_WALL;
    private final Map<BlockState, VoxelShape> shapeByIndex;
    private final Map<BlockState, VoxelShape> collisionShapeByIndex;
    private static final VoxelShape POST_TEST = Block.box((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0);
    private static final VoxelShape NORTH_TEST = Block.box((double)7.0, (double)0.0, (double)0.0, (double)9.0, (double)16.0, (double)9.0);
    private static final VoxelShape SOUTH_TEST = Block.box((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)16.0);
    private static final VoxelShape WEST_TEST = Block.box((double)0.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0);
    private static final VoxelShape EAST_TEST = Block.box((double)7.0, (double)0.0, (double)7.0, (double)16.0, (double)16.0, (double)9.0);

    public RisusWallBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)UP, (Comparable)Boolean.valueOf(true))).setValue(NORTH_WALL, (Comparable)WallSide.NONE)).setValue(EAST_WALL, (Comparable)WallSide.NONE)).setValue(SOUTH_WALL, (Comparable)WallSide.NONE)).setValue(WEST_WALL, (Comparable)WallSide.NONE)).setValue(FLUIDLOGGED, (Comparable)((Object)SimpleMultiloggedBlock.MultiloggingEnum.EMPTY)));
        this.shapeByIndex = this.makeShapes(4.0f, 3.0f, 16.0f, 0.0f, 14.0f, 16.0f);
        this.collisionShapeByIndex = this.makeShapes(4.0f, 3.0f, 24.0f, 0.0f, 24.0f, 24.0f);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{UP, NORTH_WALL, EAST_WALL, WEST_WALL, SOUTH_WALL, FLUIDLOGGED});
    }

    public static VoxelShape applyWallShape(VoxelShape baseShape, WallSide height, VoxelShape lowShape, VoxelShape tallShape) {
        if (height == WallSide.TALL) {
            return Shapes.or((VoxelShape)baseShape, (VoxelShape)tallShape);
        }
        return height == WallSide.LOW ? Shapes.or((VoxelShape)baseShape, (VoxelShape)lowShape) : baseShape;
    }

    public Map<BlockState, VoxelShape> makeShapes(float pWidth, float pDepth, float pWallPostHeight, float pWallMinY, float pWallLowHeight, float pWallTallHeight) {
        float f = 8.0f - pWidth;
        float f1 = 8.0f + pWidth;
        float f2 = 8.0f - pDepth;
        float f3 = 8.0f + pDepth;
        VoxelShape voxelshape = Block.box((double)f, (double)0.0, (double)f, (double)f1, (double)pWallPostHeight, (double)f1);
        VoxelShape voxelshape1 = Block.box((double)f2, (double)pWallMinY, (double)0.0, (double)f3, (double)pWallLowHeight, (double)f3);
        VoxelShape voxelshape2 = Block.box((double)f2, (double)pWallMinY, (double)f2, (double)f3, (double)pWallLowHeight, (double)16.0);
        VoxelShape voxelshape3 = Block.box((double)0.0, (double)pWallMinY, (double)f2, (double)f3, (double)pWallLowHeight, (double)f3);
        VoxelShape voxelshape4 = Block.box((double)f2, (double)pWallMinY, (double)f2, (double)16.0, (double)pWallLowHeight, (double)f3);
        VoxelShape voxelshape5 = Block.box((double)f2, (double)pWallMinY, (double)0.0, (double)f3, (double)pWallTallHeight, (double)f3);
        VoxelShape voxelshape6 = Block.box((double)f2, (double)pWallMinY, (double)f2, (double)f3, (double)pWallTallHeight, (double)16.0);
        VoxelShape voxelshape7 = Block.box((double)0.0, (double)pWallMinY, (double)f2, (double)f3, (double)pWallTallHeight, (double)f3);
        VoxelShape voxelshape8 = Block.box((double)f2, (double)pWallMinY, (double)f2, (double)16.0, (double)pWallTallHeight, (double)f3);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Boolean obool : UP.getPossibleValues()) {
            for (WallSide wallside : EAST_WALL.getPossibleValues()) {
                for (WallSide wallside1 : NORTH_WALL.getPossibleValues()) {
                    for (WallSide wallside2 : WEST_WALL.getPossibleValues()) {
                        for (WallSide wallside3 : SOUTH_WALL.getPossibleValues()) {
                            VoxelShape voxelshape9 = Shapes.empty();
                            voxelshape9 = RisusWallBlock.applyWallShape(voxelshape9, wallside, voxelshape4, voxelshape8);
                            voxelshape9 = RisusWallBlock.applyWallShape(voxelshape9, wallside2, voxelshape3, voxelshape7);
                            voxelshape9 = RisusWallBlock.applyWallShape(voxelshape9, wallside1, voxelshape1, voxelshape5);
                            voxelshape9 = RisusWallBlock.applyWallShape(voxelshape9, wallside3, voxelshape2, voxelshape6);
                            if (obool.booleanValue()) {
                                voxelshape9 = Shapes.or((VoxelShape)voxelshape9, (VoxelShape)voxelshape);
                            }
                            BlockState blockstate = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)UP, (Comparable)obool)).setValue(EAST_WALL, (Comparable)wallside)).setValue(WEST_WALL, (Comparable)wallside2)).setValue(NORTH_WALL, (Comparable)wallside1)).setValue(SOUTH_WALL, (Comparable)wallside3);
                            builder.put((Object)((BlockState)blockstate.setValue(FLUIDLOGGED, (Comparable)((Object)SimpleMultiloggedBlock.MultiloggingEnum.EMPTY))), (Object)voxelshape9);
                            builder.put((Object)((BlockState)blockstate.setValue(FLUIDLOGGED, (Comparable)((Object)SimpleMultiloggedBlock.MultiloggingEnum.LAVA))), (Object)voxelshape9);
                            builder.put((Object)((BlockState)blockstate.setValue(FLUIDLOGGED, (Comparable)((Object)SimpleMultiloggedBlock.MultiloggingEnum.WATER))), (Object)voxelshape9);
                            builder.put((Object)((BlockState)blockstate.setValue(FLUIDLOGGED, (Comparable)((Object)SimpleMultiloggedBlock.MultiloggingEnum.BLOOD))), (Object)voxelshape9);
                        }
                    }
                }
            }
        }
        return builder.build();
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.shapeByIndex.get(state);
    }

    protected VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.collisionShapeByIndex.get(state);
    }

    public boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    private boolean connectsTo(BlockState state, boolean sideSolid, Direction direction) {
        Block block = state.getBlock();
        boolean flag = block instanceof FenceGateBlock && FenceGateBlock.connectsToDirection((BlockState)state, (Direction)direction);
        return state.is(BlockTags.WALLS) || !RisusWallBlock.isExceptionForConnection((BlockState)state) && sideSolid || block instanceof IronBarsBlock || flag;
    }

    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        Level levelreader = pContext.getLevel();
        BlockPos blockpos = pContext.getClickedPos();
        FluidState fluidstate = pContext.getLevel().getFluidState(pContext.getClickedPos());
        BlockPos blockpos1 = blockpos.north();
        BlockPos blockpos2 = blockpos.east();
        BlockPos blockpos3 = blockpos.south();
        BlockPos blockpos4 = blockpos.west();
        BlockPos blockpos5 = blockpos.above();
        BlockState blockstate = levelreader.getBlockState(blockpos1);
        BlockState blockstate1 = levelreader.getBlockState(blockpos2);
        BlockState blockstate2 = levelreader.getBlockState(blockpos3);
        BlockState blockstate3 = levelreader.getBlockState(blockpos4);
        BlockState blockstate4 = levelreader.getBlockState(blockpos5);
        boolean flag = this.connectsTo(blockstate, blockstate.isFaceSturdy((BlockGetter)levelreader, blockpos1, Direction.SOUTH), Direction.SOUTH);
        boolean flag1 = this.connectsTo(blockstate1, blockstate1.isFaceSturdy((BlockGetter)levelreader, blockpos2, Direction.WEST), Direction.WEST);
        boolean flag2 = this.connectsTo(blockstate2, blockstate2.isFaceSturdy((BlockGetter)levelreader, blockpos3, Direction.NORTH), Direction.NORTH);
        boolean flag3 = this.connectsTo(blockstate3, blockstate3.isFaceSturdy((BlockGetter)levelreader, blockpos4, Direction.EAST), Direction.EAST);
        BlockState blockstate5 = (BlockState)this.defaultBlockState().setValue(FLUIDLOGGED, (Comparable)((Object)SimpleMultiloggedBlock.MultiloggingEnum.getFromFluid(fluidstate.getType())));
        return this.updateShape((LevelReader)levelreader, blockstate5, blockpos5, blockstate4, flag, flag1, flag2, flag3);
    }

    public FluidState getFluidState(BlockState state) {
        return ((SimpleMultiloggedBlock.MultiloggingEnum)((Object)state.getValue(FLUIDLOGGED))).getFluid().defaultFluidState();
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor accessor, BlockPos pos, BlockPos neighborPos) {
        if (state.getValue(FLUIDLOGGED) != SimpleMultiloggedBlock.MultiloggingEnum.EMPTY) {
            accessor.scheduleTick(pos, ((SimpleMultiloggedBlock.MultiloggingEnum)((Object)state.getValue(FLUIDLOGGED))).getFluid(), ((SimpleMultiloggedBlock.MultiloggingEnum)((Object)state.getValue(FLUIDLOGGED))).getFluid().getTickDelay((LevelReader)accessor));
        }
        if (direction == Direction.DOWN) {
            return state;
        }
        return direction == Direction.UP ? this.topUpdate((LevelReader)accessor, state, neighborPos, neighborState) : this.sideUpdate((LevelReader)accessor, pos, state, neighborPos, neighborState, direction);
    }

    private static boolean isConnected(BlockState state, Property<WallSide> heightProperty) {
        return state.getValue(heightProperty) != WallSide.NONE;
    }

    private static boolean isCovered(VoxelShape firstShape, VoxelShape secondShape) {
        return !Shapes.joinIsNotEmpty((VoxelShape)secondShape, (VoxelShape)firstShape, (BooleanOp)BooleanOp.ONLY_FIRST);
    }

    public BlockState topUpdate(LevelReader level, BlockState state, BlockPos pos, BlockState secondState) {
        boolean flag = RisusWallBlock.isConnected(state, NORTH_WALL);
        boolean flag1 = RisusWallBlock.isConnected(state, EAST_WALL);
        boolean flag2 = RisusWallBlock.isConnected(state, SOUTH_WALL);
        boolean flag3 = RisusWallBlock.isConnected(state, WEST_WALL);
        return this.updateShape(level, state, pos, secondState, flag, flag1, flag2, flag3);
    }

    public BlockState sideUpdate(LevelReader level, BlockPos firstPos, BlockState firstState, BlockPos secondPos, BlockState secondState, Direction dir) {
        Direction direction = dir.getOpposite();
        boolean flag = dir == Direction.NORTH ? this.connectsTo(secondState, secondState.isFaceSturdy((BlockGetter)level, secondPos, direction), direction) : RisusWallBlock.isConnected(firstState, NORTH_WALL);
        boolean flag1 = dir == Direction.EAST ? this.connectsTo(secondState, secondState.isFaceSturdy((BlockGetter)level, secondPos, direction), direction) : RisusWallBlock.isConnected(firstState, EAST_WALL);
        boolean flag2 = dir == Direction.SOUTH ? this.connectsTo(secondState, secondState.isFaceSturdy((BlockGetter)level, secondPos, direction), direction) : RisusWallBlock.isConnected(firstState, SOUTH_WALL);
        boolean flag3 = dir == Direction.WEST ? this.connectsTo(secondState, secondState.isFaceSturdy((BlockGetter)level, secondPos, direction), direction) : RisusWallBlock.isConnected(firstState, WEST_WALL);
        BlockPos blockpos = firstPos.above();
        BlockState blockstate = level.getBlockState(blockpos);
        return this.updateShape(level, firstState, blockpos, blockstate, flag, flag1, flag2, flag3);
    }

    public BlockState updateShape(LevelReader level, BlockState state, BlockPos pos, BlockState neighbour, boolean northConnection, boolean eastConnection, boolean southConnection, boolean westConnection) {
        VoxelShape voxelshape = neighbour.getCollisionShape((BlockGetter)level, pos).getFaceShape(Direction.DOWN);
        BlockState blockstate = this.updateSides(state, northConnection, eastConnection, southConnection, westConnection, voxelshape);
        return (BlockState)blockstate.setValue((Property)UP, (Comparable)Boolean.valueOf(this.shouldRaisePost(blockstate, neighbour, voxelshape)));
    }

    private boolean shouldRaisePost(BlockState state, BlockState neighbour, VoxelShape shape) {
        boolean flag5;
        boolean flag;
        boolean bl = flag = neighbour.getBlock() instanceof WallBlock && (Boolean)neighbour.getValue((Property)UP) != false;
        if (flag) {
            return true;
        }
        WallSide wallside = (WallSide)state.getValue(NORTH_WALL);
        WallSide wallside1 = (WallSide)state.getValue(SOUTH_WALL);
        WallSide wallside2 = (WallSide)state.getValue(EAST_WALL);
        WallSide wallside3 = (WallSide)state.getValue(WEST_WALL);
        boolean flag1 = wallside1 == WallSide.NONE;
        boolean flag2 = wallside3 == WallSide.NONE;
        boolean flag3 = wallside2 == WallSide.NONE;
        boolean flag4 = wallside == WallSide.NONE;
        boolean bl2 = flag5 = flag4 && flag1 && flag2 && flag3 || flag4 != flag1 || flag2 != flag3;
        if (flag5) {
            return true;
        }
        boolean flag6 = wallside == WallSide.TALL && wallside1 == WallSide.TALL || wallside2 == WallSide.TALL && wallside3 == WallSide.TALL;
        return !flag6 && (neighbour.is(BlockTags.WALL_POST_OVERRIDE) || RisusWallBlock.isCovered(shape, POST_TEST));
    }

    private BlockState updateSides(BlockState state, boolean northConnection, boolean eastConnection, boolean southConnection, boolean westConnection, VoxelShape wallShape) {
        return (BlockState)((BlockState)((BlockState)((BlockState)state.setValue(NORTH_WALL, (Comparable)this.makeWallState(northConnection, wallShape, NORTH_TEST))).setValue(EAST_WALL, (Comparable)this.makeWallState(eastConnection, wallShape, EAST_TEST))).setValue(SOUTH_WALL, (Comparable)this.makeWallState(southConnection, wallShape, SOUTH_TEST))).setValue(WEST_WALL, (Comparable)this.makeWallState(westConnection, wallShape, WEST_TEST));
    }

    private WallSide makeWallState(boolean allowConnection, VoxelShape shape, VoxelShape neighbourShape) {
        if (allowConnection) {
            return RisusWallBlock.isCovered(shape, neighbourShape) ? WallSide.TALL : WallSide.LOW;
        }
        return WallSide.NONE;
    }

    protected BlockState rotate(BlockState state, Rotation rotation) {
        switch (rotation) {
            case CLOCKWISE_180: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.setValue(NORTH_WALL, (Comparable)((WallSide)state.getValue(SOUTH_WALL)))).setValue(EAST_WALL, (Comparable)((WallSide)state.getValue(WEST_WALL)))).setValue(SOUTH_WALL, (Comparable)((WallSide)state.getValue(NORTH_WALL)))).setValue(WEST_WALL, (Comparable)((WallSide)state.getValue(EAST_WALL)));
            }
            case COUNTERCLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.setValue(NORTH_WALL, (Comparable)((WallSide)state.getValue(EAST_WALL)))).setValue(EAST_WALL, (Comparable)((WallSide)state.getValue(SOUTH_WALL)))).setValue(SOUTH_WALL, (Comparable)((WallSide)state.getValue(WEST_WALL)))).setValue(WEST_WALL, (Comparable)((WallSide)state.getValue(NORTH_WALL)));
            }
            case CLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.setValue(NORTH_WALL, (Comparable)((WallSide)state.getValue(WEST_WALL)))).setValue(EAST_WALL, (Comparable)((WallSide)state.getValue(NORTH_WALL)))).setValue(SOUTH_WALL, (Comparable)((WallSide)state.getValue(EAST_WALL)))).setValue(WEST_WALL, (Comparable)((WallSide)state.getValue(SOUTH_WALL)));
            }
        }
        return state;
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        switch (mirror) {
            case LEFT_RIGHT: {
                return (BlockState)((BlockState)state.setValue(NORTH_WALL, (Comparable)((WallSide)state.getValue(SOUTH_WALL)))).setValue(SOUTH_WALL, (Comparable)((WallSide)state.getValue(NORTH_WALL)));
            }
            case FRONT_BACK: {
                return (BlockState)((BlockState)state.setValue(EAST_WALL, (Comparable)((WallSide)state.getValue(WEST_WALL)))).setValue(WEST_WALL, (Comparable)((WallSide)state.getValue(EAST_WALL)));
            }
        }
        return super.mirror(state, mirror);
    }

    public boolean propagatesSkylightDown(BlockState pState, BlockGetter pReader, BlockPos pPos) {
        return pState.getValue(FLUIDLOGGED) == SimpleMultiloggedBlock.MultiloggingEnum.EMPTY;
    }

    @Override
    public boolean canPlaceLiquid(@Nullable Player player, BlockGetter getter, BlockPos pos, BlockState state, Fluid fluid) {
        return SimpleMultiloggedBlock.super.canPlaceLiquid(player, getter, pos, state, fluid);
    }

    @Override
    public ItemStack pickupBlock(@Nullable Player pPlayer, LevelAccessor pLevel, BlockPos pPos, BlockState pState) {
        return SimpleMultiloggedBlock.super.pickupBlock(pPlayer, pLevel, pPos, pState);
    }

    @Override
    public boolean placeLiquid(LevelAccessor pLevel, BlockPos pPos, BlockState pState, FluidState pFluidState) {
        return SimpleMultiloggedBlock.super.placeLiquid(pLevel, pPos, pState, pFluidState);
    }

    public int getLightEmission(BlockState state, BlockGetter getter, BlockPos pos) {
        return state.getValue(SimpleMultiloggedBlock.MultiloggingEnum.FLUIDLOGGED) == SimpleMultiloggedBlock.MultiloggingEnum.LAVA ? 15 : 0;
    }
}

