/*
 * Decompiled with CFR 0.152.
 */
package com.bigdious.risus.blocks.entity;

import com.bigdious.risus.init.RisusBlockEntities;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.RandomizableContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.SeededContainerLoot;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootTable;

public class DepthVaseBlockEntity
extends BlockEntity
implements RandomizableContainer {
    public final int depthToSlotRatio = (int)Math.round(81.0 - (double)(this.getBlockPos().getY() + 64) / 4.74);
    public static final int EVENT_POT_WOBBLES = 1;
    public long wobbleStartedAtTick;
    @Nullable
    public DepthWobbleStyle lastWobbleStyle;
    private NonNullList<ItemStack> items = NonNullList.withSize((int)this.depthToSlotRatio, (Object)ItemStack.EMPTY);
    @Nullable
    protected ResourceKey<LootTable> lootTable;
    protected long lootTableSeed;

    public DepthVaseBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)RisusBlockEntities.DEPTH_VASE.get(), pos, state);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        if (!this.trySaveLootTable(tag)) {
            ContainerHelper.saveAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)registries);
        }
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.items = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        if (!this.tryLoadLootTable(tag)) {
            ContainerHelper.loadAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)registries);
        }
    }

    public int getContainerSize() {
        return this.depthToSlotRatio;
    }

    public boolean isEmpty() {
        this.unpackLootTable(null);
        return this.items.stream().allMatch(ItemStack::isEmpty);
    }

    public ItemStack getItem(int slot) {
        this.unpackLootTable(null);
        return (ItemStack)this.items.get(slot);
    }

    public ItemStack removeItem(int slot, int amount) {
        this.unpackLootTable(null);
        ItemStack itemstack = ContainerHelper.removeItem(this.items, (int)slot, (int)amount);
        if (!itemstack.isEmpty()) {
            this.setChanged();
        }
        return itemstack;
    }

    public ItemStack removeItemNoUpdate(int slot) {
        this.unpackLootTable(null);
        return ContainerHelper.takeItem(this.items, (int)slot);
    }

    public void setItem(int slot, ItemStack stack) {
        this.unpackLootTable(null);
        this.items.set(slot, (Object)stack);
        stack.limitSize(this.getMaxStackSize(stack));
        this.setChanged();
    }

    public boolean stillValid(Player player) {
        return Container.stillValidBlockEntity((BlockEntity)this, (Player)player);
    }

    public void clearContent() {
        this.items.clear();
    }

    public Direction getDirection() {
        return (Direction)this.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
    }

    public void wobble(DepthWobbleStyle style) {
        if (this.getLevel() != null && !this.getLevel().isClientSide()) {
            this.getLevel().blockEvent(this.getBlockPos(), this.getBlockState().getBlock(), 1, style.ordinal());
        }
    }

    public boolean triggerEvent(int id, int type) {
        if (this.getLevel() != null && id == 1 && type >= 0 && type < DepthWobbleStyle.values().length) {
            this.wobbleStartedAtTick = this.getLevel().getGameTime();
            this.lastWobbleStyle = DepthWobbleStyle.values()[type];
            return true;
        }
        return super.triggerEvent(id, type);
    }

    @Nullable
    public ResourceKey<LootTable> getLootTable() {
        return this.lootTable;
    }

    public void setLootTable(@Nullable ResourceKey<LootTable> lootTable) {
        this.lootTable = lootTable;
    }

    public long getLootTableSeed() {
        return this.lootTableSeed;
    }

    public void setLootTableSeed(long seed) {
        this.lootTableSeed = seed;
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput componentInput) {
        super.applyImplicitComponents(componentInput);
        SeededContainerLoot seededcontainerloot = (SeededContainerLoot)componentInput.get(DataComponents.CONTAINER_LOOT);
        if (seededcontainerloot != null) {
            this.lootTable = seededcontainerloot.lootTable();
            this.lootTableSeed = seededcontainerloot.seed();
        }
    }

    protected void collectImplicitComponents(DataComponentMap.Builder components) {
        super.collectImplicitComponents(components);
        if (this.lootTable != null) {
            components.set(DataComponents.CONTAINER_LOOT, (Object)new SeededContainerLoot(this.lootTable, this.lootTableSeed));
        }
    }

    public void removeComponentsFromTag(CompoundTag tag) {
        super.removeComponentsFromTag(tag);
        tag.remove("LootTable");
        tag.remove("LootTableSeed");
    }

    public static enum DepthWobbleStyle {
        POSITIVE(7),
        NEGATIVE(10);

        public final int duration;

        private DepthWobbleStyle(int duration) {
            this.duration = duration;
        }
    }
}

