/*
 * Decompiled with CFR 0.152.
 */
package com.bigdious.risus.blocks.entity;

import com.bigdious.risus.entity.Maw;
import com.bigdious.risus.init.RisusBlockEntities;
import com.bigdious.risus.inventory.MawGutsMenu;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class MawGutsBlockEntity
extends BaseContainerBlockEntity
implements WorldlyContainer {
    private NonNullList<ItemStack> items = NonNullList.withSize((int)54, (Object)ItemStack.EMPTY);
    private int cooldownTime = -1;

    protected NonNullList<ItemStack> getItems() {
        return this.items;
    }

    protected void setItems(NonNullList<ItemStack> pItems) {
        this.items = pItems;
    }

    public MawGutsBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)RisusBlockEntities.MAW_GUTS.get(), pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, MawGutsBlockEntity te) {
        if (!level.hasNeighborSignal(pos) && te.cooldownTime-- <= 0) {
            te.cooldownTime = 0;
            if (MawGutsBlockEntity.suckInItems(level, te)) {
                te.cooldownTime = 10;
            }
        }
    }

    public static boolean suckInItems(Level level, MawGutsBlockEntity te) {
        for (ItemEntity itementity : MawGutsBlockEntity.getItemsAtAndAbove(level, te)) {
            if (!MawGutsBlockEntity.addItem((Container)te, itementity)) continue;
            return true;
        }
        return false;
    }

    public static List<ItemEntity> getItemsAtAndAbove(Level level, MawGutsBlockEntity te) {
        VoxelShape DETECTION_AREA = Block.box((double)-24.0, (double)0.0, (double)-24.0, (double)24.0, (double)48.0, (double)24.0);
        return DETECTION_AREA.toAabbs().stream().flatMap(aabb -> level.getEntitiesOfClass(ItemEntity.class, aabb.move((double)te.getBlockPos().getX() + 0.5, (double)te.getBlockPos().getY() + 1.0, (double)te.getBlockPos().getZ() + 0.5), EntitySelector.ENTITY_STILL_ALIVE).stream()).collect(Collectors.toList());
    }

    public static boolean addItem(Container container, ItemEntity entity) {
        boolean flag = false;
        ItemStack itemstack = entity.getItem().copy();
        ItemStack itemstack1 = MawGutsBlockEntity.addItem(container, itemstack);
        if (itemstack1.isEmpty()) {
            flag = true;
            entity.discard();
        } else {
            entity.setItem(itemstack1);
        }
        return flag;
    }

    public static ItemStack addItem(Container container, ItemStack stack) {
        int i = container.getContainerSize();
        for (int j = 0; j < i && !stack.isEmpty(); ++j) {
            stack = MawGutsBlockEntity.tryMoveInItem(container, stack, j);
        }
        return stack;
    }

    private static ItemStack tryMoveInItem(Container container, ItemStack stack, int slot) {
        ItemStack itemstack = container.getItem(slot);
        if (MawGutsBlockEntity.canPlaceItemInContainer(container, stack, slot)) {
            if (itemstack.isEmpty()) {
                container.setItem(slot, stack);
                stack = ItemStack.EMPTY;
            } else if (MawGutsBlockEntity.canMergeItems(itemstack, stack)) {
                int i = stack.getMaxStackSize() - itemstack.getCount();
                int j = Math.min(stack.getCount(), i);
                stack.shrink(j);
                itemstack.grow(j);
            }
        }
        return stack;
    }

    private static boolean canPlaceItemInContainer(Container container, ItemStack stack, int slot) {
        WorldlyContainer worldly;
        if (!container.canPlaceItem(slot, stack)) {
            return false;
        }
        return !(container instanceof WorldlyContainer) || (worldly = (WorldlyContainer)container).canPlaceItemThroughFace(slot, stack, null);
    }

    private static boolean canMergeItems(ItemStack oldStack, ItemStack newStack) {
        return oldStack.getCount() <= oldStack.getMaxStackSize() && ItemStack.isSameItemSameComponents((ItemStack)oldStack, (ItemStack)newStack);
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.items = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)registries);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        ContainerHelper.saveAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)registries);
    }

    protected Component getDefaultName() {
        return Component.translatable((String)"container.risus.maw_guts");
    }

    protected AbstractContainerMenu createMenu(int id, Inventory inventory) {
        return new MawGutsMenu(id, inventory, (Container)this);
    }

    public int getContainerSize() {
        return this.items.size();
    }

    public boolean isEmpty() {
        return this.items.stream().allMatch(ItemStack::isEmpty);
    }

    public ItemStack getItem(int slot) {
        return (ItemStack)this.items.get(slot);
    }

    public ItemStack removeItem(int slot, int amount) {
        return ContainerHelper.removeItem(this.items, (int)slot, (int)amount);
    }

    public ItemStack removeItemNoUpdate(int slot) {
        return ContainerHelper.takeItem(this.items, (int)slot);
    }

    public void setItem(int slot, ItemStack stack) {
        this.items.set(slot, (Object)stack);
        if (stack.getCount() > this.getMaxStackSize()) {
            stack.setCount(this.getMaxStackSize());
        }
    }

    public boolean stillValid(Player player) {
        return Container.stillValidBlockEntity((BlockEntity)this, (Player)player);
    }

    public void clearContent() {
        this.items.clear();
    }

    public int[] getSlotsForFace(Direction direction) {
        return IntStream.range(0, 54).toArray();
    }

    public boolean canPlaceItemThroughFace(int slot, ItemStack stack, @Nullable Direction direction) {
        return stack.getItem().canFitInsideContainerItems();
    }

    public boolean canTakeItemThroughFace(int slot, ItemStack stack, Direction direction) {
        return true;
    }

    public void killAboveMaw(DamageSource source) {
        List maws = this.getLevel().getEntitiesOfClass(Maw.class, new AABB(this.getBlockPos()).inflate(0.0, 1.0, 0.0));
        if (!maws.isEmpty()) {
            maws.forEach(maw -> maw.hurt(source, Float.MAX_VALUE));
        }
    }
}

