/*
 * Decompiled with CFR 0.152.
 */
package com.bigdious.risus.blocks.entity;

import com.bigdious.risus.client.particle.AlterationParticleOptions;
import com.bigdious.risus.init.RisusBlockEntities;
import com.bigdious.risus.init.RisusBlocks;
import com.bigdious.risus.init.RisusParticles;
import com.bigdious.risus.items.weapons.ScytheItem;
import com.mojang.datafixers.util.Pair;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.block.state.pattern.BlockPattern;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.ticks.ContainerSingleItem;

public class RitualBlockEntity
extends BlockEntity
implements ContainerSingleItem.BlockContainerSingleItem {
    protected ItemStack item = ItemStack.EMPTY;
    private int timer;

    public RitualBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)RisusBlockEntities.RITUAL.get(), pos, blockState);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, RitualBlockEntity entity) {
        if (!ScytheItem.RITUAL_CONVERSIONS.containsKey(level.getBlockState(pos.above()).getBlock())) {
            ItemEntity item = new ItemEntity(level, (double)pos.getX(), (double)(pos.getY() + 1), (double)pos.getZ(), entity.getTheItem());
            level.addFreshEntity((Entity)item);
            level.setBlockAndUpdate(pos, ((LiquidBlock)RisusBlocks.BLOOD_FLUID_BLOCK.get()).defaultBlockState());
            return;
        }
        ++entity.timer;
        if (level.isClientSide()) {
            if (entity.timer < 60) {
                for (i = 0; i < 5; ++i) {
                    RandomSource random = level.getRandom();
                    BlockPos randomPos = pos.offset(Mth.floor((float)(random.nextFloat() * 3.0f * (random.nextBoolean() ? 1.0f : -1.0f))), 2, Mth.floor((float)(random.nextFloat() * 3.0f * (random.nextBoolean() ? 1.0f : -1.0f))));
                    Vec3 vec3 = new Vec3((double)pos.getX() + 0.5, (double)pos.getY() + 3.0, (double)pos.getZ() + 0.5);
                    BlockPos blockpos1 = randomPos.subtract((Vec3i)pos);
                    float f = -0.5f + random.nextFloat() + (float)blockpos1.getX();
                    float f1 = -4.0f + random.nextFloat() + (float)blockpos1.getY();
                    float f2 = -0.5f + random.nextFloat() + (float)blockpos1.getZ();
                    level.addAlwaysVisibleParticle((ParticleOptions)AlterationParticleOptions.ALTERATION_FADE, vec3.x(), vec3.y(), vec3.z(), (double)f, (double)f1, (double)f2);
                }
            } else if (entity.timer > 65) {
                for (i = 0; i < 20; ++i) {
                    level.addAlwaysVisibleParticle((ParticleOptions)RisusParticles.ALTERATION_FINISHED.get(), (double)((float)pos.getX() - 2.0f + level.getRandom().nextFloat() * 4.0f), (double)(pos.getY() + 1), (double)((float)pos.getZ() - 2.0f + level.getRandom().nextFloat() * 4.0f), 0.0, (double)0.1f, 0.0);
                }
            }
        }
        if (entity.timer > 100) {
            BlockState campfire = level.getBlockState(pos.above());
            Pair<Block, ItemLike> resultPair = ScytheItem.RITUAL_CONVERSIONS.get(campfire.getBlock());
            BlockPattern.BlockPatternMatch ritual = ScytheItem.RITUAL.apply((Block)resultPair.getFirst()).find((LevelReader)level, pos);
            if (ritual != null) {
                item = new ItemEntity(level, (double)pos.getX(), (double)(pos.getY() + 1), (double)pos.getZ(), entity.transformAndRemoveEnchants(entity.item, (ItemLike)resultPair.getSecond()));
                level.addFreshEntity((Entity)item);
                level.setBlock(pos.above(), (BlockState)campfire.trySetValue((Property)CampfireBlock.LIT, (Comparable)Boolean.valueOf(false)), 11);
                for (int x = 0; x < ritual.getWidth(); ++x) {
                    for (int y = 0; y < ritual.getHeight(); ++y) {
                        for (int z = 0; z < ritual.getDepth(); ++z) {
                            BlockInWorld worldBlock = ritual.getBlock(x, y, z);
                            if (worldBlock.getState().is(RisusBlocks.CURVED_RITUAL_BLOCK) || worldBlock.getState().is(RisusBlocks.LINEAR_RITUAL_BLOCK)) {
                                level.setBlockAndUpdate(worldBlock.getPos(), ((Block)RisusBlocks.ASHEN_REMAINS.get()).defaultBlockState());
                                level.addDestroyBlockEffect(worldBlock.getPos(), ((Block)RisusBlocks.ASHEN_REMAINS.get()).defaultBlockState());
                                continue;
                            }
                            if (!worldBlock.getState().is(BlockTags.FIRE)) continue;
                            level.removeBlock(worldBlock.getPos(), false);
                        }
                    }
                }
                level.playSound(null, pos, SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS);
                level.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
            } else {
                item = new ItemEntity(level, (double)pos.getX(), (double)(pos.getY() + 1), (double)pos.getZ(), entity.getTheItem());
                level.addFreshEntity((Entity)item);
                level.setBlock(pos.above(), (BlockState)level.getBlockState(pos.above()).trySetValue((Property)CampfireBlock.LIT, (Comparable)Boolean.valueOf(false)), 11);
                level.playSound(null, pos, SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS);
                level.setBlockAndUpdate(pos, ((LiquidBlock)RisusBlocks.BLOOD_FLUID_BLOCK.get()).defaultBlockState());
            }
        }
    }

    private ItemStack transformAndRemoveEnchants(ItemStack transformFrom, ItemLike transformTo) {
        ItemStack newStack = transformFrom.transmuteCopy(transformTo);
        ItemEnchantments.Mutable enchants = new ItemEnchantments.Mutable((ItemEnchantments)newStack.getOrDefault(DataComponents.ENCHANTMENTS, (Object)ItemEnchantments.EMPTY));
        enchants.removeIf(enchant -> !newStack.supportsEnchantment(enchant));
        newStack.set(DataComponents.ENCHANTMENTS, (Object)enchants.toImmutable());
        return newStack;
    }

    public int getTimer() {
        return this.timer;
    }

    public BlockEntity getContainerBlockEntity() {
        return this;
    }

    public ItemStack getTheItem() {
        return this.item;
    }

    public void setTheItem(ItemStack item) {
        this.item = item;
        this.setChanged();
    }
}

