/*
 * Decompiled with CFR 0.152.
 */
package com.bigdious.risus.blocks.interfaces;

import com.bigdious.risus.init.RisusBlocks;
import com.google.common.base.Suppliers;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChangeOverTimeBlock;
import net.minecraft.world.level.block.state.BlockState;

public interface RisusWeatheringCopper
extends ChangeOverTimeBlock<RisusWeatherState> {
    public static final Supplier<BiMap<Block, Block>> NEXT_BY_BLOCK = Suppliers.memoize(() -> ImmutableBiMap.builder().put((Object)((Block)RisusBlocks.COPPER_AMALGAM.get()), (Object)((Block)RisusBlocks.EXPOSED_COPPER_AMALGAM.get())).put((Object)((Block)RisusBlocks.EXPOSED_COPPER_AMALGAM.get()), (Object)((Block)RisusBlocks.WEATHERED_COPPER_AMALGAM.get())).put((Object)((Block)RisusBlocks.WEATHERED_COPPER_AMALGAM.get()), (Object)((Block)RisusBlocks.OXIDIZED_COPPER_AMALGAM.get())).build());

    public static Optional<Block> getNext(Block block) {
        return Optional.ofNullable((Block)NEXT_BY_BLOCK.get().get((Object)block));
    }

    default public Optional<BlockState> getNext(BlockState state) {
        return RisusWeatheringCopper.getNext(state.getBlock()).map(block -> block.withPropertiesOf(state));
    }

    default public float getChanceModifier() {
        return this.getAge() == RisusWeatherState.UNAFFECTED ? 0.75f : 1.0f;
    }

    public static enum RisusWeatherState {
        UNAFFECTED,
        EXPOSED,
        WEATHERED,
        OXIDIZED;

    }
}

