/*
 * Decompiled with CFR 0.152.
 */
package com.bigdious.risus.client.model.entity.player;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.entity.LivingEntity;

public class LeftHandPlayerModel
extends HumanoidModel<LivingEntity> {
    private final ModelPart arm;
    private final ModelPart slimArm;

    public LeftHandPlayerModel(ModelPart root) {
        super(root, RenderType::entityTranslucent);
        this.arm = root.getChild("arm");
        this.slimArm = root.getChild("slim_arm");
    }

    public static LayerDefinition create() {
        MeshDefinition meshdefinition = HumanoidModel.createMesh((CubeDeformation)new CubeDeformation(0.0f), (float)0.0f);
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition arm = partdefinition.addOrReplaceChild("arm", CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.26f)), PartPose.offset((float)-5.0f, (float)-2.0f, (float)0.0f));
        arm.addOrReplaceChild("outer_arm", CubeListBuilder.create().texOffs(16, 0).addBox(-1.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.52f)), PartPose.ZERO);
        PartDefinition slimArm = partdefinition.addOrReplaceChild("slim_arm", CubeListBuilder.create().texOffs(1, 0).addBox(0.0f, 0.0f, -2.0f, 3.0f, 12.0f, 4.0f, new CubeDeformation(0.26f)), PartPose.offset((float)-5.0f, (float)-2.0f, (float)0.0f));
        slimArm.addOrReplaceChild("outer_slim_arm", CubeListBuilder.create().texOffs(17, 0).addBox(0.0f, 0.0f, -2.0f, 3.0f, 12.0f, 4.0f, new CubeDeformation(0.52f)), PartPose.ZERO);
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)16);
    }

    public void setupArmSize(boolean slim) {
        this.arm.visible = !slim;
        this.slimArm.visible = slim;
    }

    public void setupAnim(LivingEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        this.arm.copyFrom(this.leftArm);
        this.slimArm.copyFrom(this.leftArm);
    }

    public void renderToBuffer(PoseStack stack, VertexConsumer consumer, int light, int overlay, int color) {
        this.arm.render(stack, consumer, light, overlay, color);
        this.slimArm.render(stack, consumer, light, overlay, color);
    }
}

