/*
 * Decompiled with CFR 0.152.
 */
package com.bigdious.risus.client.model.entity.player;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;

public class ThreadWingsModel
extends HumanoidModel<LivingEntity> {
    private final ModelPart main;
    private final ModelPart topRightWing;
    private final ModelPart middleRightWing;
    private final ModelPart bottomRightWing;
    private final ModelPart topLeftWing;
    private final ModelPart middleLeftWing;
    private final ModelPart bottomLeftWing;
    private final ModelPart innerRing;

    public ThreadWingsModel(ModelPart root) {
        super(root);
        this.main = root.getChild("main");
        this.innerRing = this.main.getChild("innerRing");
        this.bottomLeftWing = this.main.getChild("bottomLeftWing");
        this.middleLeftWing = this.main.getChild("middleLeftWing");
        this.topLeftWing = this.main.getChild("topLeftWing");
        this.bottomRightWing = this.main.getChild("bottomRightWing");
        this.middleRightWing = this.main.getChild("middleRightWing");
        this.topRightWing = this.main.getChild("topRightWing");
    }

    public static LayerDefinition create() {
        MeshDefinition meshdefinition = HumanoidModel.createMesh((CubeDeformation)CubeDeformation.NONE, (float)0.0f);
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition main = partdefinition.addOrReplaceChild("main", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)4.0f, (float)2.0f));
        PartDefinition innerRing = main.addOrReplaceChild("innerRing", CubeListBuilder.create().texOffs(36, 19).addBox(-4.0f, -1.0f, -5.0f, 8.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(39, 19).addBox(-5.0f, -1.0f, -4.0f, 1.0f, 2.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(36, 21).addBox(4.0f, -1.0f, -4.0f, 1.0f, 2.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(40, 24).addBox(-4.0f, -1.0f, 4.0f, 8.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)7.0f, (float)1.5708f, (float)0.0f, (float)0.7854f));
        PartDefinition bottomLeftWing = main.addOrReplaceChild("bottomLeftWing", CubeListBuilder.create(), PartPose.offsetAndRotation((float)-4.9605f, (float)8.2347f, (float)7.0f, (float)0.0f, (float)0.0f, (float)-1.2654f));
        PartDefinition bottomLeftWing_r1 = bottomLeftWing.addOrReplaceChild("bottomLeftWing_r1", CubeListBuilder.create().texOffs(-8, 13).addBox(-9.0f, 0.0f, -4.0f, 18.0f, 0.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-7.1742f, (float)-6.1262f, (float)0.0f, (float)1.5708f, (float)0.0f, (float)0.6981f));
        PartDefinition middleLeftWing = main.addOrReplaceChild("middleLeftWing", CubeListBuilder.create().texOffs(-13, 0).addBox(-29.5f, 0.0f, -6.5f, 29.0f, 0.0f, 13.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-6.5f, (float)-1.0f, (float)7.5f, (float)1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition topLeftWing = main.addOrReplaceChild("topLeftWing", CubeListBuilder.create(), PartPose.offset((float)-5.0f, (float)-7.0f, (float)7.0f));
        PartDefinition bottomLeftWing_r2 = topLeftWing.addOrReplaceChild("bottomLeftWing_r2", CubeListBuilder.create().texOffs(-8, 13).addBox(-9.0f, 0.0f, -4.0f, 18.0f, 0.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-7.0f, (float)-7.0f, (float)0.0f, (float)1.5708f, (float)0.0f, (float)0.6981f));
        PartDefinition bottomRightWing = main.addOrReplaceChild("bottomRightWing", CubeListBuilder.create(), PartPose.offsetAndRotation((float)4.9605f, (float)8.2347f, (float)7.0f, (float)0.0f, (float)0.0f, (float)1.2654f));
        PartDefinition bottomRightWing_r1 = bottomRightWing.addOrReplaceChild("bottomRightWing_r1", CubeListBuilder.create().texOffs(-8, 13).mirror().addBox(-9.0f, 0.0f, -4.0f, 18.0f, 0.0f, 8.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)7.1742f, (float)-6.1262f, (float)0.0f, (float)1.5708f, (float)0.0f, (float)-0.6981f));
        PartDefinition middleRightWing = main.addOrReplaceChild("middleRightWing", CubeListBuilder.create().texOffs(-13, 0).mirror().addBox(0.5f, 0.0f, -6.5f, 29.0f, 0.0f, 13.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)6.5f, (float)-1.0f, (float)7.5f, (float)1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition topRightWing = main.addOrReplaceChild("topRightWing", CubeListBuilder.create(), PartPose.offset((float)5.5f, (float)-8.0f, (float)7.5f));
        PartDefinition bottomRightWing_r2 = topRightWing.addOrReplaceChild("bottomRightWing_r2", CubeListBuilder.create().texOffs(-8, 13).mirror().addBox(-9.0f, 0.0f, -4.0f, 18.0f, 0.0f, 8.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)6.5f, (float)-6.0f, (float)-0.5f, (float)1.5708f, (float)0.0f, (float)-0.6981f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public void setupAnim(LivingEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float flapping = Mth.sin((float)(ageInTicks * 0.1f)) * 0.1f;
        float circle = ageInTicks * 0.05f;
        this.topRightWing.yRot = flapping + 0.31415927f;
        this.topLeftWing.yRot = -flapping - 0.31415927f;
        this.middleRightWing.yRot = flapping + 0.31415927f;
        this.middleLeftWing.yRot = -flapping - 0.31415927f;
        this.bottomRightWing.yRot = flapping + 0.31415927f;
        this.bottomLeftWing.yRot = -flapping - 0.31415927f;
        this.innerRing.zRot = circle * 0.5f;
        this.innerRing.xRot = -circle * 1.5f;
        this.innerRing.yRot = circle;
    }

    public void renderToBuffer(PoseStack stack, VertexConsumer consumer, int light, int overlay, int color) {
        this.main.render(stack, consumer, light, overlay, color);
    }
}

