/*
 * Decompiled with CFR 0.152.
 */
package com.bigdious.risus.client.particle;

import com.bigdious.risus.init.RisusFluids;
import com.bigdious.risus.init.RisusParticles;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.DripParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.fml.util.ObfuscationReflectionHelper;

public class RisusDripParticle
extends DripParticle {
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
    private static final Field particle_Gravity = ObfuscationReflectionHelper.findField(Particle.class, (String)"gravity");
    private static final MethodHandle handle_particle_Gravity_set;
    private static final MethodHandle handle_particle_Gravity_get;

    public RisusDripParticle(ClientLevel level, double x, double y, double z, Fluid fluid) {
        super(level, x, y, z, fluid);
    }

    public int getLightColor(float partialTicks) {
        return 240;
    }

    static {
        MethodHandle tmp_handle_particle_Gravity_set = null;
        MethodHandle tmp_handle_particle_Gravity_get = null;
        try {
            tmp_handle_particle_Gravity_set = LOOKUP.unreflectSetter(particle_Gravity);
            tmp_handle_particle_Gravity_get = LOOKUP.unreflectGetter(particle_Gravity);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        handle_particle_Gravity_set = tmp_handle_particle_Gravity_set;
        handle_particle_Gravity_get = tmp_handle_particle_Gravity_get;
    }

    public record BloodDripLandProvider(SpriteSet sprite) implements ParticleProvider<SimpleParticleType>
    {
        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xMotion, double yMotion, double zMotion) {
            DripParticle.DripLandParticle dripparticle = new DripParticle.DripLandParticle(level, x, y, z, (Fluid)RisusFluids.SOURCE_BLOOD.get());
            dripparticle.setLifetime((int)(28.0 / (Math.random() * 0.8 + 0.2)));
            dripparticle.setColor(0.51171875f, 0.03125f, 0.890625f);
            dripparticle.pickSprite(this.sprite());
            return dripparticle;
        }
    }

    public record BloodDripHangProvider(SpriteSet sprite) implements ParticleProvider<SimpleParticleType>
    {
        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xMotion, double yMotion, double zMotion) {
            DripParticle.DripHangParticle dripparticle = new DripParticle.DripHangParticle(level, x, y, z, Fluids.EMPTY, (ParticleOptions)RisusParticles.FALLING_BLOOD.get());
            try {
                handle_particle_Gravity_set.invokeExact((Particle)dripparticle, handle_particle_Gravity_get.invokeExact((Particle)dripparticle) * 0.01f);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            dripparticle.setLifetime(100);
            dripparticle.setColor(0.51171875f, 0.03125f, 0.890625f);
            dripparticle.pickSprite(this.sprite());
            return dripparticle;
        }
    }

    public record BloodDripFallProvider(SpriteSet sprite) implements ParticleProvider<SimpleParticleType>
    {
        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xMotion, double yMotion, double zMotion) {
            DripParticle.FallAndLandParticle dripparticle = new DripParticle.FallAndLandParticle(level, x, y, z, Fluids.EMPTY, (ParticleOptions)RisusParticles.LANDING_BLOOD.get());
            try {
                handle_particle_Gravity_set.invokeExact((Particle)dripparticle, 0.01f);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            dripparticle.setColor(0.51171875f, 0.03125f, 0.890625f);
            dripparticle.pickSprite(this.sprite());
            return dripparticle;
        }
    }

    public record JoyLandProvider(SpriteSet sprite) implements ParticleProvider<SimpleParticleType>
    {
        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xMotion, double yMotion, double zMotion) {
            DripParticle.DripLandParticle dripparticle = new DripParticle.DripLandParticle(level, x, y, z, Fluids.EMPTY);
            dripparticle.setLifetime((int)(28.0 / (Math.random() * 0.8 + 0.2)));
            dripparticle.setColor(0.51171875f, 0.03125f, 0.890625f);
            dripparticle.pickSprite(this.sprite());
            return dripparticle;
        }
    }

    public record JoyHangProvider(SpriteSet sprite) implements ParticleProvider<SimpleParticleType>
    {
        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xMotion, double yMotion, double zMotion) {
            DripParticle.DripHangParticle dripparticle = new DripParticle.DripHangParticle(level, x, y, z, Fluids.EMPTY, (ParticleOptions)RisusParticles.FALLING_JOY.get());
            try {
                handle_particle_Gravity_set.invokeExact((Particle)dripparticle, handle_particle_Gravity_get.invokeExact((Particle)dripparticle) * 0.01f);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            dripparticle.setLifetime(100);
            dripparticle.setColor(0.51171875f, 0.03125f, 0.890625f);
            dripparticle.pickSprite(this.sprite());
            return dripparticle;
        }
    }

    public record JoyFallProvider(SpriteSet sprite) implements ParticleProvider<SimpleParticleType>
    {
        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xMotion, double yMotion, double zMotion) {
            DripParticle.FallAndLandParticle dripparticle = new DripParticle.FallAndLandParticle(level, x, y, z, Fluids.EMPTY, (ParticleOptions)RisusParticles.LANDING_JOY.get());
            try {
                handle_particle_Gravity_set.invokeExact((Particle)dripparticle, 0.01f);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            dripparticle.setColor(0.51171875f, 0.03125f, 0.890625f);
            dripparticle.pickSprite(this.sprite());
            return dripparticle;
        }
    }
}

