/*
 * Decompiled with CFR 0.152.
 */
package com.bigdious.risus.compat;

import com.bigdious.risus.Risus;
import com.bigdious.risus.compat.AlterationCategory;
import com.bigdious.risus.init.RisusBlocks;
import com.bigdious.risus.init.RisusRecipes;
import com.bigdious.risus.inventory.recipe.AlterationRecipe;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;

@JeiPlugin
public class JeiCompat
implements IModPlugin {
    public ResourceLocation getPluginUid() {
        return Risus.prefix("jei_plugin");
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new AlterationCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack(RisusBlocks.ALTERATION_CATALYST), new RecipeType[]{AlterationCategory.ALTERATION});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        RecipeManager manager = Objects.requireNonNull(Minecraft.getInstance().level).getRecipeManager();
        List<RecipeHolder<? extends AlterationRecipe>> recipes = JeiCompat.getAllAlterationRecipes(manager);
        registration.addRecipes(AlterationCategory.ALTERATION, recipes.stream().map(RecipeHolder::value).toList());
    }

    public static List<RecipeHolder<? extends AlterationRecipe>> getAllAlterationRecipes(RecipeManager manager) {
        ArrayList<RecipeHolder<? extends AlterationRecipe>> recipes = new ArrayList<RecipeHolder<? extends AlterationRecipe>>(manager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)RisusRecipes.ALTERATION_RECIPE.get()));
        recipes = new ArrayList(recipes);
        recipes.addAll(manager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)RisusRecipes.ALTERATION_RECIPE.get()));
        return recipes;
    }
}

