/*
 * Decompiled with CFR 0.152.
 */
package com.bigdious.risus.config;

import com.bigdious.risus.config.RisusCommonConfig;
import com.bigdious.risus.config.RisusConfig;
import com.bigdious.risus.network.SyncCommonConfigPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.apache.commons.lang3.tuple.Pair;

public class ConfigSetup {
    private static final ModConfigSpec COMMON_SPEC;
    private static final RisusCommonConfig COMMON_CONFIG;

    public static void loadConfigs(ModConfigEvent.Loading event) {
        if (event.getConfig().getSpec() == COMMON_SPEC) {
            RisusConfig.rebakeCommonOptions(COMMON_CONFIG);
        }
    }

    public static void reloadConfigs(ModConfigEvent.Reloading event) {
        if (event.getConfig().getSpec() == COMMON_SPEC) {
            RisusConfig.rebakeCommonOptions(COMMON_CONFIG);
        }
    }

    public static void syncConfigOnLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player;
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null && server.isDedicatedServer() && (player = event.getEntity()) instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SyncCommonConfigPacket(RisusConfig.spinningSource), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    static {
        Pair specPair = new ModConfigSpec.Builder().configure(RisusCommonConfig::new);
        COMMON_SPEC = (ModConfigSpec)specPair.getRight();
        ModLoadingContext.get().getActiveContainer().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)COMMON_SPEC);
        COMMON_CONFIG = (RisusCommonConfig)specPair.getLeft();
    }
}

