/*
 * Decompiled with CFR 0.152.
 */
package com.bigdious.risus.dispenser;

import com.bigdious.risus.init.RisusBlocks;
import com.bigdious.risus.util.ServerParticleUtils;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class WaxingDispenserBehaviour
extends OptionalDispenseItemBehavior {
    private final DispenseItemBehavior vanillaBehavior;
    boolean fired = false;
    public static final Map<Block, Block> WAXINGS = Map.of((Block)RisusBlocks.COPPER_AMALGAM.get(), (Block)RisusBlocks.WAXED_COPPER_AMALGAM.get(), (Block)RisusBlocks.EXPOSED_COPPER_AMALGAM.get(), (Block)RisusBlocks.WAXED_EXPOSED_COPPER_AMALGAM.get(), (Block)RisusBlocks.OXIDIZED_COPPER_AMALGAM.get(), (Block)RisusBlocks.WAXED_OXIDIZED_COPPER_AMALGAM.get(), (Block)RisusBlocks.WEATHERED_COPPER_AMALGAM.get(), (Block)RisusBlocks.WAXED_WEATHERED_COPPER_AMALGAM.get());

    public WaxingDispenserBehaviour(DispenseItemBehavior vanillaBehavior) {
        this.vanillaBehavior = vanillaBehavior;
    }

    protected ItemStack execute(BlockSource source, ItemStack stack) {
        BlockPos pos;
        ServerLevel level = source.level();
        BlockState state = level.getBlockState(pos = source.pos().relative((Direction)source.state().getValue((Property)DispenserBlock.FACING)));
        Block checkingForBlock = state.getBlock();
        if (WAXINGS.containsKey(checkingForBlock)) {
            level.setBlock(pos, WAXINGS.get(checkingForBlock).withPropertiesOf(state), 3);
            ServerParticleUtils.spawnParticlesOnBlockFaces((Level)source.level(), pos, (ParticleOptions)ParticleTypes.WAX_ON, (IntProvider)UniformInt.of((int)6, (int)12));
            stack.shrink(1);
            this.fired = true;
        }
        if (!this.fired) {
            return this.vanillaBehavior.dispense(source, stack);
        }
        return stack;
    }

    protected void playSound(BlockSource source) {
        if (this.fired) {
            super.playSound(source);
            this.fired = false;
        } else {
            source.level().levelEvent(1001, source.pos(), 0);
        }
    }
}

