/*
 * Decompiled with CFR 0.152.
 */
package com.bigdious.risus.effects;

import java.util.Set;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.EffectCure;

public class FlameFrailtyEffect
extends MobEffect {
    public FlameFrailtyEffect(MobEffectCategory category, int color) {
        super(category, color);
    }

    public boolean applyEffectTick(LivingEntity entity, int amplifier) {
        ServerLevel serverLevel;
        ServerLevel serverLevel2;
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (player.hasEffect(MobEffects.FIRE_RESISTANCE)) {
                player.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, 100, 1, false, false, false));
                player.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 100, 2, false, false, false));
                player.removeEffect(MobEffects.FIRE_RESISTANCE);
                player.hurt(entity.damageSources().onFire(), 2.0f);
                Level level = player.level();
                if (level instanceof ServerLevel) {
                    serverLevel2 = (ServerLevel)level;
                    for (int i = 0; i < 4; ++i) {
                        serverLevel2.sendParticles((ParticleOptions)ParticleTypes.FLAME, entity.getRandomX(0.5), entity.getRandomY(), entity.getRandomZ(0.5), 1, 0.0, 0.0, 0.0, 0.0);
                    }
                }
            } else if (player.isOnFire()) {
                player.hurt(entity.damageSources().onFire(), 1.0f);
                player.setRemainingFireTicks(entity.getRemainingFireTicks() + 40);
                Level i = player.level();
                if (i instanceof ServerLevel) {
                    serverLevel2 = (ServerLevel)i;
                    for (int i2 = 0; i2 < 4; ++i2) {
                        serverLevel2.sendParticles((ParticleOptions)ParticleTypes.FLAME, entity.getRandomX(0.5), entity.getRandomY(), entity.getRandomZ(0.5), 1, 0.0, 0.0, 0.0, 0.0);
                    }
                }
            }
        }
        if (entity.getType().fireImmune()) {
            entity.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, 60, 1, false, false, false));
            entity.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 60, 2, false, false, false));
            entity.hurt(entity.damageSources().generic(), 1.0f);
            serverLevel2 = entity.level();
            if (serverLevel2 instanceof ServerLevel) {
                serverLevel = serverLevel2;
                for (int i = 0; i < 4; ++i) {
                    serverLevel.sendParticles((ParticleOptions)ParticleTypes.FLAME, entity.getRandomX(0.5), entity.getRandomY(), entity.getRandomZ(0.5), 1, 0.0, 0.0, 0.0, 0.0);
                }
            }
        }
        if (entity.hasEffect(MobEffects.FIRE_RESISTANCE)) {
            entity.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, 100, 1, false, false, false));
            entity.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 100, 2, false, false, false));
            entity.removeEffect(MobEffects.FIRE_RESISTANCE);
            entity.hurt(entity.damageSources().onFire(), 2.0f);
            Level i = entity.level();
            if (i instanceof ServerLevel) {
                serverLevel = (ServerLevel)i;
                for (int i3 = 0; i3 < 4; ++i3) {
                    serverLevel.sendParticles((ParticleOptions)ParticleTypes.FLAME, entity.getRandomX(0.5), entity.getRandomY(), entity.getRandomZ(0.5), 1, 0.0, 0.0, 0.0, 0.0);
                }
            }
        }
        if (entity.isOnFire()) {
            entity.hurt(entity.damageSources().onFire(), 1.0f);
            entity.setRemainingFireTicks(entity.getRemainingFireTicks() + 30);
            Level i3 = entity.level();
            if (i3 instanceof ServerLevel) {
                serverLevel = (ServerLevel)i3;
                for (int i = 0; i < 4; ++i) {
                    serverLevel.sendParticles((ParticleOptions)ParticleTypes.FLAME, entity.getRandomX(0.5), entity.getRandomY(), entity.getRandomZ(0.5), 1, 0.0, 0.0, 0.0, 0.0);
                }
            }
        }
        return super.applyEffectTick(entity, amplifier);
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return duration % 30 == 0;
    }

    public void fillEffectCures(Set<EffectCure> cures, MobEffectInstance effectInstance) {
        cures.clear();
    }
}

