/*
 * Decompiled with CFR 0.152.
 */
package com.bigdious.risus.effects;

import com.bigdious.risus.init.RisusMobEffects;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;

public class MatingFrenzyEffect
extends MobEffect {
    public MatingFrenzyEffect(MobEffectCategory category, int color) {
        super(category, color);
    }

    public boolean applyEffectTick(LivingEntity entity, int amplifier) {
        if (entity instanceof Animal) {
            Animal animal = (Animal)entity;
            if (animal.isBaby()) {
                animal.removeEffect(RisusMobEffects.MATING_FRENZY);
            }
            if (!animal.isBaby() && animal.canFallInLove()) {
                if (animal.getAge() > 0) {
                    animal.setAge(0);
                    animal.hurt(entity.damageSources().magic(), 2.0f);
                }
                animal.setInLove(null);
            }
        }
        if (entity instanceof Villager) {
            Villager villager = (Villager)entity;
            if (villager.isBaby()) {
                villager.removeEffect(RisusMobEffects.MATING_FRENZY);
            }
            if (!villager.isBaby() && villager.getAge() > 0) {
                villager.hurt(entity.damageSources().magic(), 2.0f);
                villager.setAge(0);
            }
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            entity.removeEffect(RisusMobEffects.MATING_FRENZY);
            player.sendSystemMessage((Component)Component.translatable((String)"effect.risus.mating_frenzy.message").setStyle(Style.EMPTY.withColor(ChatFormatting.DARK_RED)));
        }
        return super.applyEffectTick(entity, amplifier);
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return duration % 20 == 0;
    }
}

