/*
 * Decompiled with CFR 0.152.
 */
package com.bigdious.risus.entity;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import org.jetbrains.annotations.Nullable;

public interface CacheTargetOnClient {
    @Nullable
    default public LivingEntity getActiveAttackTarget(Mob mob) {
        if (!this.hasActiveAttackTarget()) {
            return null;
        }
        if (mob.level().isClientSide()) {
            if (this.getCachedAttackTarget() != null) {
                return this.getCachedAttackTarget();
            }
            Entity entity = mob.level().getEntity(this.getDataTarget());
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                this.setCachedAttackTarget(living);
                return this.getCachedAttackTarget();
            }
            return null;
        }
        return mob.getTarget();
    }

    default public boolean hasActiveAttackTarget() {
        return this.getDataTarget() != 0;
    }

    @Nullable
    public LivingEntity getCachedAttackTarget();

    public void setCachedAttackTarget(@Nullable LivingEntity var1);

    public int getDataTarget();
}

