/*
 * Decompiled with CFR 0.152.
 */
package com.bigdious.risus.entity;

import com.bigdious.risus.Risus;
import com.bigdious.risus.config.RisusConfig;
import com.bigdious.risus.entity.TamableMonster;
import com.bigdious.risus.entity.goals.MonsterFollowOwnerGoal;
import com.bigdious.risus.init.RisusFluids;
import com.bigdious.risus.init.RisusItems;
import com.bigdious.risus.init.RisusSoundEvents;
import com.bigdious.risus.init.RisusTags;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidType;
import org.jetbrains.annotations.Nullable;

public class Holder
extends TamableMonster {
    private static final String TAG_GREED = "GREED";
    boolean isGreed;
    private boolean shouldAvoidEntity;
    @Nullable
    private UUID avoidedEntityUUID;
    @Nullable
    private UUID OwnerUUID;

    public Holder(EntityType<? extends Monster> type, Level level) {
        super(type, level);
        this.xpReward = 0;
    }

    public static AttributeSupplier.Builder attributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 10.0).add(Attributes.MOVEMENT_SPEED, 0.2).add(Attributes.ATTACK_DAMAGE, 1.0);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(6, (Goal)new MonsterFollowOwnerGoal(this, 1.0, 5.0f, 2.0f));
        this.goalSelector.addGoal(4, (Goal)new LookAtPlayerGoal((Mob)this, LivingEntity.class, 64.0f));
        this.goalSelector.addGoal(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.goalSelector.addGoal(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, LivingEntity.class, entity -> this.avoidedEntityUUID != null && Objects.equals(this.avoidedEntityUUID, entity.getUUID()), 8.0f, 1.5, 1.75, entity -> this.shouldAvoidEntity));
        this.goalSelector.addGoal(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(5, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, true, living -> this.getMainHandItem().isEmpty() && !living.getMainHandItem().isEmpty() && (RisusConfig.holdersStealFromMonsters && this.isGreed ? !living.getType().is(RisusTags.Entities.CANT_BE_STOLEN_FROM) : living instanceof Player)));
    }

    public void tick() {
        if (this.tickCount % 40 == 0 && this.getTarget() != null && this.getTarget().getMainHandItem().isEmpty()) {
            this.setTarget(null);
        }
        super.tick();
    }

    public boolean canSwimInFluidType(FluidType type) {
        if (type == RisusFluids.BLOOD_FLUID_TYPE.get()) {
            return false;
        }
        return super.canSwimInFluidType(type);
    }

    @Nullable
    public UUID getOwnerUUID() {
        return this.OwnerUUID;
    }

    private void dropItemStack(ItemStack stack) {
        ItemEntity itementity = new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), stack);
        this.level().addFreshEntity((Entity)itementity);
    }

    public void checkDespawn() {
        if (this.getMainHandItem().isEmpty()) {
            super.checkDespawn();
        }
    }

    public boolean hurt(DamageSource source, float amount) {
        boolean flag = super.hurt(source, amount);
        if (flag && this.hasItemInSlot(EquipmentSlot.MAINHAND) && source.getEntity() instanceof LivingEntity) {
            this.spawnAtLocation(this.getMainHandItem());
            this.setItemSlot(EquipmentSlot.MAINHAND, ItemStack.EMPTY);
            this.shouldAvoidEntity = false;
            this.avoidedEntityUUID = null;
            this.OwnerUUID = null;
            if (this.getAttribute(Attributes.ATTACK_DAMAGE).getModifier(Risus.prefix("holder_friendly")) != null) {
                this.getAttribute(Attributes.ATTACK_DAMAGE).removeModifier(Risus.prefix("holder_friendly"));
            }
            if (this.getAttribute(Attributes.MOVEMENT_SPEED).getModifier(Risus.prefix("holder_friendly_speed")) != null) {
                this.getAttribute(Attributes.MOVEMENT_SPEED).removeModifier(Risus.prefix("holder_friendly_speed"));
            }
        }
        return flag;
    }

    public boolean doHurtTarget(Entity entity) {
        boolean flag = super.doHurtTarget(entity);
        if (flag && entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (this.getMainHandItem().isEmpty() && !living.getMainHandItem().isEmpty() && !this.isDeadOrDying()) {
                this.setItemSlotAndDropWhenKilled(EquipmentSlot.MAINHAND, living.getMainHandItem().split(1));
                entity.level().playSound(null, entity.getOnPos(), (SoundEvent)RisusSoundEvents.CHEEKY_LAUGH.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
                if (this.getMainHandItem().is((Item)RisusItems.ORGANIC_MATTER.get())) {
                    this.shouldAvoidEntity = false;
                    this.getAttribute(Attributes.ATTACK_DAMAGE).addTransientModifier(new AttributeModifier(Risus.prefix("holder_friendly"), -3.0, AttributeModifier.Operation.ADD_VALUE));
                    this.getAttribute(Attributes.MOVEMENT_SPEED).addTransientModifier(new AttributeModifier(Risus.prefix("holder_friendly_speed"), 1.8, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
                    this.OwnerUUID = living.getUUID();
                } else {
                    this.avoidedEntityUUID = living.getUUID();
                    this.shouldAvoidEntity = true;
                }
            }
        }
        return flag;
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putBoolean("AvoidingEntity", this.shouldAvoidEntity);
        if (this.avoidedEntityUUID != null) {
            tag.putUUID("AvoidingUUID", this.avoidedEntityUUID);
        }
        if (this.OwnerUUID != null) {
            tag.putUUID("OwnerUUID", this.OwnerUUID);
        }
        if (this.isGreed) {
            tag.putBoolean(TAG_GREED, true);
        }
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.shouldAvoidEntity = tag.getBoolean("AvoidingEntity");
        if (tag.contains("AvoidingUUID")) {
            this.avoidedEntityUUID = tag.getUUID("AvoidingUUID");
        }
        if (tag.contains("OwnerUUID")) {
            this.OwnerUUID = tag.getUUID("OwnerUUID");
        }
        if (tag.contains(TAG_GREED, 99)) {
            this.isGreed = tag.getBoolean(TAG_GREED);
        }
    }

    public void setCustomName(@javax.annotation.Nullable Component name) {
        super.setCustomName(name);
        if (!this.isGreed && name != null && name.getString().equals(TAG_GREED)) {
            this.isGreed = true;
        }
    }
}

