/*
 * Decompiled with CFR 0.152.
 */
package com.bigdious.risus.entity;

import com.bigdious.risus.init.RisusDamageTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.PushReaction;
import net.neoforged.neoforge.fluids.FluidType;

public class QuestionMark
extends Monster {
    private boolean isTransient;
    private int killTimer;

    public QuestionMark(EntityType<? extends Monster> type, Level level) {
        super(type, level);
    }

    public static AttributeSupplier.Builder attributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 1024.0).add(Attributes.MOVEMENT_SPEED, 0.0).add(Attributes.ATTACK_DAMAGE, 10.0);
    }

    public void aiStep() {
        super.aiStep();
        this.setYRot(0.0f);
        this.yRotO = 0.0f;
        this.setYHeadRot(0.0f);
        this.yHeadRotO = 0.0f;
        this.setYBodyRot(0.0f);
        this.yBodyRotO = 0.0f;
    }

    protected void customServerAiStep() {
        super.customServerAiStep();
        if (this.isTransient && this.getRandom().nextInt(3) > 1) {
            ++this.killTimer;
        }
        if (this.killTimer >= 60) {
            this.discard();
        }
    }

    public void setTransient() {
        this.isTransient = true;
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putBoolean("transient", this.isTransient);
        tag.putShort("timer", (short)this.killTimer);
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.killTimer = tag.getShort("timer");
        this.isTransient = tag.getBoolean("transient");
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)SoundEvents.AMBIENT_CAVE.value();
    }

    public int getAmbientSoundInterval() {
        return 200;
    }

    public boolean isNoGravity() {
        return true;
    }

    public boolean canBeSeenAsEnemy() {
        return false;
    }

    public boolean isPushable() {
        return false;
    }

    public void knockback(double x, double y, double z) {
    }

    public boolean removeWhenFarAway(double dist) {
        return false;
    }

    public boolean attackable() {
        return false;
    }

    public void playerTouch(Player player) {
        if (this.isAlive() && this.hasLineOfSight((Entity)player) && player.hurt(this.damageSources().source(RisusDamageTypes.INEXISTENCE), (float)this.getAttribute(Attributes.ATTACK_DAMAGE).getValue())) {
            this.doAutoAttackOnTouch((LivingEntity)player);
        }
    }

    public boolean hurt(DamageSource source, float amount) {
        return source.is(DamageTypeTags.BYPASSES_INVULNERABILITY) && super.hurt(source, amount);
    }

    protected boolean shouldDespawnInPeaceful() {
        return false;
    }

    public PushReaction getPistonPushReaction() {
        return PushReaction.IGNORE;
    }

    public boolean isPushedByFluid(FluidType type) {
        return false;
    }
}

