/*
 * Decompiled with CFR 0.152.
 */
package com.bigdious.risus.entity;

import com.bigdious.risus.advancement.WitnessWeaverNestTrigger;
import com.bigdious.risus.entity.CacheTargetOnClient;
import com.bigdious.risus.entity.QuestionMark;
import com.bigdious.risus.init.RisusAdvancements;
import com.bigdious.risus.init.RisusBlocks;
import com.bigdious.risus.init.RisusDamageTypes;
import com.bigdious.risus.init.RisusFluids;
import com.bigdious.risus.init.RisusMobEffects;
import com.bigdious.risus.init.RisusTags;
import com.bigdious.risus.util.EntityUtil;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WallClimberNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.fluids.FluidType;
import org.jetbrains.annotations.Nullable;

public class Weaver
extends Monster
implements CacheTargetOnClient {
    private static final EntityDataAccessor<Byte> DATA_FLAGS_ID;
    private static final EntityDataAccessor<Integer> DATA_ID_ATTACK_TARGET;
    @Nullable
    private LivingEntity clientSideCachedAttackTarget;
    public final AnimationState leapAnim = new AnimationState();
    public int memories;

    public Weaver(EntityType<? extends Monster> type, Level level) {
        super(type, level);
        this.xpReward = 5;
    }

    public static AttributeSupplier.Builder attributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 12.0).add(Attributes.MOVEMENT_SPEED, 0.3).add(Attributes.ATTACK_DAMAGE, 2.0);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_ID_ATTACK_TARGET, (Object)0);
        builder.define(DATA_FLAGS_ID, (Object)0);
    }

    public void readAdditionalSaveData(CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        if (pCompound.contains("Memories")) {
            this.memories = pCompound.getInt("Memories");
        }
    }

    public void addAdditionalSaveData(CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        pCompound.putInt("Memories", this.memories);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(3, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f){

            public void start() {
                super.start();
                Weaver.this.level().broadcastEntityEvent((Entity)Weaver.this, (byte)66);
            }
        });
        this.goalSelector.addGoal(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.goalSelector.addGoal(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new WeaverHurtByTargetGoal((PathfinderMob)this).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new WeaverNeastAttackableGoal((Mob)this, LivingEntity.class, true, entity -> !(entity instanceof ArmorStand) && !(entity instanceof QuestionMark) && !entity.getType().is(RisusTags.Entities.OFFSPRING) && !entity.getType().is(RisusTags.Entities.BELOVED)));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Animal.class, true));
    }

    public boolean canSwimInFluidType(FluidType type) {
        if (type == RisusFluids.BLOOD_FLUID_TYPE.get()) {
            return false;
        }
        return super.canSwimInFluidType(type);
    }

    public void aiStep() {
        super.aiStep();
        if (this.memories >= 3 && this.level().getBlockState(this.blockPosition()).is(Blocks.AIR) && this.onGround() && this.level().getEntitiesOfClass(Weaver.class, this.getBoundingBox().inflate(10.0)).size() < 2) {
            this.level().setBlock(this.blockPosition(), ((Block)RisusBlocks.WEAVER_NEST.get()).defaultBlockState(), 3);
            this.kill();
            this.level().getEntities((Entity)null, new AABB(this.getOnPos()).inflate(30.0), entity -> entity instanceof ServerPlayer).forEach(entity -> {
                if (entity instanceof ServerPlayer) {
                    ServerPlayer sp = (ServerPlayer)entity;
                    ((WitnessWeaverNestTrigger)((Object)((Object)RisusAdvancements.WITNESS_WEAVER_NEST.get()))).trigger(sp);
                }
            });
        }
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
        this.playSound(SoundEvents.SPIDER_STEP, 0.15f, 1.0f);
    }

    protected SoundEvent getAmbientSound() {
        return null;
    }

    protected SoundEvent getHurtSound(DamageSource p_33814_) {
        return null;
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pSpawnType, @Nullable SpawnGroupData pSpawnGroupData) {
        pSpawnGroupData = super.finalizeSpawn(pLevel, pDifficulty, pSpawnType, pSpawnGroupData);
        RandomSource randomsource = pLevel.getRandom();
        if (pSpawnGroupData == null) {
            pSpawnGroupData = new WeaverEffectsGroupData();
            if (pLevel.getDifficulty() == Difficulty.HARD && randomsource.nextFloat() < 0.1f * pDifficulty.getSpecialMultiplier()) {
                ((WeaverEffectsGroupData)pSpawnGroupData).setRandomEffect(randomsource);
            }
        }
        if (pSpawnGroupData instanceof WeaverEffectsGroupData) {
            WeaverEffectsGroupData weaverEffectsGroupData = (WeaverEffectsGroupData)pSpawnGroupData;
            Holder<MobEffect> holder = weaverEffectsGroupData.effect;
            if (holder != null) {
                this.addEffect(new MobEffectInstance(holder, -1, 2));
            }
        }
        return pSpawnGroupData;
    }

    public void makeStuckInBlock(BlockState p_33796_, Vec3 p_33797_) {
        if (!p_33796_.is((Block)RisusBlocks.BLOODWEAVE.get())) {
            super.makeStuckInBlock(p_33796_, p_33797_);
        }
    }

    public boolean canAttackType(EntityType<?> type) {
        return super.canAttackType(type) && type != this.getType();
    }

    public boolean doHurtTarget(Entity entity) {
        if (super.doHurtTarget(entity) && entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            Level level = living.level();
            BlockPos pos = living.getOnPos();
            int i = 3;
            if (this.level().getDifficulty() == Difficulty.NORMAL) {
                i = 5;
            } else if (this.level().getDifficulty() == Difficulty.HARD) {
                i = 8;
            }
            living.addEffect(new MobEffectInstance(RisusMobEffects.AMNESIA, i * 20, 0), (Entity)this);
            if (living.isDeadOrDying() && level.getBlockState(pos.above()).is(Blocks.AIR) && level.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING)) {
                ++this.memories;
                level.setBlock(pos.above(), ((Block)RisusBlocks.BLOODWEAVE.get()).defaultBlockState(), 3);
            }
        }
        return EntityUtil.properlyApplyCustomDamageSource((Mob)this, entity, RisusDamageTypes.getEntityDamageSource(this.level(), RisusDamageTypes.MELANCHOLY, (Entity)this, new EntityType[0]), null);
    }

    @Override
    public int getDataTarget() {
        return (Integer)this.getEntityData().get(DATA_ID_ATTACK_TARGET);
    }

    @Override
    @Nullable
    public LivingEntity getCachedAttackTarget() {
        return this.clientSideCachedAttackTarget;
    }

    @Override
    public void setCachedAttackTarget(@Nullable LivingEntity living) {
        this.clientSideCachedAttackTarget = living;
    }

    public void setActiveAttackTarget(int target) {
        this.entityData.set(DATA_ID_ATTACK_TARGET, (Object)target);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> accessor) {
        super.onSyncedDataUpdated(accessor);
        if (DATA_ID_ATTACK_TARGET.equals(accessor)) {
            this.clientSideCachedAttackTarget = null;
        }
    }

    public void handleEntityEvent(byte id) {
        if (id == 4) {
            // empty if block
        }
        if (id == 66) {
            this.leapAnim.start(this.tickCount);
        }
    }

    protected PathNavigation createNavigation(Level level) {
        return new WallClimberNavigation((Mob)this, level);
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            this.setClimbing(this.horizontalCollision);
        }
    }

    public boolean onClimbable() {
        return this.isClimbing();
    }

    public boolean isClimbing() {
        return ((Byte)this.entityData.get(DATA_FLAGS_ID) & 1) != 0;
    }

    public void setClimbing(boolean climbing) {
        byte b0 = (Byte)this.entityData.get(DATA_FLAGS_ID);
        b0 = climbing ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.entityData.set(DATA_FLAGS_ID, (Object)b0);
    }

    static {
        DATA_ID_ATTACK_TARGET = SynchedEntityData.defineId(Weaver.class, (EntityDataSerializer)EntityDataSerializers.INT);
        DATA_FLAGS_ID = SynchedEntityData.defineId(Weaver.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    }

    private static class WeaverHurtByTargetGoal
    extends HurtByTargetGoal {
        public WeaverHurtByTargetGoal(PathfinderMob mob) {
            super(mob, new Class[0]);
        }

        public void start() {
            super.start();
            ((Weaver)this.mob).setActiveAttackTarget(this.targetMob.getId());
        }

        public void stop() {
            super.stop();
            ((Weaver)this.mob).setActiveAttackTarget(0);
        }
    }

    private static class WeaverNeastAttackableGoal
    extends NearestAttackableTargetGoal<LivingEntity> {
        public WeaverNeastAttackableGoal(Mob mob, Class<LivingEntity> attack, boolean needsLOS, Predicate<LivingEntity> predicate) {
            super(mob, attack, needsLOS, predicate);
        }

        public void start() {
            super.start();
            ((Weaver)this.mob).setActiveAttackTarget(this.target.getId());
        }

        public void stop() {
            super.stop();
            ((Weaver)this.mob).setActiveAttackTarget(0);
        }
    }

    public static class WeaverEffectsGroupData
    implements SpawnGroupData {
        @Nullable
        public Holder<MobEffect> effect;

        public void setRandomEffect(RandomSource pRandom) {
            int i = pRandom.nextInt(8);
            if (i <= 1) {
                this.effect = MobEffects.MOVEMENT_SPEED;
            } else if (i == 2) {
                this.effect = MobEffects.DAMAGE_BOOST;
            } else if (i == 3) {
                this.effect = MobEffects.REGENERATION;
            } else if (i == 4) {
                this.effect = MobEffects.JUMP;
            } else if (i == 5) {
                this.effect = MobEffects.DAMAGE_RESISTANCE;
            } else if (i == 6) {
                this.effect = MobEffects.FIRE_RESISTANCE;
            } else if (i == 7) {
                this.effect = MobEffects.INVISIBILITY;
            }
        }
    }
}

