/*
 * Decompiled with CFR 0.152.
 */
package com.bigdious.risus.init;

import com.bigdious.risus.init.RisusParticles;
import com.bigdious.risus.init.RisusSoundEvents;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.level.biome.AmbientParticleSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.neoforged.neoforge.registries.DeferredHolder;

public class RisusBiomes {
    public static final ResourceKey<Biome> COALIFICATION = RisusBiomes.create("coalification");
    public static final ResourceKey<Biome> COALIFICATION_MORK = RisusBiomes.create("coalification_mork");
    public static final ResourceKey<Biome> COALIFICATION_FEIGR = RisusBiomes.create("coalification_feigr");

    private static ResourceKey<Biome> create(String name) {
        return ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"risus", (String)name));
    }

    public static void bootstrap(BootstrapContext<Biome> context) {
        HolderGetter featureGetter = context.lookup(Registries.PLACED_FEATURE);
        HolderGetter carverGetter = context.lookup(Registries.CONFIGURED_CARVER);
        context.register(COALIFICATION, (Object)new Biome.BiomeBuilder().generationSettings(new BiomeGenerationSettings.Builder(featureGetter, carverGetter).build()).mobSpawnSettings(new MobSpawnSettings.Builder().build()).hasPrecipitation(false).downfall(0.0f).temperature(0.8f).specialEffects(RisusBiomes.addMusic(RisusBiomes.generateColors(new BiomeSpecialEffects.Builder(), 6620164, 0x1C1C1C), RisusSoundEvents.MUSIC_DISC_RAK).ambientParticle(new AmbientParticleSettings((ParticleOptions)RisusParticles.RISUS_SOUL_PARTICLE.get(), 1.0E-4f)).build()).build());
        context.register(COALIFICATION_MORK, (Object)new Biome.BiomeBuilder().generationSettings(new BiomeGenerationSettings.Builder(featureGetter, carverGetter).build()).mobSpawnSettings(new MobSpawnSettings.Builder().build()).hasPrecipitation(false).downfall(0.0f).temperature(0.8f).specialEffects(RisusBiomes.addBackgroundLoop(RisusBiomes.generateColors(new BiomeSpecialEffects.Builder(), 6620164, 0x1C1C1C), RisusSoundEvents.AMBIENT_MORK).ambientParticle(new AmbientParticleSettings((ParticleOptions)RisusParticles.RISUS_SOUL_PARTICLE.get(), 1.0E-4f)).build()).build());
        context.register(COALIFICATION_FEIGR, (Object)new Biome.BiomeBuilder().generationSettings(new BiomeGenerationSettings.Builder(featureGetter, carverGetter).build()).mobSpawnSettings(new MobSpawnSettings.Builder().build()).hasPrecipitation(false).downfall(0.0f).temperature(0.8f).specialEffects(RisusBiomes.addBackgroundLoop(RisusBiomes.generateColors(new BiomeSpecialEffects.Builder(), 6620164, 0x1C1C1C), RisusSoundEvents.AMBIENT_FEIGR).ambientParticle(new AmbientParticleSettings((ParticleOptions)RisusParticles.RISUS_SOUL_PARTICLE.get(), 1.0E-4f)).build()).build());
    }

    private static BiomeSpecialEffects.Builder generateColors(BiomeSpecialEffects.Builder builder, int skyFog, int grass) {
        return builder.skyColor(0).fogColor(skyFog).waterColor(526343).waterFogColor(526343).grassColorOverride(grass).foliageColorOverride(grass);
    }

    private static BiomeSpecialEffects.Builder addMusic(BiomeSpecialEffects.Builder builder, DeferredHolder<SoundEvent, SoundEvent> music) {
        return builder.backgroundMusic(new Music(music, 3000, 6000, true));
    }

    private static BiomeSpecialEffects.Builder addBackgroundLoop(BiomeSpecialEffects.Builder builder, DeferredHolder<SoundEvent, SoundEvent> music) {
        return builder.ambientLoopSound(music);
    }
}

