/*
 * Decompiled with CFR 0.152.
 */
package com.bigdious.risus.inventory.recipe;

import com.bigdious.risus.init.RisusBlocks;
import com.bigdious.risus.init.RisusRecipes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public record AlterationRecipe(Ingredient input, ItemStack result) implements Recipe<SingleRecipeInput>
{
    public boolean matches(SingleRecipeInput recipeInput, Level level) {
        return this.input.test(recipeInput.getItem(0));
    }

    public ItemStack assemble(SingleRecipeInput recipeInput, HolderLookup.Provider pRegistries) {
        return this.result.copy();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider pRegistries) {
        return this.result;
    }

    public boolean isSpecial() {
        return true;
    }

    public ItemStack getToastSymbol() {
        return new ItemStack((ItemLike)RisusBlocks.ALTERATION_CATALYST.get());
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)RisusRecipes.ALTERATION_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)RisusRecipes.ALTERATION_RECIPE.get();
    }

    public static class Serializer
    implements RecipeSerializer<AlterationRecipe> {
        public static final MapCodec<AlterationRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC_NONEMPTY.fieldOf("input").forGetter(AlterationRecipe::input), (App)ItemStack.SIMPLE_ITEM_CODEC.fieldOf("result").forGetter(AlterationRecipe::result)).apply((Applicative)instance, AlterationRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, AlterationRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, recipe -> recipe.input, (StreamCodec)ItemStack.STREAM_CODEC, recipe -> recipe.result, AlterationRecipe::new);

        public MapCodec<AlterationRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, AlterationRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

