/*
 * Decompiled with CFR 0.152.
 */
package com.bigdious.risus.items;

import com.bigdious.risus.init.RisusBlocks;
import com.bigdious.risus.init.RisusDataMaps;
import com.bigdious.risus.init.RisusParticles;
import com.bigdious.risus.init.RisusSoundEvents;
import com.bigdious.risus.util.LoverConversion;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.event.EventHooks;

public class LoverCreamItem
extends Item {
    public LoverCreamItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player player, LivingEntity entity, InteractionHand hand) {
        if (entity instanceof Mob) {
            Level level;
            Mob mob = (Mob)entity;
            if (entity.getType().builtInRegistryHolder().getData(RisusDataMaps.LOVER_CONVERSION) != null && (level = entity.level()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                this.tryConvertEntity(serverLevel, ((LoverConversion)mob.getType().builtInRegistryHolder().getData(RisusDataMaps.LOVER_CONVERSION)).result(), mob);
                player.level().playSound(player, player.getOnPos().above(), (SoundEvent)RisusSoundEvents.LOVER_INFECT.get(), SoundSource.PLAYERS, 2.0f, (player.level().random.nextFloat() - player.level().random.nextFloat()) * 0.2f + 1.0f);
                boolean isClient = entity.level().isClientSide();
                if (!isClient) {
                    stack.shrink(1);
                }
                return InteractionResult.sidedSuccess((boolean)isClient);
            }
        }
        return InteractionResult.PASS;
    }

    private <T extends Mob> boolean tryConvertEntity(ServerLevel level, EntityType<T> to, Mob from) {
        boolean flag = true;
        if (EventHooks.canLivingConvert((LivingEntity)from, to, timer -> {})) {
            if (level.getDifficulty() != Difficulty.HARD && level.random.nextBoolean()) {
                return flag;
            }
            Mob offspring = from.convertTo(to, false);
            if (offspring != null) {
                offspring.finalizeSpawn((ServerLevelAccessor)level, level.getCurrentDifficultyAt(offspring.blockPosition()), MobSpawnType.CONVERSION, null);
                EventHooks.onLivingConvert((LivingEntity)from, (LivingEntity)offspring);
                BlockState spreading = (BlockState)((MultifaceBlock)RisusBlocks.SPREADING_REMAINS.get()).defaultBlockState().setValue((Property)MultifaceBlock.getFaceProperty((Direction)Direction.DOWN), (Comparable)Boolean.valueOf(true));
                if (spreading.canSurvive((LevelReader)level, offspring.blockPosition()) && level.getBlockState(offspring.blockPosition()).isAir() && level.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING)) {
                    level.setBlockAndUpdate(offspring.blockPosition(), spreading);
                }
                for (int i = 0; i < 10; ++i) {
                    level.sendParticles((ParticleOptions)ParticleTypes.HEART, from.getRandomX(0.5), from.getRandomY(), from.getRandomZ(0.5), 1, 0.0, 0.0, 0.0, 0.0);
                    level.sendParticles((ParticleOptions)((SimpleParticleType)RisusParticles.RISUS_SOUL_PARTICLE.get()), from.getRandomX(0.5), from.getRandomY(), from.getRandomZ(0.5), 1, 0.0, 0.0, 0.0, 0.0);
                }
                flag = false;
            }
        }
        return flag;
    }

    public SoundEvent getDrinkingSound() {
        return SoundEvents.HONEY_DRINK;
    }

    public SoundEvent getEatingSound() {
        return SoundEvents.HONEY_DRINK;
    }
}

