/*
 * Decompiled with CFR 0.152.
 */
package com.bigdious.risus.items.summoners;

import com.bigdious.risus.entity.GutsBoat;
import com.bigdious.risus.entity.RisusBoat;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class RisusBoatItem
extends Item {
    private final RisusBoat.Type type;
    private final boolean guts;

    public RisusBoatItem(boolean guts, RisusBoat.Type type, Item.Properties properties) {
        super(properties);
        this.guts = guts;
        this.type = type;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        BlockHitResult result = RisusBoatItem.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.ANY);
        if (result.getType() == HitResult.Type.MISS) {
            return InteractionResultHolder.pass((Object)itemstack);
        }
        Vec3 vector3d = player.getViewVector(1.0f);
        List list = level.getEntities((Entity)player, player.getBoundingBox().expandTowards(vector3d.scale(5.0)).inflate(1.0), EntitySelector.NO_SPECTATORS.and(Entity::isPickable));
        if (!list.isEmpty()) {
            Vec3 vector3d1 = player.getEyePosition(1.0f);
            for (Entity entity : list) {
                AABB axisalignedbb = entity.getBoundingBox().inflate((double)entity.getPickRadius());
                if (!axisalignedbb.contains(vector3d1)) continue;
                return InteractionResultHolder.pass((Object)itemstack);
            }
        }
        if (result.getType() == HitResult.Type.BLOCK) {
            RisusBoat boat = this.getBoat(level, (HitResult)result);
            boat.setRisusBoatType(this.type);
            boat.setYRot(player.getYRot());
            if (!level.noCollision((Entity)boat, boat.getBoundingBox())) {
                return InteractionResultHolder.fail((Object)itemstack);
            }
            if (!level.isClientSide()) {
                level.addFreshEntity((Entity)boat);
                level.gameEvent((Entity)player, (Holder)GameEvent.ENTITY_PLACE, result.getLocation());
                itemstack.consume(1, (LivingEntity)player);
            }
            player.awardStat(Stats.ITEM_USED.get((Object)this));
            return InteractionResultHolder.sidedSuccess((Object)itemstack, (boolean)level.isClientSide());
        }
        return InteractionResultHolder.pass((Object)itemstack);
    }

    private RisusBoat getBoat(Level level, HitResult result) {
        return this.guts ? new GutsBoat(level, result.getLocation().x(), result.getLocation().y(), result.getLocation().z) : new RisusBoat(level, result.getLocation().x(), result.getLocation().y(), result.getLocation().z);
    }
}

