/*
 * Decompiled with CFR 0.152.
 */
package com.bay4lly.photochat.client;

import com.bay4lly.photochat.PhotoChat;
import com.bay4lly.photochat.client.ClientImageManager;
import com.bay4lly.photochat.client.FilePathInputScreen;
import com.bay4lly.photochat.client.IAddChild;
import com.bay4lly.photochat.client.ImageScreen;
import com.bay4lly.photochat.network.NetworkHandlerClient;
import com.bay4lly.photochat.util.Localization;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.UUID;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.minecraft.class_1011;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_408;
import net.minecraft.class_4185;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
public class PhotoChatClient
implements ClientModInitializer {
    public static void openFilePathInputScreen(class_310 client) {
        if (client.field_1755 != null) {
            client.method_1507((class_437)new FilePathInputScreen(client.field_1755));
        }
    }

    private void addButtonToScreen(class_437 screen, class_4185 button) {
        if (screen instanceof IAddChild) {
            IAddChild accessor = (IAddChild)screen;
            accessor.publicAddDrawableChild(button);
        } else {
            PhotoChat.LOGGER.warn(Localization.translate("log.screen.no_iaddchild", new Object[0]));
        }
    }

    public void onInitializeClient() {
        NetworkHandlerClient.registerClient();
        this.registerPhotoViewCommand();
        ScreenEvents.AFTER_INIT.register((client, screen, scaledWidth, scaledHeight) -> {
            if (screen instanceof class_408) {
                class_408 chat = (class_408)screen;
                int BUTTON_WIDTH = 150;
                int PADDING = 5;
                int newXPosition = chat.field_22789 - 150 - 5;
                class_4185 photoButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"text.photochat.send_photo"), button -> {
                    if (client.field_1724 != null) {
                        client.method_1507((class_437)new FilePathInputScreen((class_437)chat));
                    }
                }).method_46437(150, 20).method_46433(newXPosition, chat.field_22790 - 25).method_46431();
                this.addButtonToScreen((class_437)chat, photoButton);
            }
        });
        ClientLifecycleEvents.CLIENT_STOPPING.register(client -> {
            ClientImageManager.clear();
            PhotoChat.LOGGER.info(Localization.translate("log.client.cache_cleared", new Object[0]));
        });
    }

    private void registerPhotoViewCommand() {
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> {
            dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"photochat_open").then(ClientCommandManager.argument((String)"imageId", (ArgumentType)StringArgumentType.string()).executes(context -> {
                String imageId = StringArgumentType.getString((CommandContext)context, (String)"imageId");
                class_310 client = class_310.method_1551();
                try {
                    UUID.fromString(imageId);
                }
                catch (IllegalArgumentException e) {
                    client.field_1724.method_7353((class_2561)class_2561.method_43471((String)"photochat.error.invalid_uuid").method_10862(class_2561.method_43471((String)"photochat.error.invalid_uuid").method_10866().method_36139(0xFF0000)), false);
                    PhotoChat.LOGGER.warn(Localization.translate("log.command.invalid_uuid", imageId));
                    return 1;
                }
                class_1011 image = ClientImageManager.getImage(imageId);
                if (image != null) {
                    client.method_1507((class_437)new ImageScreen(image));
                    PhotoChat.LOGGER.info(Localization.translate("log.image.screen_opened", imageId));
                } else {
                    client.field_1724.method_7353((class_2561)class_2561.method_43471((String)"photochat.error.image_not_ready").method_10862(class_2561.method_43471((String)"photochat.error.image_not_ready").method_10866().method_36139(0xFF8800)), false);
                    PhotoChat.LOGGER.warn(Localization.translate("log.image.not_found_in_clientimagemanager", imageId));
                }
                return 1;
            })));
            PhotoChat.LOGGER.info(Localization.translate("log.client.command_registered", new Object[0]));
        });
    }
}

