/*
 * Decompiled with CFR 0.152.
 */
package _3650.builders_inventory.feature.extended_inventory;

import _3650.builders_inventory.BuildersInventory;
import _3650.builders_inventory.feature.extended_inventory.ExtendedInventory;
import _3650.builders_inventory.feature.extended_inventory.ExtendedInventoryPage;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.ArrayBlockingQueue;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2507;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import org.apache.commons.lang3.tuple.Pair;

public class ExtendedInventoryPages {
    private static final String FILE_PREFIX = "inventory-";
    private static final String FILE_SUFFIX = "-page.nbt";
    private static final int CURRENT_VERSION = 1;
    private static final ArrayBlockingQueue<class_2561> PLAYER_MESSAGE_QUEUE = new ArrayBlockingQueue(50);
    private static final ArrayList<ExtendedInventoryPage> PAGES = new ArrayList();
    private static int deleted = 0;
    private static boolean loaded = false;
    private static boolean valid = false;
    private static int timeToSave = 0;
    private static boolean hasChanged = false;

    static void tick(class_310 mc) {
        if (hasChanged && --timeToSave <= 0) {
            ExtendedInventoryPages.save();
        }
        if (!PLAYER_MESSAGE_QUEUE.isEmpty() && mc.field_1724 != null) {
            ArrayList messages = new ArrayList(50);
            PLAYER_MESSAGE_QUEUE.drainTo(messages);
            for (class_2561 msg : messages) {
                mc.field_1724.method_43496(msg);
            }
        }
    }

    public static void setChanged() {
        if (!loaded) {
            ExtendedInventoryPages.load();
        }
        if (!valid) {
            return;
        }
        hasChanged = true;
        timeToSave = 1600;
    }

    public static void load() {
        BuildersInventory.LOGGER.info("Loading Extended Inventory...");
        BuildersInventory.LOGGER.info("Hey Log Readers: LOGS ARE ZERO-INDEXED");
        loaded = true;
        valid = false;
        PAGES.clear();
        ExtendedInventory.PAGE_CONTAINER.reset();
        Path root = FabricLoader.getInstance().getConfigDir().resolve("builders_inventory");
        try {
            if (!Files.isDirectory(root, new LinkOption[0])) {
                Files.createDirectories(root, new FileAttribute[0]);
            }
            String[] filenames = root.toFile().list((dir, name) -> name.startsWith(FILE_PREFIX) && name.endsWith(FILE_SUFFIX));
            int substrStart = FILE_PREFIX.length();
            int substrEnd = FILE_SUFFIX.length();
            int max = -1;
            Int2ObjectOpenHashMap pageMap = new Int2ObjectOpenHashMap(filenames.length);
            for (String name2 : filenames) {
                String idStr = name2.substring(substrStart, name2.length() - substrEnd);
                try {
                    int id = Integer.parseInt(idStr) - 1;
                    Optional<ExtendedInventoryPage> optPage = ExtendedInventoryPages.loadPage(root.resolve(name2), id);
                    if (!optPage.isPresent()) continue;
                    if (id > max) {
                        max = id;
                    }
                    pageMap.put(id, (Object)optPage.get());
                }
                catch (NumberFormatException e) {
                    BuildersInventory.LOGGER.error("Error loading extended inventory page " + idStr + ": Invalid Integer!", (Throwable)e);
                }
            }
            for (int i = 0; i < max + 1; ++i) {
                if (pageMap.containsKey(i)) {
                    PAGES.add((ExtendedInventoryPage)pageMap.get(i));
                    continue;
                }
                BuildersInventory.LOGGER.warn("Could not find extended inventory page {}", (Object)i);
                PAGES.add(ExtendedInventoryPage.INVALID);
            }
            BuildersInventory.LOGGER.info("Loaded {} extended inventory pages...", (Object)PAGES.size());
            valid = true;
            if (PAGES.isEmpty()) {
                ExtendedInventoryPages.create();
            }
            if (Files.isRegularFile(root.resolve("inventory-data.nbt"), new LinkOption[0])) {
                class_2487 tag = class_2507.method_10633((Path)root.resolve("inventory-data.nbt"));
                if (tag == null) {
                    BuildersInventory.LOGGER.error("Error loading extended inventory saved data: Invalid Data!");
                }
                if (tag.method_10573("page", 3)) {
                    int savePage = tag.method_10550("page");
                    if (savePage >= 0 && savePage < PAGES.size()) {
                        ExtendedInventory.PAGE_CONTAINER.setPage(savePage);
                        BuildersInventory.LOGGER.info("Loaded selected page as {}...", (Object)savePage);
                    } else if (savePage >= 0 && PAGES.size() > 0) {
                        int newPage = Math.max(0, PAGES.size() - 1);
                        ExtendedInventory.PAGE_CONTAINER.setPage(newPage);
                        BuildersInventory.LOGGER.warn("Loaded page out of bounds {}, switched to page {}", (Object)savePage, (Object)newPage);
                    } else {
                        BuildersInventory.LOGGER.error("Failed to load invalid selected page {}...", (Object)savePage);
                    }
                }
            }
            BuildersInventory.LOGGER.info("No page selected! Selecting first page...");
            if (ExtendedInventory.getPage() < 0) {
                ExtendedInventory.PAGE_CONTAINER.setPage(0);
            }
        }
        catch (Exception e) {
            BuildersInventory.LOGGER.error("Error loading extended inventory pages!", (Throwable)e);
            class_310 mc = class_310.method_1551();
            mc.field_1724.method_43496((class_2561)class_2561.method_43471((String)"error.builders_inventory.extended_inventory.load_failed").method_27692(class_124.field_1061));
        }
    }

    public static Optional<ExtendedInventoryPage> loadPage(Path path, int id) throws Exception {
        class_2487 tag = class_2507.method_10633((Path)path);
        if (tag == null || !tag.method_10573("items", 9)) {
            BuildersInventory.LOGGER.error("Error loading extended inventory page {} tag {}: Invalid Data!", (Object)id, (Object)tag);
            return Optional.empty();
        }
        class_2499 items = tag.method_10554("items", 10);
        if (items == null || items.isEmpty()) {
            BuildersInventory.LOGGER.error("Error loading extended inventory page {} items {}: Invalid Data!", (Object)id, (Object)items);
            return Optional.empty();
        }
        boolean locked = false;
        if (tag.method_10573("locked", 1)) {
            locked = tag.method_10577("locked");
        }
        String name = "";
        if (tag.method_10573("name", 8)) {
            name = tag.method_10558("name");
        }
        return Optional.of(ExtendedInventoryPage.of(items, locked, name));
    }

    public static void save() {
        BuildersInventory.LOGGER.info("Saving Extended Inventory...");
        BuildersInventory.LOGGER.info("Hey Log Readers: LOGS ARE ZERO-INDEXED");
        timeToSave = 0;
        hasChanged = false;
        if (!loaded) {
            ExtendedInventoryPages.load();
        }
        if (!valid) {
            BuildersInventory.LOGGER.error("Refusing to save pages; pages failed to load!");
            return;
        }
        Path root = FabricLoader.getInstance().getConfigDir().resolve("builders_inventory");
        try {
            if (!Files.isDirectory(root, new LinkOption[0])) {
                Files.createDirectories(root, new FileAttribute[0]);
            }
            ArrayList<Pair> storeFiles = new ArrayList<Pair>(PAGES.size());
            ArrayList<Path> deleteFiles = new ArrayList<Path>();
            for (int i = 0; i < PAGES.size(); ++i) {
                ExtendedInventoryPage page = PAGES.get(i);
                if (!page.valid || !page.resetChanged()) continue;
                storeFiles.add(Pair.of((Object)root.resolve(FILE_PREFIX + (i + 1) + FILE_SUFFIX), (Object)page));
            }
            if (deleted > 0) {
                int deleteMax = PAGES.size() + deleted;
                for (int i = PAGES.size(); i < deleteMax; ++i) {
                    deleteFiles.add(root.resolve(FILE_PREFIX + (i + 1) + FILE_SUFFIX));
                }
                deleted = 0;
            }
            class_156.method_27958().execute(() -> {
                int i;
                int counter = 0;
                int failCounter = 0;
                for (i = 0; i < storeFiles.size(); ++i) {
                    Pair pair = (Pair)storeFiles.get(i);
                    try {
                        ExtendedInventoryPages.savePage((ExtendedInventoryPage)pair.getValue(), (Path)pair.getKey());
                        ++counter;
                        continue;
                    }
                    catch (Exception e) {
                        ++failCounter;
                        BuildersInventory.LOGGER.error("Error saving extended inventory page " + i + "!", (Throwable)e);
                        PLAYER_MESSAGE_QUEUE.add((class_2561)class_2561.method_43469((String)"error.builders_inventory.extended_inventory.save_failed.page", (Object[])new Object[]{i + 1}).method_27692(class_124.field_1061));
                    }
                }
                BuildersInventory.LOGGER.info("Saved {} modified pages!", (Object)counter);
                if (failCounter > 0) {
                    BuildersInventory.LOGGER.error("Also failed to save {} modified pages...", (Object)counter);
                }
                counter = 0;
                failCounter = 0;
                for (i = 0; i < deleteFiles.size(); ++i) {
                    Path path = (Path)deleteFiles.get(i);
                    try {
                        Files.deleteIfExists(path);
                        ++counter;
                        continue;
                    }
                    catch (Exception e) {
                        ++failCounter;
                        BuildersInventory.LOGGER.error("Error deleting extended inventory file " + path.toString() + "!", (Throwable)e);
                        PLAYER_MESSAGE_QUEUE.add((class_2561)class_2561.method_43469((String)"error.builders_inventory.extended_inventory.delete_failed", (Object[])new Object[]{i + 1}).method_27692(class_124.field_1061));
                    }
                }
                BuildersInventory.LOGGER.info("Deleted {} old pages!", (Object)counter);
                if (failCounter > 0) {
                    BuildersInventory.LOGGER.error("Also failed to delete {} old pages...", (Object)counter);
                }
            });
            if (ExtendedInventory.getPage() >= 0) {
                class_2487 tag = new class_2487();
                tag.method_10569("version", 1);
                tag.method_10569("page", ExtendedInventory.getPage());
                class_2507.method_10630((class_2487)tag, (Path)root.resolve("inventory-data.nbt"));
                BuildersInventory.LOGGER.info("Saved extended inventory extra data!");
            }
        }
        catch (Exception e) {
            BuildersInventory.LOGGER.error("Error saving extended inventory pages!", (Throwable)e);
            class_310 mc = class_310.method_1551();
            mc.field_1724.method_43496((class_2561)class_2561.method_43471((String)"error.builders_inventory.extended_inventory.save_failed").method_27692(class_124.field_1061));
        }
    }

    public static void savePage(ExtendedInventoryPage page, Path path) throws Exception {
        class_2487 tag = ExtendedInventoryPages.writeTag(page);
        class_2507.method_10630((class_2487)tag, (Path)path);
    }

    public static class_2487 writeTag(ExtendedInventoryPage page) {
        class_2487 tag = new class_2487();
        tag.method_10569("version", 1);
        tag.method_10566("items", (class_2520)page.createTag());
        tag.method_10556("locked", page.isLocked());
        if (!page.getName().isBlank()) {
            tag.method_10582("name", page.getName());
        }
        return tag;
    }

    public static ExtendedInventoryPage get(int i) {
        if (!loaded) {
            ExtendedInventoryPages.load();
        }
        if (!valid) {
            return ExtendedInventoryPage.INVALID;
        }
        ExtendedInventoryPage page = PAGES.get(i);
        return page != null ? page : ExtendedInventoryPage.INVALID;
    }

    public static ExtendedInventoryPage create() {
        if (!loaded) {
            ExtendedInventoryPages.load();
        }
        if (!valid) {
            return ExtendedInventoryPage.INVALID;
        }
        ExtendedInventoryPage page = new ExtendedInventoryPage();
        page.setChanged();
        page.setLocked(false);
        PAGES.add(page);
        if (deleted > 0) {
            --deleted;
        }
        return page;
    }

    public static ExtendedInventoryPage reset(int n) {
        if (!loaded) {
            BuildersInventory.LOGGER.warn("Resetting page {} before pages were even loaded... I don't think that's meant to happen.", (Object)n);
            ExtendedInventoryPages.load();
        }
        if (!valid) {
            return ExtendedInventoryPage.INVALID;
        }
        if (n >= PAGES.size()) {
            BuildersInventory.LOGGER.error("Tried to reset page {}, but the index was out of bounds!", (Object)n);
            return ExtendedInventoryPage.INVALID;
        }
        ExtendedInventoryPage page = new ExtendedInventoryPage();
        page.setChanged();
        page.setLocked(false);
        PAGES.set(n, page);
        return page;
    }

    public static void delete(int n) {
        if (!loaded) {
            BuildersInventory.LOGGER.warn("Deleting page {} before pages were even loaded... I don't think that's meant to happen.", (Object)n);
            ExtendedInventoryPages.load();
        }
        if (!valid) {
            return;
        }
        if (n > PAGES.size()) {
            BuildersInventory.LOGGER.error("Tried to delete page {}, but the index was out of bounds!", (Object)n);
            return;
        }
        PAGES.remove(n);
        ++deleted;
        if (PAGES.size() <= 0) {
            ExtendedInventoryPages.create();
        }
        for (int i = n; i < PAGES.size(); ++i) {
            PAGES.get(i).setChanged();
        }
        ExtendedInventoryPages.setChanged();
    }

    public static boolean contains(int i) {
        if (!loaded) {
            ExtendedInventoryPages.load();
        }
        if (!valid) {
            return false;
        }
        return i < PAGES.size();
    }

    public static int size() {
        if (!loaded) {
            ExtendedInventoryPages.load();
        }
        if (!valid) {
            return 1;
        }
        return PAGES.size();
    }

    public static boolean isLoaded() {
        return loaded;
    }

    public static boolean isValid() {
        if (!loaded) {
            ExtendedInventoryPages.load();
        }
        return valid;
    }

    public static void rotatePages(int from, int to, int dist) {
        Collections.rotate(PAGES.subList(from, to), dist);
    }
}

