/*
 * Decompiled with CFR 0.152.
 */
package me.khajiitos.morebreedinggenetics.handler;

import me.khajiitos.morebreedinggenetics.item.EmptySyringeItem;
import me.khajiitos.morebreedinggenetics.item.MutationSyringeItem;
import me.khajiitos.morebreedinggenetics.mutation.AbstractMutation;
import me.khajiitos.morebreedinggenetics.mutation.LootMutation;
import me.khajiitos.morebreedinggenetics.mutation.RegenerationMutation;
import me.khajiitos.morebreedinggenetics.mutation.SizeMutation;
import me.khajiitos.morebreedinggenetics.mutation.util.IMutationEntity;
import me.khajiitos.morebreedinggenetics.mutation.util.MutationProfile;
import me.khajiitos.morebreedinggenetics.mutation.util.MutationType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.living.BabyEntitySpawnEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.living.LootingLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class AnimalEvents {
    @SubscribeEvent
    public static void onBabySpawn(BabyEntitySpawnEvent e) {
        if (e.getParentA() instanceof IMutationEntity && e.getParentB() instanceof IMutationEntity && e.getChild() instanceof IMutationEntity) {
            MutationProfile mutationProfileA = ((IMutationEntity)e.getParentA()).moreBreedingGenetics$getMutationProfile();
            MutationProfile mutationProfileB = ((IMutationEntity)e.getParentB()).moreBreedingGenetics$getMutationProfile();
            MutationProfile childMutationProfile = MutationProfile.breed(mutationProfileA, mutationProfileB);
            ((IMutationEntity)e.getChild()).moreBreedingGenetics$setMutationProfile(childMutationProfile);
        }
    }

    @SubscribeEvent
    public static void onEntitySize(EntityEvent.Size e) {
        MutationProfile mutationProfile;
        AbstractMutation mutation;
        if (e.getEntity() instanceof IMutationEntity && (mutation = (mutationProfile = ((IMutationEntity)e.getEntity()).moreBreedingGenetics$getMutationProfile()).getMutation(MutationType.SIZE)) instanceof SizeMutation) {
            int level = ((SizeMutation)mutation).level;
            float scale = 1.0f + (float)(level + 1) * 0.15f;
            e.setNewSize(e.getNewSize().func_220313_a(scale), true);
        }
    }

    @SubscribeEvent
    public static void onLootLevel(LootingLevelEvent e) {
        MutationProfile mutationProfile;
        AbstractMutation lootMutation;
        int lootingAlready = e.getLootingLevel();
        if (e.getEntity() instanceof IMutationEntity && (lootMutation = (mutationProfile = ((IMutationEntity)e.getEntity()).moreBreedingGenetics$getMutationProfile()).getMutation(MutationType.LOOT)) instanceof LootMutation) {
            int level = ((LootMutation)lootMutation).level;
            e.setLootingLevel(lootingAlready + level + 1);
        }
    }

    @SubscribeEvent
    public static void onLivingUpdate(LivingEvent.LivingUpdateEvent e) {
        int rate;
        MutationProfile mutationProfile;
        AbstractMutation regenerationMutation;
        if (e.getEntityLiving() instanceof IMutationEntity && e.getEntityLiving().func_110143_aJ() < e.getEntityLiving().func_110138_aP() && (regenerationMutation = (mutationProfile = ((IMutationEntity)e.getEntityLiving()).moreBreedingGenetics$getMutationProfile()).getMutation(MutationType.REGENERATION)) instanceof RegenerationMutation && e.getEntityLiving().field_70173_aa % (rate = 40 - ((RegenerationMutation)regenerationMutation).level * 8) == 0) {
            e.getEntityLiving().func_70691_i(1.0f);
        }
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent e) {
        ItemStack itemInHand;
        Entity attacker = e.getSource().func_76346_g();
        if (e.getEntityLiving() instanceof IMutationEntity && attacker instanceof ServerPlayerEntity && ((itemInHand = ((ServerPlayerEntity)attacker).func_184614_ca()).func_77973_b() instanceof EmptySyringeItem || itemInHand.func_77973_b() instanceof MutationSyringeItem)) {
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onSpawn(LivingSpawnEvent.CheckSpawn e) {
        if (e.getEntityLiving() instanceof IMutationEntity) {
            MutationProfile mutationProfile = ((IMutationEntity)e.getEntityLiving()).moreBreedingGenetics$getMutationProfile();
            if (e.getEntityLiving().func_70681_au().nextInt(10) == 0) {
                int totalChances = 0;
                for (MutationType mutationType : MutationType.values()) {
                    totalChances += mutationType.rarity.percent;
                }
                int chosenChance = e.getEntityLiving().func_70681_au().nextInt(totalChances);
                int wentThrough = 0;
                for (MutationType mutationType : MutationType.values()) {
                    if (chosenChance <= wentThrough) {
                        mutationProfile.setMutation(mutationType, mutationType.mutationSupplier.get());
                        ((IMutationEntity)e.getEntityLiving()).moreBreedingGenetics$setMutationProfile(mutationProfile);
                        return;
                    }
                    wentThrough += mutationType.rarity.percent;
                }
            }
        }
    }
}

