/*
 * Decompiled with CFR 0.152.
 */
package me.khajiitos.morebreedinggenetics.mixin;

import me.khajiitos.morebreedinggenetics.mutation.AbstractMutation;
import me.khajiitos.morebreedinggenetics.mutation.CarapaceMutation;
import me.khajiitos.morebreedinggenetics.mutation.FishMutation;
import me.khajiitos.morebreedinggenetics.mutation.JumpMutation;
import me.khajiitos.morebreedinggenetics.mutation.LifeMutation;
import me.khajiitos.morebreedinggenetics.mutation.PoisonResistanceMutation;
import me.khajiitos.morebreedinggenetics.mutation.SpeedMutation;
import me.khajiitos.morebreedinggenetics.mutation.StrengthMutation;
import me.khajiitos.morebreedinggenetics.mutation.WingedMutation;
import me.khajiitos.morebreedinggenetics.mutation.util.IMutationEntity;
import me.khajiitos.morebreedinggenetics.mutation.util.MutationProfile;
import me.khajiitos.morebreedinggenetics.mutation.util.MutationType;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.projectile.ArrowEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.Effect;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AnimalEntity.class})
public abstract class AnimalEntityMixin
extends AgeableEntity
implements IMutationEntity {
    @Unique
    private static final DataParameter<MutationProfile> MUTATION_PROFILE = EntityDataManager.func_187226_a(AnimalEntity.class, MutationProfile.SERIALIZER);

    protected AnimalEntityMixin(EntityType<? extends AgeableEntity> p_i48581_1_, World p_i48581_2_) {
        super(p_i48581_1_, p_i48581_2_);
    }

    @Override
    public MutationProfile moreBreedingGenetics$getMutationProfile() {
        return (MutationProfile)this.field_70180_af.func_187225_a(MUTATION_PROFILE);
    }

    @Override
    public void moreBreedingGenetics$setMutationProfile(MutationProfile mutationProfile) {
        this.field_70180_af.func_187227_b(MUTATION_PROFILE, (Object)mutationProfile.copy());
        this.moreBreedingGenetics$updateAttributes();
    }

    public void func_184206_a(DataParameter<?> dataParameter) {
        super.func_184206_a(dataParameter);
        if (dataParameter.equals(MUTATION_PROFILE)) {
            this.func_213323_x_();
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(MUTATION_PROFILE, (Object)new MutationProfile());
    }

    @Override
    public void moreBreedingGenetics$updateAttributes() {
        boolean horse;
        ModifiableAttributeInstance jumpStrength;
        ModifiableAttributeInstance damage;
        ModifiableAttributeInstance movementSpeed;
        ModifiableAttributeInstance armor;
        ModifiableAttributeInstance maxHealth;
        MutationProfile mutationProfile = this.moreBreedingGenetics$getMutationProfile();
        AbstractMutation lifeMutation = mutationProfile.getMutation(MutationType.LIFE);
        AbstractMutation carapaceMutation = mutationProfile.getMutation(MutationType.CARAPACE);
        AbstractMutation speedMutation = mutationProfile.getMutation(MutationType.SPEED);
        AbstractMutation jumpMutation = mutationProfile.getMutation(MutationType.JUMP);
        AbstractMutation strengthMutation = mutationProfile.getMutation(MutationType.STRENGTH);
        if (lifeMutation instanceof LifeMutation && (maxHealth = this.func_110148_a(Attributes.field_233818_a_)) != null) {
            maxHealth.func_188479_b(LifeMutation.HEALTH_MODIFIER_ID);
            double maxHealthDefault = this.func_110138_aP();
            maxHealth.func_233767_b_(new AttributeModifier(LifeMutation.HEALTH_MODIFIER_ID, "Life mutation", (double)(((LifeMutation)lifeMutation).level + 1) * 4.0, AttributeModifier.Operation.ADDITION));
            if ((double)this.func_110143_aJ() >= maxHealthDefault) {
                this.func_70606_j(this.func_110138_aP());
            }
        }
        if (carapaceMutation instanceof CarapaceMutation && (armor = this.func_110148_a(Attributes.field_233826_i_)) != null) {
            armor.func_188479_b(CarapaceMutation.ARMOR_MODIFIER_ID);
            armor.func_233767_b_(new AttributeModifier(CarapaceMutation.ARMOR_MODIFIER_ID, "Carapace mutation", 8.0, AttributeModifier.Operation.ADDITION));
        }
        if (speedMutation instanceof SpeedMutation && (movementSpeed = this.func_110148_a(Attributes.field_233821_d_)) != null) {
            movementSpeed.func_188479_b(SpeedMutation.SPEED_MODIFIER_ID);
            movementSpeed.func_233767_b_(new AttributeModifier(SpeedMutation.SPEED_MODIFIER_ID, "Speed mutation", (double)(((SpeedMutation)speedMutation).level + 1) * 0.075, AttributeModifier.Operation.ADDITION));
        }
        if (strengthMutation instanceof StrengthMutation && (damage = this.func_110148_a(Attributes.field_233823_f_)) != null) {
            damage.func_188479_b(StrengthMutation.DAMAGE_MODIFIER_ID);
            damage.func_233767_b_(new AttributeModifier(StrengthMutation.DAMAGE_MODIFIER_ID, "Strength mutation", (double)(((StrengthMutation)strengthMutation).level + 1) * 4.0, AttributeModifier.Operation.ADDITION));
        }
        if (jumpMutation instanceof JumpMutation && (jumpStrength = this.func_110148_a(Attributes.field_233830_m_)) != null) {
            jumpStrength.func_188479_b(JumpMutation.JUMP_MODIFIER_ID);
            jumpStrength.func_233767_b_(new AttributeModifier(JumpMutation.JUMP_MODIFIER_ID, "Jump mutation", (double)(((JumpMutation)jumpMutation).level + 1) * 0.075, AttributeModifier.Operation.ADDITION));
        }
        if (!(horse = this instanceof AbstractHorseEntity)) {
            this.field_70138_W = jumpMutation instanceof JumpMutation ? 1.0f : 0.6f;
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"addAdditionalSaveData"})
    public void addAdditionalSaveData(CompoundNBT compoundNBT, CallbackInfo ci) {
        MutationProfile mutationProfile = this.moreBreedingGenetics$getMutationProfile();
        if (mutationProfile != null) {
            compoundNBT.func_218657_a("MBGMutationProfile", (INBT)mutationProfile.save());
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"readAdditionalSaveData"})
    public void readAdditionalSaveData(CompoundNBT compoundNBT, CallbackInfo ci) {
        if (compoundNBT.func_150297_b("MBGMutationProfile", 10)) {
            MutationProfile mutationProfile = new MutationProfile();
            mutationProfile.read(compoundNBT.func_74775_l("MBGMutationProfile"));
            this.moreBreedingGenetics$setMutationProfile(mutationProfile);
        }
    }

    public boolean func_70648_aU() {
        return super.func_70648_aU() || this.moreBreedingGenetics$getMutationProfile().getMutation(MutationType.FISH) instanceof FishMutation;
    }

    public boolean func_70644_a(Effect effect) {
        if (effect == Effects.field_204839_B && this.moreBreedingGenetics$getMutationProfile().getMutation(MutationType.WINGED) instanceof WingedMutation) {
            return true;
        }
        return super.func_70644_a(effect);
    }

    public boolean func_180431_b(DamageSource damageSource) {
        if (super.func_180431_b(damageSource)) {
            return true;
        }
        MutationProfile mutationProfile = this.moreBreedingGenetics$getMutationProfile();
        if (damageSource == DamageSource.field_76376_m && this.func_70644_a(Effects.field_76436_u)) {
            return mutationProfile.getMutation(MutationType.POISON_RESISTANCE) instanceof PoisonResistanceMutation;
        }
        return mutationProfile.getMutation(MutationType.CARAPACE) instanceof CarapaceMutation && damageSource.func_76364_f() instanceof ArrowEntity;
    }

    public void func_70030_z() {
        super.func_70030_z();
    }
}

