/*
 * Decompiled with CFR 0.152.
 */
package me.khajiitos.morebreedinggenetics.mutation.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.khajiitos.morebreedinggenetics.mutation.AbstractLeveledMutation;
import me.khajiitos.morebreedinggenetics.mutation.AbstractMutation;
import me.khajiitos.morebreedinggenetics.mutation.ColorMutation;
import me.khajiitos.morebreedinggenetics.mutation.MutationAlphaMutation;
import me.khajiitos.morebreedinggenetics.mutation.util.MutationType;
import me.khajiitos.morebreedinggenetics.util.ColorUtil;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.IDataSerializer;

public class MutationProfile {
    public static final IDataSerializer<MutationProfile> SERIALIZER = new Serializer();
    private final HashMap<MutationType, AbstractMutation> mutations = new HashMap();

    @Nullable
    public AbstractMutation getMutation(MutationType mutationType) {
        return this.mutations.get((Object)mutationType);
    }

    public void setMutation(MutationType mutationType, AbstractMutation mutation) {
        this.mutations.put(mutationType, mutation);
    }

    public void read(CompoundNBT compoundNBT) {
        this.mutations.clear();
        for (MutationType mutationType : MutationType.values()) {
            if (!compoundNBT.func_74764_b(mutationType.nbtName)) continue;
            AbstractMutation mutation = mutationType.mutationSupplier.get();
            mutation.read(compoundNBT.func_74781_a(mutationType.nbtName));
            this.mutations.put(mutationType, mutation);
        }
    }

    public CompoundNBT save() {
        CompoundNBT compoundNBT = new CompoundNBT();
        this.mutations.forEach((mutationType, mutation) -> compoundNBT.func_218657_a(mutationType.nbtName, mutation.save()));
        return compoundNBT;
    }

    public MutationProfile copy() {
        MutationProfile mutationProfile = new MutationProfile();
        mutationProfile.read(this.save());
        return mutationProfile;
    }

    private static void transferFromParent(Random random, MutationProfile child, MutationProfile parent) {
        boolean parentHasMutationAlpha = parent.getMutation(MutationType.MUTATION_ALPHA) instanceof MutationAlphaMutation;
        parent.mutations.forEach((mutationType, mutation) -> {
            AbstractMutation childMutation = child.getMutation((MutationType)((Object)mutationType));
            if (mutation instanceof AbstractLeveledMutation) {
                AbstractLeveledMutation leveledMutation = childMutation instanceof AbstractLeveledMutation ? (AbstractLeveledMutation)childMutation : (AbstractLeveledMutation)mutationType.mutationSupplier.get();
                int deltaLevels = ((AbstractLeveledMutation)mutation).level - leveledMutation.level;
                for (int i = 0; i < deltaLevels; ++i) {
                    if (random.nextInt(100) >= (parentHasMutationAlpha ? 99 : 90)) continue;
                    leveledMutation.upgrade();
                }
                child.mutations.put((MutationType)((Object)mutationType), leveledMutation);
            } else if (mutationType == MutationType.COLOR && childMutation instanceof ColorMutation && mutation instanceof ColorMutation) {
                int color1 = ((ColorMutation)childMutation).color;
                int color2 = ((ColorMutation)mutation).color;
                ((ColorMutation)childMutation).color = ColorUtil.merge(color1, color2);
            } else if (random.nextInt(100) < (parentHasMutationAlpha ? 99 : 90)) {
                child.mutations.put((MutationType)((Object)mutationType), mutation.copy((MutationType)((Object)mutationType)));
            }
        });
    }

    public static MutationProfile breed(MutationProfile first, MutationProfile second) {
        Random random = new Random();
        MutationProfile babyMutationProfile = new MutationProfile();
        MutationProfile.transferFromParent(random, babyMutationProfile, first);
        MutationProfile.transferFromParent(random, babyMutationProfile, second);
        ArrayList<MutationType> availableMutations = new ArrayList<MutationType>();
        for (MutationType mutationType : MutationType.values()) {
            AbstractMutation mutation = babyMutationProfile.getMutation(mutationType);
            if (mutation != null && (!(mutation instanceof AbstractLeveledMutation) || !((AbstractLeveledMutation)mutation).canBeUpgraded())) continue;
            availableMutations.add(mutationType);
        }
        Collections.shuffle(availableMutations, random);
        int mutationsAdded = 0;
        for (MutationType mutationType : availableMutations) {
            if (random.nextInt(100) >= mutationType.rarity.percent) continue;
            AbstractMutation mutation = babyMutationProfile.getMutation(mutationType);
            if (mutation instanceof AbstractLeveledMutation) {
                ((AbstractLeveledMutation)mutation).upgrade();
            } else {
                babyMutationProfile.mutations.put(mutationType, mutationType.mutationSupplier.get());
            }
            if (++mutationsAdded != 3) continue;
            break;
        }
        return babyMutationProfile;
    }

    private static class Serializer
    implements IDataSerializer<MutationProfile> {
        private Serializer() {
        }

        public void write(PacketBuffer packetBuffer, @Nonnull MutationProfile mutationProfile) {
            CompoundNBT compoundNBT = mutationProfile.save();
            packetBuffer.func_150786_a(compoundNBT);
        }

        @Nonnull
        public MutationProfile read(PacketBuffer packetBuffer) {
            CompoundNBT nbt = packetBuffer.func_150793_b();
            MutationProfile mutationProfile = new MutationProfile();
            mutationProfile.read(nbt);
            return mutationProfile;
        }

        @Nonnull
        public MutationProfile copy(@Nonnull MutationProfile mutationProfile) {
            CompoundNBT nbt = mutationProfile.save();
            MutationProfile anotherMutationProfile = new MutationProfile();
            anotherMutationProfile.read(nbt);
            return anotherMutationProfile;
        }
    }
}

