/*
 * Decompiled with CFR 0.152.
 */
package sheridan.gunscraft;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import sheridan.gunscraft.Clients;
import sheridan.gunscraft.events.ReloadingHandler;
import sheridan.gunscraft.items.guns.IGenericGun;
import sheridan.gunscraft.items.guns.utils.ChamberTaskHandler;
import sheridan.gunscraft.render.utils.Quaternions;

public class ClientGlobalWeaponTranslator {
    private static final float EQUIP_HEIGHT = -1.75f;
    public static ClientGlobalWeaponTranslator INSTANCE;
    public float particleTick = 0.0f;
    public float equipProgress = 0.0f;
    private long lastTick = 0L;
    private float yInc = 0.0f;
    private float yIncO = 0.0f;
    private float ya = 0.0f;
    private float yJump = 0.0f;
    private float yao = 0.0f;
    private float xa = 0.0f;
    public float swingRy;
    public float swingRx;
    private long timer = System.currentTimeMillis();
    private boolean sprintingTransRight = false;
    private boolean sprintingTransLeft = false;
    private float sprintingProgressRight = 0.0f;
    private float sprintingProgressLeft = 0.0f;
    private float sprintingTransDelayRight = 0.0f;
    private float sprintingTransDelayLeft = 0.0f;
    private static final float[] pistolSprintingTrans;
    private static final float[] pistolSprintingRot;
    private static final float[] rifleSprintingTrans;
    private static final float[] rifleSprintingRot;
    private static final float PI = (float)Math.PI;
    float walkDis;
    float swing;
    boolean isPistol;
    private float randomProgressMain = 0.0f;
    private float randomProgressOff = 0.0f;
    private float tempAimingProgress = 0.0f;
    private float tempSprintingProgressRight = 0.0f;

    public void disableSprintingTrans(float time) {
        this.disableSprintingTrans(time, true);
        this.disableSprintingTrans(time, false);
    }

    public float getSprintingProgress(boolean mainHand) {
        return mainHand ? this.sprintingProgressRight : this.sprintingProgressLeft;
    }

    public boolean getSprintingTrans(boolean mainHand) {
        return mainHand ? this.sprintingTransRight : this.sprintingTransLeft;
    }

    public float getEquipProgress() {
        return this.equipProgress;
    }

    public void disableSprintingTrans(float time, boolean mainHand) {
        if (mainHand) {
            this.sprintingTransRight = false;
            this.sprintingProgressRight = 0.0f;
            this.sprintingTransDelayRight = time;
            this.tempSprintingProgressRight = 0.0f;
            this.tempAimingProgress = 0.0f;
        } else {
            this.sprintingTransLeft = false;
            this.sprintingProgressLeft = 0.0f;
            this.sprintingTransDelayLeft = time;
        }
    }

    public void handleTransform(PoseStack poseStack, IGenericGun gun, boolean mainHand) {
        float mx;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        if (Minecraft.m_91087_().m_91288_() != player) {
            return;
        }
        this.walkDis = player.f_19787_ - player.f_19867_;
        this.swing = -(player.f_19787_ + this.walkDis * this.particleTick) * (float)Math.PI;
        float bob = Mth.m_14179_((float)this.particleTick, (float)player.f_36099_, (float)player.f_36100_);
        float bobRY = Mth.m_14189_((float)this.particleTick, (float)player.f_108587_, (float)player.f_108585_);
        float headRY = Mth.m_14189_((float)this.particleTick, (float)player.f_20886_, (float)player.f_20885_);
        this.swingRy = (headRY - bobRY) * 0.2f;
        float bobRX = Mth.m_14189_((float)this.particleTick, (float)player.f_108588_, (float)player.f_108586_);
        float headRX = Mth.m_14189_((float)this.particleTick, (float)player.f_19860_, (float)player.m_146909_());
        this.swingRx = (headRX - bobRX) * 0.2f;
        float sprintingFactor = player.m_20142_() ? 1.3f : 1.0f;
        float aimingFactor = Clients.mainHandStatus.aiming.get() ? Math.min(1.0f, 1.0f - Clients.mainHandStatus.getLerpAimingProgress() + 0.15f) : 1.0f;
        float scaleFactor = aimingFactor * 0.5f;
        if (!gun.canHoldInOneHand() && this.sprintingProgressRight > 0.5f) {
            scaleFactor *= this.sprintingProgressRight - 0.5f + 1.0f;
        }
        float rx = gun.isPistol() ? 21.0f : 15.0f;
        float f = mx = gun.isPistol() ? 0.75f : 0.5f;
        if (mainHand) {
            if (this.equipProgress != 0.0f) {
                this.disableSprintingTrans(1.0f, true);
            }
            if (this.sprintingProgressRight > 0.0f) {
                this.applySprintingTrans(this.sprintingProgressRight, poseStack, gun);
            }
        } else {
            if (this.equipProgress != 0.0f) {
                this.disableSprintingTrans(1.0f, true);
            }
            if (this.sprintingProgressLeft > 0.0f) {
                this.applySprintingTrans(this.sprintingProgressLeft, poseStack, gun);
            }
        }
        poseStack.m_252781_(Quaternions.rotateDeg(-(Math.abs(Mth.m_14089_((float)(this.swing - 0.07225663f)) * bob) * rx * scaleFactor), -Mth.m_14031_((float)this.swing) * bob * scaleFactor * 10.0f, -this.swingRy * scaleFactor));
        this.isPistol = gun.isPistol() || gun.canHoldInOneHand();
        poseStack.m_252880_(0.0f, -0.52f - bob * scaleFactor * 0.2f, -0.72f + bob * scaleFactor);
        this.handleRandomMove(mainHand, poseStack, scaleFactor);
        poseStack.m_252781_(Quaternions.rotateDeg(Mth.m_14036_((float)-2.0f, (float)(-this.swingRx * scaleFactor - this.ya * scaleFactor), (float)2.0f), Mth.m_14036_((float)-2.0f, (float)(-this.swingRy * scaleFactor), (float)2.0f), Mth.m_14036_((float)-2.5f, (float)(this.xa * scaleFactor), (float)2.5f)));
        if (mainHand) {
            poseStack.m_252880_(0.56f, 0.0f, 0.0f);
        } else {
            poseStack.m_252880_(-0.56f, 0.0f, 0.0f);
        }
        poseStack.m_252781_(Quaternions.rotateDeg(0.0f, 0.0f, -(Mth.m_14031_((float)this.swing) * bob * scaleFactor * 10.0f)));
        poseStack.m_252880_(0.0f, -1.75f * this.equipProgress - this.yJump * 0.01f, 0.0f);
        poseStack.m_252880_(Mth.m_14031_((float)(this.swing - 0.07225663f)) * bob * 0.12f * scaleFactor, Math.abs(Mth.m_14089_((float)this.swing) * bob) * mx * scaleFactor * sprintingFactor, 0.0f);
    }

    private void handleRandomMove(boolean mainHand, PoseStack poseStack, float scaleFactor) {
        long now = System.currentTimeMillis();
        float timeDis = (float)(now - this.timer) * 0.001f;
        float progress = mainHand ? this.randomProgressMain : this.randomProgressOff;
        float pitch = Mth.m_14031_((float)(progress + 1.5707964f)) * 0.6f;
        float yaw = Mth.m_14031_((float)progress) * 0.6f;
        float roll = Mth.m_14031_((float)progress) * 0.6f;
        if (!mainHand) {
            yaw *= -1.0f;
        }
        poseStack.m_252781_(Quaternions.rotateDeg(pitch * scaleFactor, yaw * scaleFactor, roll * scaleFactor));
        if (mainHand) {
            this.randomProgressMain += timeDis;
        } else {
            this.randomProgressOff += timeDis;
        }
        if (mainHand) {
            if (this.randomProgressMain >= (float)Math.PI * 2) {
                this.randomProgressMain = 0.0f;
            }
        } else if (this.randomProgressOff >= (float)Math.PI * 2) {
            this.randomProgressOff = 0.0f;
        }
        this.timer = now;
    }

    private void applySprintingTrans(float sprintingProgress, PoseStack poseStack, IGenericGun gun) {
        boolean pistolTrans = gun.isPistol() || gun.canHoldInOneHand();
        float[] rotate = pistolTrans ? pistolSprintingRot : rifleSprintingRot;
        float[] trans = pistolTrans ? pistolSprintingTrans : rifleSprintingTrans;
        float progress = Mth.m_14031_((float)(sprintingProgress * (float)Math.PI * 0.5f));
        progress *= progress;
        poseStack.m_252880_(Mth.m_14179_((float)progress, (float)0.0f, (float)trans[0]), Mth.m_14179_((float)progress, (float)0.0f, (float)trans[1]), Mth.m_14179_((float)progress, (float)0.0f, (float)trans[2]));
        poseStack.m_252781_(Quaternions.rotateDeg(Mth.m_14179_((float)progress, (float)0.0f, (float)rotate[0]), Mth.m_14179_((float)progress, (float)0.0f, (float)rotate[1]), Mth.m_14179_((float)progress, (float)0.0f, (float)rotate[2])));
    }

    public void update(Player player, float particleTick, float equipProgress) {
        if (this.lastTick == 0L) {
            this.lastTick = System.currentTimeMillis();
            return;
        }
        this.particleTick = particleTick;
        this.equipProgress = equipProgress;
        float timeDis = (float)(System.currentTimeMillis() - this.lastTick) * 0.001f;
        this.yInc = (float)(player.m_20186_() - player.f_19855_);
        this.ya = Mth.m_14036_((float)-1.5f, (float)(Mth.m_14179_((float)particleTick, (float)this.yInc, (float)this.yIncO) * 2.0f), (float)1.5f);
        this.yJump = Mth.m_14036_((float)-1.5f, (float)Mth.m_14179_((float)particleTick, (float)this.ya, (float)this.yao), (float)1.5f);
        this.yao = this.ya;
        this.yIncO = this.yInc;
        boolean shouldApplySprinting = player.m_20142_() && !ReloadingHandler.INSTANCE.isReloading() && !Clients.mainHandStatus.aiming.get() && ChamberTaskHandler.INSTANCE.task == null && !player.m_150110_().f_35935_;
        this.sprintingTransRight = shouldApplySprinting && this.sprintingTransDelayRight <= 0.0f;
        boolean bl = this.sprintingTransLeft = shouldApplySprinting && this.sprintingTransDelayLeft <= 0.0f;
        if (this.sprintingTransRight) {
            this.sprintingProgressRight = Math.min(this.sprintingProgressRight + 4.0f * timeDis, 1.0f);
        } else if (Clients.mainHandStatus.aiming.get()) {
            if (this.tempSprintingProgressRight == -1.0f) {
                this.tempSprintingProgressRight = this.sprintingProgressRight;
            }
            float aimingProgress = Clients.mainHandStatus.aimingProgress;
            float progress = Mth.m_14179_((float)particleTick, (float)this.tempAimingProgress, (float)aimingProgress);
            this.sprintingProgressRight = Mth.m_14179_((float)progress, (float)this.tempSprintingProgressRight, (float)0.0f);
            this.tempAimingProgress = aimingProgress;
        } else {
            this.tempAimingProgress = 0.0f;
            this.tempSprintingProgressRight = -1.0f;
            this.sprintingProgressRight = Math.max(this.sprintingProgressRight - 7.0f * timeDis, 0.0f);
        }
        this.sprintingProgressLeft = this.sprintingTransLeft ? Math.min(this.sprintingProgressLeft + 4.5f * timeDis, 1.0f) : Math.max(this.sprintingProgressLeft - 7.0f * timeDis, 0.0f);
        if (this.sprintingTransDelayRight > 0.0f) {
            this.sprintingTransDelayRight = Math.max(0.0f, this.sprintingTransDelayRight - timeDis);
        }
        if (this.sprintingTransDelayLeft > 0.0f) {
            this.sprintingTransDelayLeft = Math.max(0.0f, this.sprintingTransDelayLeft - timeDis);
        }
        this.lastTick = System.currentTimeMillis();
    }

    public void clear() {
        this.lastTick = 0L;
        this.sprintingProgressRight = 0.0f;
        this.sprintingTransRight = false;
        this.disableSprintingTrans(0.0f);
    }

    static {
        pistolSprintingTrans = new float[]{0.0f, -0.02f, -0.1f};
        pistolSprintingRot = new float[]{-9.0f, 0.0f, 0.0f};
        rifleSprintingTrans = new float[]{0.24f, -0.125f, 0.12f};
        rifleSprintingRot = new float[]{-8.6f, 20.5f, 4.4f};
        INSTANCE = new ClientGlobalWeaponTranslator();
    }
}

