/*
 * Decompiled with CFR 0.152.
 */
package sheridan.gunscraft;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import sheridan.gunscraft.events.RenderEvents;
import sheridan.gunscraft.items.attachments.util.newSys.AttachmentRegistry;
import sheridan.gunscraft.items.attachments.util.newSys.AttachmentsHandler;
import sheridan.gunscraft.items.attachments.util.newSys.IAttachment;
import sheridan.gunscraft.items.guns.BoltActionGun;
import sheridan.gunscraft.items.guns.IGenericGun;

@OnlyIn(value=Dist.CLIENT)
public class ClientWeaponStatus {
    public AtomicBoolean buttonDown = new AtomicBoolean(false);
    public AtomicBoolean holdingGun = new AtomicBoolean(false);
    public AtomicInteger shootDelay = new AtomicInteger(1);
    public AtomicBoolean shouldHandle = new AtomicBoolean(true);
    public ItemStack stack = null;
    public float[] aimingTrans;
    public AtomicBoolean aiming = new AtomicBoolean(false);
    public float aimingSpeed = 0.1f;
    public float aimingProgress = 0.0f;
    private float aimingProgressOld = 0.0f;
    public boolean dryFired = false;
    public long lastInspect = 0L;
    public int fireCount = 0;
    public volatile long lastShoot;
    public volatile long lastChamber;
    public boolean hand;
    public boolean isPistol;
    public float moveSpreadFactor;
    public float sprintingSpreadFactor;
    public AttachmentsManager attachmentsManager;

    public float getLerpAimingProgress() {
        float progress = Mth.m_14179_((float)RenderEvents.delta, (float)this.aimingProgressOld, (float)this.aimingProgress);
        return (float)Math.pow(progress, 0.5);
    }

    public ClientWeaponStatus(boolean hand) {
        this.hand = hand;
        this.attachmentsManager = new AttachmentsManager(hand);
    }

    public void handleAiming(float timeDis) {
        if (this.hand) {
            Item item;
            this.aimingProgressOld = this.aimingProgress;
            boolean notStop = true;
            if (this.stack != null && (item = this.stack.m_41720_()) instanceof BoltActionGun) {
                BoltActionGun boltActionGun = (BoltActionGun)item;
                notStop = boltActionGun.shouldHandleAiming(this.stack);
            }
            this.aimingProgress = this.aiming.get() && notStop ? Math.min(this.aimingProgress + this.aimingSpeed * timeDis, 1.0f) : Math.max(this.aimingProgress - this.aimingSpeed * 2.0f * timeDis, 0.0f);
        }
    }

    public static class AttachmentsManager {
        public boolean mainHand;
        public Map<String, IAttachment> slotNameToAttachment;

        public AttachmentsManager(boolean mainHand) {
            this.mainHand = mainHand;
            this.slotNameToAttachment = new ConcurrentHashMap<String, IAttachment>();
        }

        public List<IAttachment> getByFilter(AttachmentsHandler.Filter filter) {
            ArrayList<IAttachment> list = new ArrayList<IAttachment>();
            for (IAttachment attachment : this.slotNameToAttachment.values()) {
                if (!filter.pass(attachment)) continue;
                list.add(attachment);
            }
            return list;
        }

        public IAttachment getSight() {
            return this.getBySlotName("SIGHT");
        }

        public IAttachment getBySlotName(String slotName) {
            return this.slotNameToAttachment.get(slotName);
        }

        public List<IAttachment> getByType(Set<String> types) {
            ArrayList<IAttachment> list = new ArrayList<IAttachment>();
            for (IAttachment attachment : this.slotNameToAttachment.values()) {
                if (!types.contains(attachment.getType())) continue;
                list.add(attachment);
            }
            return list;
        }

        public void clearAndUpdate(ItemStack stack, IGenericGun gun) {
            this.clear();
            this.update(stack, gun);
        }

        public void update(ItemStack stack, IGenericGun gun) {
            CompoundTag tag = AttachmentsHandler.INSTANCE.checkAndGet(stack);
            if (tag != null && tag.m_128441_("occupied_slots")) {
                ListTag occupiedSlots = tag.m_128437_("occupied_slots", 10);
                for (Tag slot : occupiedSlots) {
                    CompoundTag slotTag = (CompoundTag)slot;
                    IAttachment attachment = AttachmentRegistry.get(slotTag.m_128461_("attachment_id"));
                    if (attachment == null) continue;
                    this.slotNameToAttachment.put(slotTag.m_128461_("slot_name"), attachment);
                }
            }
        }

        public void clear() {
            this.slotNameToAttachment.clear();
        }
    }
}

