/*
 * Decompiled with CFR 0.152.
 */
package sheridan.gunscraft;

import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import sheridan.gunscraft.Clients;
import sheridan.gunscraft.Commons;
import sheridan.gunscraft.blocks.ModBlocks;
import sheridan.gunscraft.capability.PlayerStatusEvents;
import sheridan.gunscraft.capability.PlayerStatusProvider;
import sheridan.gunscraft.config.ClientConfig;
import sheridan.gunscraft.config.CommonConfig;
import sheridan.gunscraft.container.ModContainers;
import sheridan.gunscraft.data.GunPropertiesHandler;
import sheridan.gunscraft.data.GunPropertiesProvider;
import sheridan.gunscraft.data.VendingMachineProductsHandler;
import sheridan.gunscraft.data.VendingMachineProductsProvider;
import sheridan.gunscraft.entities.EntityRegister;
import sheridan.gunscraft.events.ClientTickEvents;
import sheridan.gunscraft.events.ControllerEvents;
import sheridan.gunscraft.events.DebugAndTestEvents;
import sheridan.gunscraft.events.PlayerEvents;
import sheridan.gunscraft.events.RenderEvents;
import sheridan.gunscraft.events.ServerEvents;
import sheridan.gunscraft.items.ModItems;
import sheridan.gunscraft.keybind.KeyBinds;
import sheridan.gunscraft.network.PacketHandler;
import sheridan.gunscraft.render.entities.GenericProjectileRenderer;
import sheridan.gunscraft.screen.NewAttachmentScreen;
import sheridan.gunscraft.screen.VendingMachineScreen;
import sheridan.gunscraft.sounds.SoundEvents;
import sheridan.gunscraft.tabs.ModTabs;

@Mod(value="gunscraft")
public class Gunscraft {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final int INNER_VERSION = 371;
    public static final String MOD_ID = "gunscraft";
    public static final boolean IN_DEVELOPMENT = false;

    public Gunscraft() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::enqueueIMC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::processIMC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::doClientStuff);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register(PlayerEvents.class);
        MinecraftForge.EVENT_BUS.register(PlayerStatusEvents.class);
        MinecraftForge.EVENT_BUS.register(GunPropertiesHandler.class);
        MinecraftForge.EVENT_BUS.register(VendingMachineProductsHandler.class);
        MinecraftForge.EVENT_BUS.register(ServerEvents.class);
        MinecraftForge.EVENT_BUS.addGenericListener(Entity.class, this::attachCapabilityEvent);
        ModItems.ITEMS.register(FMLJavaModLoadingContext.get().getModEventBus());
        ModBlocks.BLOCKS.register(FMLJavaModLoadingContext.get().getModEventBus());
        ModTabs.MOD_TABS.register(FMLJavaModLoadingContext.get().getModEventBus());
        ModContainers.REGISTER.register(FMLJavaModLoadingContext.get().getModEventBus());
        EntityRegister.ENTITIES.register(FMLJavaModLoadingContext.get().getModEventBus());
        SoundEvents.register(FMLJavaModLoadingContext.get().getModEventBus());
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::gatherDataEvent);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)CommonConfig.SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ClientConfig.SPEC);
    }

    public void attachCapabilityEvent(AttachCapabilitiesEvent<Entity> event) {
        Player player;
        Object object = event.getObject();
        if (object instanceof Player && !(player = (Player)object).getCapability(PlayerStatusProvider.CAPABILITY).isPresent()) {
            event.addCapability(new ResourceLocation(MOD_ID, "player_status"), (ICapabilityProvider)new PlayerStatusProvider());
        }
    }

    private void setup(FMLCommonSetupEvent event) {
        PacketHandler.register();
        Commons.INSTANCE.commonSetUp(event);
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        Clients.init();
        FMLJavaModLoadingContext.get().getModEventBus().addListener(KeyBinds::register);
        MinecraftForge.EVENT_BUS.register(DebugAndTestEvents.class);
        MinecraftForge.EVENT_BUS.register(RenderEvents.class);
        MinecraftForge.EVENT_BUS.register(ClientTickEvents.class);
        MinecraftForge.EVENT_BUS.register(ControllerEvents.class);
        Clients.INSTANCE.setUpClient(event);
        event.enqueueWork(() -> MenuScreens.m_96206_((MenuType)((MenuType)ModContainers.ATTACHMENTS.get()), NewAttachmentScreen::new));
        event.enqueueWork(() -> MenuScreens.m_96206_((MenuType)((MenuType)ModContainers.VENDING_MACHINE.get()), VendingMachineScreen::new));
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
        InterModComms.sendTo((String)"assets/gunscraft", (String)"helloworld", () -> {
            LOGGER.info("Hello world from the MDK");
            return "Hello world";
        });
    }

    private void processIMC(InterModProcessEvent event) {
        LOGGER.info("Got IMC {}", event.getIMCStream().map(m -> m.getMessageSupplier().get()).collect(Collectors.toList()));
    }

    private void gatherDataEvent(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(event.includeServer(), (DataProvider)new GunPropertiesProvider(output, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new VendingMachineProductsProvider(output, lookupProvider));
    }

    @Mod.EventBusSubscriber(modid="gunscraft", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @OnlyIn(value=Dist.CLIENT)
        @SubscribeEvent
        public static void onRegisterRenderer(EntityRenderersEvent.RegisterRenderers event) {
            event.registerEntityRenderer((EntityType)EntityRegister.GENERIC_PROJECTILE.get(), GenericProjectileRenderer::new);
        }

        @OnlyIn(value=Dist.CLIENT)
        @SubscribeEvent
        public static void registerKeyMapping(RegisterKeyMappingsEvent event) {
            KeyBinds.register(event);
        }

        @OnlyIn(value=Dist.CLIENT)
        @SubscribeEvent
        public static void onRegisterParticleFactories(RegisterParticleProvidersEvent event) {
        }
    }
}

