/*
 * Decompiled with CFR 0.152.
 */
package sheridan.gunscraft.animation.curve;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import sheridan.gunscraft.animation.IAnimation;
import sheridan.gunscraft.animation.curve.Curve;
import sheridan.gunscraft.animation.curve.ICurveAnimationProxy;
import sheridan.gunscraft.render.utils.Quaternions;

@OnlyIn(value=Dist.CLIENT)
public class CurveAnimation
implements IAnimation {
    private float progress;
    public float length;
    public float timer;
    public boolean completed;
    public Curve[] curves;
    public float tempTX;
    public float tempTY;
    public float tempTZ;
    public float tempRX;
    public float tempRY;
    public float tempRZ;
    public float tempSX;
    public float tempSY;
    public float tempSZ;
    public ICurveAnimationProxy animationProxy;

    public CurveAnimation(Curve[] ICurves, float length) {
        this.curves = ICurves;
        this.length = length;
    }

    @Override
    public void play(float delta, PoseStack poseStackIn, ItemDisplayContext transformType) {
        this.update(delta);
        if (!this.completed) {
            this.computing(poseStackIn, transformType);
        }
    }

    @Override
    public void play(long beginTime, PoseStack poseStackIn, ItemDisplayContext transformType) {
        long dis = System.currentTimeMillis() - beginTime;
        float delta = (float)dis / 1000.0f;
        this.reset();
        this.update(delta);
        if (!this.completed) {
            this.computing(poseStackIn, transformType);
        }
    }

    private void update(float delta) {
        this.timer += delta;
        this.progress = this.timer / this.length;
        this.completed = false;
        if (this.progress >= 1.0f) {
            this.progress = 0.0f;
            this.timer = 0.0f;
            this.completed = true;
        }
    }

    private void computing(PoseStack poseStack, ItemDisplayContext transformType) {
        this.tempTX = this.curves.length > 0 && this.curves[0] != null ? this.curves[0].play(this.progress) : 0.0f;
        this.tempTY = this.curves.length > 1 && this.curves[1] != null ? this.curves[1].play(this.progress) : 0.0f;
        this.tempTZ = this.curves.length > 2 && this.curves[2] != null ? this.curves[2].play(this.progress) : 0.0f;
        this.tempRX = this.curves.length > 3 && this.curves[3] != null ? this.curves[3].play(this.progress) : 0.0f;
        this.tempRY = this.curves.length > 4 && this.curves[4] != null ? this.curves[4].play(this.progress) : 0.0f;
        this.tempRZ = this.curves.length > 5 && this.curves[5] != null ? this.curves[5].play(this.progress) : 0.0f;
        this.tempSX = this.curves.length > 6 && this.curves[6] != null ? this.curves[6].play(this.progress) : 1.0f;
        this.tempSY = this.curves.length > 7 && this.curves[7] != null ? this.curves[7].play(this.progress) : 1.0f;
        float f = this.tempSZ = this.curves.length > 8 && this.curves[8] != null ? this.curves[8].play(this.progress) : 1.0f;
        if (this.animationProxy != null) {
            this.animationProxy.beforeApplyTransform(this, transformType);
        }
        this.applyTransform(poseStack);
    }

    private void applyTransform(PoseStack poseStack) {
        if (this.tempTX != 0.0f || this.tempTY != 0.0f || this.tempTZ != 0.0f) {
            poseStack.m_252880_(this.tempTX, this.tempTY, this.tempTZ);
        }
        if (this.tempRX != 0.0f || this.tempRY != 0.0f || this.tempRZ != 0.0f) {
            poseStack.m_252781_(Quaternions.rotateDeg(this.tempRX, this.tempRY, this.tempRZ));
        }
        if (this.tempSX != 1.0f || this.tempSY != 1.0f || this.tempSZ != 1.0f) {
            poseStack.m_85841_(this.tempSX, this.tempSY, this.tempSZ);
        }
    }

    @Override
    public float getProgress() {
        return this.progress;
    }

    @Override
    public void setProgress(float progress) {
        this.progress = progress;
    }

    @Override
    public boolean isCompleted() {
        return this.completed;
    }

    @Override
    public void reset() {
        this.completed = false;
        this.progress = 0.0f;
        this.timer = 0.0f;
    }
}

