/*
 * Decompiled with CFR 0.152.
 */
package sheridan.gunscraft.animation.keyFrame;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Vector3f;
import sheridan.gunscraft.animation.keyFrame.copyAniamtion.AnimationChannel;
import sheridan.gunscraft.animation.keyFrame.copyAniamtion.AnimationDefinition;
import sheridan.gunscraft.animation.keyFrame.copyAniamtion.HierarchicalModel;
import sheridan.gunscraft.animation.keyFrame.copyAniamtion.Keyframe;
import sheridan.gunscraft.model.modelPartCopy.ModelPart;
import sheridan.gunscraft.sounds.SoundEvents;

@OnlyIn(value=Dist.CLIENT)
public class FrameAnimation {
    public static final Vector3f DEFAULT_DIRECTION = new Vector3f(1.0f, 1.0f, 1.0f);

    public static void animate(HierarchicalModel<?> root, AnimationDefinition definition, long startTime, long shift, float scale, Vector3f direction, boolean stopIfOutOfTime) {
        float timeDis = (float)(System.currentTimeMillis() - (startTime + shift)) / 1000.0f;
        if (stopIfOutOfTime && !definition.looping() && timeDis > definition.lengthInSeconds()) {
            return;
        }
        float f = definition.looping() ? timeDis % definition.lengthInSeconds() : timeDis;
        for (Map.Entry<String, List<AnimationChannel>> entry : definition.boneAnimations().entrySet()) {
            Optional<ModelPart> optional = root.getAnyDescendantWithName(entry.getKey());
            List<AnimationChannel> list = entry.getValue();
            optional.ifPresent(modelPart -> list.forEach(channel -> {
                Keyframe[] keyframes = channel.keyframes();
                int currentIndex = Math.max(0, Mth.m_14049_((int)0, (int)keyframes.length, p_232315_ -> f <= keyframes[p_232315_].timestamp()) - 1);
                int nextIndex = Math.min(keyframes.length - 1, currentIndex + 1);
                Keyframe prevFrame = keyframes[currentIndex];
                Keyframe nextFrame = keyframes[nextIndex];
                float f1 = f - prevFrame.timestamp();
                float f2 = nextIndex != currentIndex ? Mth.m_14036_((float)(f1 / (nextFrame.timestamp() - prevFrame.timestamp())), (float)0.0f, (float)1.0f) : 0.0f;
                nextFrame.interpolation().apply(direction, f2, keyframes, currentIndex, nextIndex, scale);
                channel.target().apply((ModelPart)modelPart, direction);
            }));
        }
    }

    public static void animate(HierarchicalModel<?> root, AnimationDefinition definition, long startTime, long shift, float scale, Vector3f direction) {
        FrameAnimation.animate(root, definition, startTime, shift, scale, direction, true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class SoundPoint {
        public int tick;
        public String soundName;

        public SoundPoint(int tick, String soundName) {
            this.tick = tick;
            this.soundName = soundName;
        }

        public void playSound() {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player != null) {
                SoundEvents.playSound(this.soundName, (LivingEntity)player, 1.0f, 1.0f);
            }
        }
    }
}

